/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.browser;

import alma.archive.commands.EntityList;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GetList
extends HttpServlet {
    private Templates listTemplate;
    private int numEntityList = 1;
    private InternalIF internal = null;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        String string = httpServletRequest.getParameter("uri");
        String string2 = httpServletRequest.getParameter("action");
        String string3 = httpServletRequest.getParameter("format");
        String string4 = httpServletRequest.getParameter("xpath");
        String string5 = httpServletRequest.getParameter("schema");
        String string6 = httpServletRequest.getParameter("list");
        boolean bl = false;
        URI uRI = null;
        if (string != null && !string.equalsIgnoreCase("")) {
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                bl = true;
            }
        }
        HttpSession httpSession = httpServletRequest.getSession(true);
        int n = 0;
        if (string6 != null) {
            n = Integer.parseInt(string6);
            httpSession.setAttribute("lastList", (Object)Integer.toString(n));
        } else {
            object2 = (String)httpSession.getAttribute("lastList");
            if (object2 != null) {
                n = Integer.parseInt((String)object2);
            }
        }
        object2 = (ArrayList)httpSession.getAttribute("EntityArray");
        if (object2 == null) {
            try {
                object2 = new ArrayList<Object>();
                for (int i = 0; i < this.numEntityList; ++i) {
                    object = new EntityList(this.internal);
                    ((ArrayList)object2).add(i, object);
                }
            }
            catch (DatabaseException databaseException) {
                throw new UnavailableException("List has a database problem");
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new UnavailableException("List has a database problem");
            }
            httpSession.setAttribute("EntityArray", object2);
        }
        EntityList entityList = (EntityList)((ArrayList)object2).get(n);
        if (string2 != null) {
            try {
                if (string2.equalsIgnoreCase("remove") && uRI != null) {
                    entityList.removeEntity(uRI);
                } else if (string2.equalsIgnoreCase("refresh")) {
                    entityList.refresh();
                } else if (string2.equalsIgnoreCase("Query")) {
                    if (uRI != null) {
                        entityList.queryURI(uRI);
                    } else if (string4 != null) {
                        entityList.queryXPath(string4, string5);
                    }
                } else if (string2.equalsIgnoreCase("clear")) {
                    entityList.removeAll();
                } else if (string2.equalsIgnoreCase("zip")) {
                    object = httpServletResponse.getOutputStream();
                    httpServletResponse.setContentType("application/x-zip-compressed");
                    entityList.WriteOutputStream((OutputStream)object);
                    ((OutputStream)object).flush();
                    return;
                }
            }
            catch (ArchiveException archiveException) {
                bl = true;
            }
            catch (ModuleCriticalException moduleCriticalException) {
                bl = true;
            }
        }
        object = entityList.getElement();
        if (string3.equalsIgnoreCase("xml")) {
            this.showXmlPage((Element)object, httpServletResponse);
        } else if (string3.equalsIgnoreCase("html")) {
            if (string4 == null) {
                string4 = "";
            }
            this.showHtmlPage((Element)object, this.listTemplate, httpServletResponse, n, string4, this.numEntityList, bl);
        }
    }

    private void showHtmlPage(Element element, Templates templates, HttpServletResponse httpServletResponse, int n, String string, int n2, boolean bl) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        String string2 = xMLOutputter.outputString(element);
        StreamSource streamSource = new StreamSource(new StringReader(string2));
        PrintWriter printWriter = httpServletResponse.getWriter();
        this.addHeader(printWriter, n, n2, bl);
        httpServletResponse.setContentType("text/html");
        try {
            Transformer transformer = templates.newTransformer();
            transformer.setParameter("selected", Integer.toString(n));
            transformer.setParameter("path", string);
            transformer.transform(streamSource, new StreamResult(printWriter));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void addHeader(PrintWriter printWriter, int n, int n2, boolean bl) {
        printWriter.println("<html>");
        printWriter.println("\t<head>");
        printWriter.println("\t    <META HTTP-EQUIV=\"Refresh\"");
        printWriter.println("\t    CONTENT=\"30; URL=/ArchiveManager/getlist?format=html&action=refresh\">");
        printWriter.println("\t</head>");
        printWriter.println("\t<body>");
        printWriter.println("\t\t<table width=\"500\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">");
        printWriter.println("\t\t\t<tr>");
        printWriter.println("\t\t\t\t<td><a href=\"/ArchiveManager/getlist?format=html&action=refresh\">Refresh</a></td>");
        for (int i = 0; i < n2; ++i) {
            if (i == n) {
                if (bl) {
                    printWriter.println("\t\t\t\t<td bgcolor=\"red\" align=\"center\">" + i + "</td>");
                    continue;
                }
                printWriter.println("\t\t\t\t<td class=\"ver\" align=\"center\">" + i + "</td>");
                continue;
            }
            printWriter.println("\t\t\t\t<td align=\"center\"><a href=\"/ArchiveManager/getlist?format=html&action=refresh&list=" + i + "\">" + i + "</a></td>");
        }
        printWriter.println("\t\t\t\t<td><a href=\"/ArchiveManager/getlist?format=html&action=zip\">Zip</a></td>");
        printWriter.println("\t\t\t</tr>");
        printWriter.println("\t\t</table>");
        printWriter.println("\t</body>");
        printWriter.println("</html>");
    }

    private void showXmlPage(Element element, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        printWriter.print(xMLOutputter.outputString(element));
    }

    public void init() throws ServletException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            String string = "/WEB-INF/xslt/entity.xslt";
            URL uRL = this.getServletContext().getResource(string);
            if (uRL == null) {
                throw new MalformedURLException();
            }
            this.listTemplate = transformerFactory.newTemplates(new StreamSource(uRL.toExternalForm()));
            String string2 = this.getServletContext().getInitParameter("numlists");
            this.numEntityList = Integer.parseInt(string2);
            this.internal = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
            this.internal.init();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.log("Unable to compile stylesheet", transformerConfigurationException);
            throw new UnavailableException("Unable to compile stylesheet");
        }
        catch (MalformedURLException malformedURLException) {
            this.log("Unable to locate XSLT file");
            throw new UnavailableException("Unable to locate XSLT file");
        }
        catch (DatabaseException databaseException) {
            this.log("Problems connecting to the database");
            throw new UnavailableException(databaseException.getLocalizedMessage());
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Problems connecting to the database");
            throw new UnavailableException(moduleCriticalException.getLocalizedMessage());
        }
    }

    public void destroy() {
        try {
            this.internal.close();
        }
        catch (DatabaseException databaseException) {
            this.log("Problems connecting to the database");
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Problems connecting to the database");
        }
    }
}

