/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.browser;

import alma.archive.commands.SchemaManagerXML;
import alma.archive.commands.XMLClassPath;
import alma.archive.database.helpers.DBConfiguration;
import alma.archive.database.interfaces.InternalIF;
import alma.archive.database.interfaces.InternalIFFactory;
import alma.archive.exceptions.ArchiveException;
import alma.archive.exceptions.ModuleCriticalException;
import alma.archive.exceptions.general.DatabaseException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GetForm
extends HttpServlet {
    private String numEntityList;
    private Templates queryTemplate;
    private Templates configTemplate;
    private InternalIF internalif = null;
    private SchemaManagerXML smanagerx = null;
    private DBConfiguration dbconfig = null;
    private XMLClassPath classpath = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("form");
        String string2 = httpServletRequest.getParameter("format");
        if (string == null) return;
        if (string.equalsIgnoreCase("query")) {
            try {
                if (string2.equalsIgnoreCase("html")) {
                    this.showHtmlPage(this.smanagerx.getElement(), this.queryTemplate, httpServletResponse);
                    return;
                }
                if (!string2.equalsIgnoreCase("xml")) return;
                this.showXmlPage(this.smanagerx.getElement(), httpServletResponse);
                return;
            }
            catch (ArchiveException archiveException) {
                throw new UnavailableException("Problems accessing the Archive");
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new UnavailableException("Problems accessing the Archive");
            }
        } else {
            if (!string.equalsIgnoreCase("status")) return;
            if (string2.equalsIgnoreCase("html")) {
                this.showHtmlPage(this.dbconfig.toElement(), this.configTemplate, httpServletResponse);
                this.showHtmlPage(this.classpath.toElement(), this.configTemplate, httpServletResponse);
                return;
            } else {
                if (!string2.equalsIgnoreCase("xml")) return;
                this.showXmlPage(this.dbconfig.toElement(), httpServletResponse);
            }
        }
    }

    private void showHtmlPage(Element element, Templates templates, HttpServletResponse httpServletResponse) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        String string = xMLOutputter.outputString(element);
        StreamSource streamSource = new StreamSource(new StringReader(string));
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        try {
            Transformer transformer = templates.newTransformer();
            String string2 = transformer.getClass().getName();
            transformer.setParameter("numEntityList", this.numEntityList);
            transformer.setParameter("transformerName", string2);
            transformer.transform(streamSource, new StreamResult(printWriter));
        }
        catch (Exception exception) {
            exception.printStackTrace(printWriter);
        }
    }

    private void showXmlPage(Element element, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        printWriter.print(xMLOutputter.outputString(element));
    }

    public void init() throws ServletException {
        System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            String string = "/WEB-INF/xslt/query.xslt";
            URL uRL = this.getServletContext().getResource(string);
            if (uRL == null) {
                throw new MalformedURLException();
            }
            this.queryTemplate = transformerFactory.newTemplates(new StreamSource(uRL.toExternalForm()));
            String string2 = "/WEB-INF/xslt/config.xslt";
            URL uRL2 = this.getServletContext().getResource(string2);
            if (uRL2 == null) {
                throw new MalformedURLException();
            }
            this.configTemplate = transformerFactory.newTemplates(new StreamSource(uRL2.toExternalForm()));
            try {
                this.internalif = InternalIFFactory.getInternalIF((Logger)Logger.getAnonymousLogger());
                this.smanagerx = SchemaManagerXML.instance("browser", this.internalif);
                this.internalif.init();
                this.dbconfig = DBConfiguration.instance((Logger)Logger.getAnonymousLogger());
                this.classpath = new XMLClassPath();
            }
            catch (ArchiveException archiveException) {
                throw new ServletException(archiveException.getMessage());
            }
            catch (ModuleCriticalException moduleCriticalException) {
                throw new ServletException(moduleCriticalException.getMessage());
            }
            this.numEntityList = this.getServletContext().getInitParameter("numlists");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.log("Unable to compile stylesheet", transformerConfigurationException);
            throw new UnavailableException("Unable to compile stylesheet: " + transformerConfigurationException.getLocalizedMessage());
        }
        catch (MalformedURLException malformedURLException) {
            this.log("Unable to locate XSLT file");
            throw new UnavailableException("Unable to locate XSLT file: " + malformedURLException.getLocalizedMessage());
        }
    }

    public void destroy() {
        try {
            this.smanagerx.close();
            this.internalif.close();
        }
        catch (DatabaseException databaseException) {
            this.log("Problems closong the internal interface", databaseException);
        }
        catch (ModuleCriticalException moduleCriticalException) {
            this.log("Problems closong the internal interface", moduleCriticalException);
        }
        super.destroy();
    }
}

