/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.ngasLogger;

import alma.acs.component.client.ComponentClient;
import alma.acs.logging.AcsLogger;
import alma.archive.ngasLogger.NgasLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.logging.Level;

public class NgasLogger {
    private final int ERROR_TRY_TIME = 10;
    private final int WAIT_FOR_CREATE_FILE = 300;
    private static final String DEFAULT_NGASLOG = "LogFile.nglog";
    private BufferedReader ngaslog;
    private File logfile;
    private AcsLogger m_logger;

    public static void main(String[] stringArray) throws Exception {
        String string = DEFAULT_NGASLOG;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        NgasLogger ngasLogger = new NgasLogger(string);
        ngasLogger.read_parse_log();
    }

    public NgasLogger(String string) throws Exception {
        String string2 = "ngasLogger";
        String string3 = System.getProperty("ACS.manager");
        if (string3 == null) {
            System.out.println("Java property 'ACS.manager' must be set to the corbaloc of the ACS manager!");
            System.exit(-1);
        }
        ComponentClient componentClient = new ComponentClient(null, string3, string2);
        this.m_logger = componentClient.getContainerServices().getLogger();
        this.logfile = new File(string);
        if (!this.logfile.exists()) {
            this.m_logger.log(Level.SEVERE, "File doesn't exist.");
            System.exit(-1);
        }
        this.ngaslog = new BufferedReader(new FileReader(string));
    }

    public void read_parse_log() throws Exception {
        while (true) {
            int n;
            if (!this.ngaslog.ready()) {
                continue;
            }
            String string = this.ngaslog.readLine();
            NgasLog ngasLog = new NgasLog(string);
            this.m_logger.log(ngasLog.get_LogRecord());
            if (!ngasLog.isLastLog().booleanValue()) continue;
            File file = new File(ngasLog.getRotatedFile());
            for (n = 0; n <= 10; ++n) {
                if (n == 10) {
                    this.m_logger.log(Level.SEVERE, file.toString() + " fails rotating.");
                    System.exit(-1);
                }
                if (file.exists()) break;
                Thread.sleep(300L);
            }
            this.m_logger.log(Level.INFO, file.toString() + " is already rotated");
            this.ngaslog.close();
            for (n = 0; n <= 10; ++n) {
                if (n == 10) {
                    this.m_logger.log(Level.SEVERE, this.logfile.toString() + " fails creating.");
                    System.exit(-1);
                }
                if (this.logfile.exists()) break;
                Thread.sleep(300L);
            }
            this.m_logger.log(Level.INFO, this.logfile.toString() + " is already created");
            this.ngaslog = new BufferedReader(new FileReader(this.logfile));
        }
    }
}

