/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.layers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.UIModeManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.layers.ICFolderImpl;
import org.netbeans.core.windows.layers.WindowManagerData;
import org.netbeans.core.windows.layers.WorkspaceData;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WindowManagerData
extends DataFolder
implements CookieSet.Factory {
    private static final String INSTANCE_DTD_ID_1_0 = "-//NetBeans//DTD Window Manager Properties 1.0//EN";
    private static final String INSTANCE_DTD_ID_1_1 = "-//NetBeans//DTD Window Manager Properties 1.1//EN";
    private FileObject windowmanagerConfigFO;
    private InstanceCookieImpl instCookieImpl;
    private static Object SAVING = new Object();
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$WindowManagerData;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$core$windows$layers$ResetCookie;

    public WindowManagerData(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.initCookies();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$layers$WindowManagerData == null ? (class$org$netbeans$core$windows$layers$WindowManagerData = WindowManagerData.class$("org.netbeans.core.windows.layers.WindowManagerData")) : class$org$netbeans$core$windows$layers$WindowManagerData);
    }

    public boolean isRenameAllowed() {
        return false;
    }

    private void initCookies() {
        this.getCookieSet().add(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WindowManagerData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WindowManagerData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie, (CookieSet.Factory)this);
        this.getCookieSet().add(class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WindowManagerData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie, (CookieSet.Factory)this);
    }

    public Node.Cookie getCookie(Class klass) {
        Node.Cookie ret = super.getCookie(klass);
        return ret;
    }

    WindowManagerImpl getWindowManagerImpl() throws IOException {
        return this.instanceCookieImpl().obtainWindowManagerImpl();
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz == (class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = WindowManagerData.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) || clazz == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = WindowManagerData.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || clazz == (class$org$netbeans$core$windows$layers$ResetCookie == null ? (class$org$netbeans$core$windows$layers$ResetCookie = WindowManagerData.class$("org.netbeans.core.windows.layers.ResetCookie")) : class$org$netbeans$core$windows$layers$ResetCookie)) {
            return this.instanceCookieImpl();
        }
        return null;
    }

    private synchronized InstanceCookieImpl instanceCookieImpl() {
        if (this.instCookieImpl != null) {
            return this.instCookieImpl;
        }
        this.instCookieImpl = new InstanceCookieImpl(this);
        return this.instCookieImpl;
    }

    FileObject getWindowManagerConfigFO() {
        if (this.windowmanagerConfigFO == null) {
            FileObject curFo = null;
            Iterator iter = this.files().iterator();
            while (iter.hasNext()) {
                curFo = (FileObject)iter.next();
                if (!curFo.hasExt("wswmgr")) continue;
                this.windowmanagerConfigFO = curFo;
                break;
            }
        }
        return this.windowmanagerConfigFO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class PropertyHandler
    extends DefaultHandler {
        private WindowManagerData folder;
        private FileObject fo;
        private WindowManagerConfig winMgrConfig;
        private XMLReader parser;
        private final Object RW_LOCK = new Object();
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WindowManagerData;

        public PropertyHandler(WindowManagerData folder) {
            this.folder = folder;
            this.fo = folder.getWindowManagerConfigFO();
        }

        public WindowManagerConfig readData() throws SAXException, IOException {
            this.winMgrConfig = new WindowManagerConfig();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.getXMLParser().parse(new InputSource(this.fo.getInputStream()));
            }
            return this.winMgrConfig;
        }

        public void startElement(String nameSpace, String name, String qname, Attributes attrs) throws SAXException {
            if ("main-window".equals(qname)) {
                this.handleMainWindow(attrs);
            } else if ("screen".equals(qname)) {
                this.handleScreen(attrs);
            } else if ("ui-mode".equals(qname)) {
                this.handleUIMode(attrs);
            } else if ("active".equals(qname)) {
                this.handleActive(attrs);
            }
        }

        public void error(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            throw ex;
        }

        public void warning(SAXParseException ex) throws SAXException {
        }

        private void handleMainWindow(Attributes attrs) {
            if (this.winMgrConfig.mainWindowBounds == null) {
                this.winMgrConfig.mainWindowBounds = Utilities.getUsableScreenBounds();
            }
            try {
                String s = attrs.getValue("x");
                if ("center".equals(s)) {
                    this.winMgrConfig.centerMainWindowX = true;
                } else {
                    this.winMgrConfig.mainWindowBounds.x = Integer.parseInt(s);
                }
                s = attrs.getValue("y");
                if ("center".equals(s)) {
                    this.winMgrConfig.centerMainWindowY = true;
                } else {
                    this.winMgrConfig.mainWindowBounds.y = Integer.parseInt(s);
                }
                s = attrs.getValue("maximized");
                this.winMgrConfig.maximizedMainWindow = "true".equals(s);
                int relativeWidth = 0;
                int relativeHeight = 0;
                int width = 0;
                int height = 0;
                Dimension screenSize = Utilities.getUsableScreenBounds().getSize();
                s = attrs.getValue("relative-width");
                if (s != null) {
                    relativeWidth = !WindowUtils.isMdi() ? 100 : Integer.parseInt(s);
                    width = (int)((double)(relativeWidth * screenSize.width) / 100.0);
                } else {
                    s = attrs.getValue("width");
                    width = Integer.parseInt(s);
                }
                s = attrs.getValue("relative-height");
                if (s != null) {
                    relativeHeight = Integer.parseInt(s);
                    height = (int)((double)(relativeHeight * screenSize.height) / 100.0);
                } else {
                    s = attrs.getValue("height");
                    height = Integer.parseInt(s);
                }
                this.winMgrConfig.mainWindowBounds.width = width;
                this.winMgrConfig.mainWindowBounds.height = height;
                s = attrs.getValue("maximize-if-height-bellow");
                this.winMgrConfig.minHeight = s != null ? Integer.parseInt(s) : 0;
                s = attrs.getValue("maximize-if-width-bellow");
                this.winMgrConfig.minWidth = s != null ? Integer.parseInt(s) : 0;
            }
            catch (NumberFormatException exc) {
                this.winMgrConfig.mainWindowBounds = null;
                String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WindowManagerData == null ? (class$org$netbeans$core$windows$layers$WindowManagerData = PropertyHandler.class$("org.netbeans.core.windows.layers.WindowManagerData")) : class$org$netbeans$core$windows$layers$WindowManagerData), (String)"EXC_WindowManagerBounds", (Object[])new Object[]{this.fo.getName()});
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
        }

        private void handleScreen(Attributes attrs) {
            if (this.winMgrConfig.screenSize == null) {
                this.winMgrConfig.screenSize = new Dimension();
            }
            try {
                this.winMgrConfig.screenSize.width = Integer.parseInt(attrs.getValue("width"));
                this.winMgrConfig.screenSize.height = Integer.parseInt(attrs.getValue("height"));
            }
            catch (NumberFormatException exc) {
                this.winMgrConfig.screenSize = null;
                String annotation = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WindowManagerData == null ? (class$org$netbeans$core$windows$layers$WindowManagerData = PropertyHandler.class$("org.netbeans.core.windows.layers.WindowManagerData")) : class$org$netbeans$core$windows$layers$WindowManagerData), (String)"EXC_WindowManagerScreenSize", (Object[])new Object[]{this.fo.getName()});
                ErrorManager.getDefault().annotate((Throwable)exc, annotation);
                ErrorManager.getDefault().notify(16, (Throwable)exc);
            }
        }

        private void handleUIMode(Attributes attrs) {
            String uiModeStr = attrs.getValue("ui");
            this.winMgrConfig.uiMode = "mdi".equals(uiModeStr) ? 2 : 1;
        }

        private void handleActive(Attributes attrs) {
            this.winMgrConfig.activeWorkspace = attrs.getValue("workspace");
        }

        public void endDocument() throws SAXException {
        }

        public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
        }

        public void endElement(String str, String str1, String str2) throws SAXException {
        }

        public void skippedEntity(String str) throws SAXException {
        }

        public void processingInstruction(String str, String str1) throws SAXException {
        }

        public void endPrefixMapping(String str) throws SAXException {
        }

        public void startPrefixMapping(String str, String str1) throws SAXException {
        }

        public void characters(char[] values, int param, int param2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void writeData() throws IOException {
            StringBuffer buff = this.fillBuffer();
            Object object = this.RW_LOCK;
            synchronized (object) {
                this.fo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this, buff){
                    private final /* synthetic */ StringBuffer val$buff;
                    private final /* synthetic */ PropertyHandler this$0;
                    {
                        this.this$0 = this$0;
                        this.val$buff = val$buff;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() throws IOException {
                        FileLock lock;
                        block3: {
                            lock = PropertyHandler.access$300(this.this$0).lock();
                            OutputStreamWriter osw = null;
                            try {
                                OutputStream os = PropertyHandler.access$300(this.this$0).getOutputStream(lock);
                                osw = new OutputStreamWriter(os, "UTF-8");
                                osw.write(this.val$buff.toString());
                                Object var5_4 = null;
                                if (osw == null) break block3;
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                if (osw != null) {
                                    osw.close();
                                }
                                lock.releaseLock();
                                throw throwable;
                            }
                            osw.close();
                        }
                        lock.releaseLock();
                    }
                });
            }
        }

        private StringBuffer fillBuffer() throws IOException {
            WindowManagerImpl wmi = this.folder.getWindowManagerImpl();
            StringBuffer buff = new StringBuffer(800);
            Object curValue = null;
            buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            buff.append("<windowmanager version=\"1.0\">\n");
            this.appendMainWindow(wmi, buff);
            this.appendScreen(wmi, buff);
            this.appendUIMode(wmi, buff);
            this.appendActiveWorkspace(wmi, buff);
            buff.append("</windowmanager>\n");
            return buff;
        }

        private void appendMainWindow(WindowManagerImpl windowManagerImpl, StringBuffer buff) {
            MainWindow mainWindow = MainWindow.getDefault();
            Rectangle bounds = mainWindow.getBounds();
            boolean maximized = false;
            if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
                try {
                    Method method = mainWindow.getClass().getMethod("getExtendedState", new Class[0]);
                    Integer state = (Integer)method.invoke((Object)mainWindow, new Object[0]);
                    maximized = (state & 6) == 6;
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            buff.append("    <main-window");
            buff.append(" x=\"");
            buff.append(bounds.x);
            buff.append("\" y=\"");
            buff.append(bounds.y);
            buff.append("\" width=\"");
            buff.append(bounds.width);
            buff.append("\" height=\"");
            buff.append(bounds.height);
            buff.append("\" maximized=\"");
            buff.append(maximized ? "true" : "false");
            buff.append("\" />\n");
        }

        private void appendScreen(WindowManagerImpl windowManagerImpl, StringBuffer buff) {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            buff.append("    <screen");
            buff.append(" width=\"");
            buff.append(size.width);
            buff.append("\" height=\"");
            buff.append(size.height);
            buff.append("\" />\n");
        }

        private void appendUIMode(WindowManagerImpl windowManagerImpl, StringBuffer buff) {
            int uiMode = UIModeManager.getDefault().getUIMode();
            buff.append("    <ui-mode");
            buff.append(" ui=\"");
            if (uiMode == 2) {
                buff.append("mdi");
            } else {
                buff.append("sdi");
            }
            buff.append("\" />\n");
        }

        private void appendActiveWorkspace(WindowManagerImpl windowManagerImpl, StringBuffer buff) {
            Workspace w = windowManagerImpl.getCurrentWorkspace();
            buff.append("    <active");
            buff.append(" workspace=\"");
            if (w != null) {
                buff.append(w.getName());
            }
            buff.append("\" />\n");
        }

        private XMLReader getXMLParser() throws SAXException {
            if (this.parser == null) {
                this.parser = XMLUtil.createXMLReader();
                this.parser.setContentHandler(this);
                this.parser.setErrorHandler(this);
                this.parser.setEntityResolver(this);
            }
            return this.parser;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (WindowManagerData.INSTANCE_DTD_ID_1_0.equals(publicId) || WindowManagerData.INSTANCE_DTD_ID_1_1.equals(publicId)) {
                ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
                return new InputSource(is);
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ FileObject access$300(PropertyHandler x0) {
            return x0.fo;
        }
    }

    private static final class InstanceCookieImpl
    extends ICFolderImpl
    implements SaveCookie,
    LazyUpdater,
    FileSystem.AtomicAction {
        WindowManagerImpl windowManagerImpl;
        PropertyHandler propertyHandler;
        WindowManagerConfig wmc;
        int loadedSections = 0;
        boolean spacesUpdated = false;
        private boolean setMainWindowBounds = true;
        private final Object DATA_ID_LOCK = new Object();
        static /* synthetic */ Class class$org$openide$windows$Workspace;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;
        static /* synthetic */ Class class$org$netbeans$core$windows$layers$WorkspaceData;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public InstanceCookieImpl(DataFolder df) {
            super(df, FileUtil.findBrother((FileObject)df.getPrimaryFile(), (String)"wswmgr"), class$org$openide$windows$Workspace == null ? (class$org$openide$windows$Workspace = InstanceCookieImpl.class$("org.openide.windows.Workspace")) : class$org$openide$windows$Workspace);
        }

        public String instanceName() {
            return (class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl).getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = InstanceCookieImpl.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl;
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            WindowManagerImpl wmi;
            Object object = SAVING;
            synchronized (object) {
                wmi = this.obtainWindowManagerImpl();
                if (this.childrenCookies == null) {
                    wmi.attachUpdater(this);
                }
                InstanceCookie[] oldCookies = this.childrenCookies;
                this.childrenCookies = cookies;
                this.updateAll(oldCookies, cookies);
            }
            this.installListeners();
            return wmi;
        }

        private void updateAll(InstanceCookie[] oldCookies, InstanceCookie[] newCookies) throws IOException {
            if ((this.loadedSections & 1) != 0) {
                this.readProperties();
                this.setProperties();
            }
            if ((this.loadedSections & 2) != 0) {
                this.updateWorkspaces(oldCookies, newCookies);
            }
        }

        protected void updateProperties() throws IOException {
            if ((this.loadedSections & 1) != 0) {
                this.readProperties();
                this.setProperties();
            }
        }

        protected Object getDataLock() {
            return this.DATA_ID_LOCK;
        }

        private boolean readProperties() throws IOException {
            if (this.propertyHandler == null) {
                this.propertyHandler = new PropertyHandler((WindowManagerData)this.folder);
            }
            this.wmc = null;
            try {
                this.wmc = this.propertyHandler.readData();
            }
            catch (SAXException exc) {
                exc.printStackTrace();
                String msg = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$layers$WorkspaceData == null ? (class$org$netbeans$core$windows$layers$WorkspaceData = InstanceCookieImpl.class$("org.netbeans.core.windows.layers.WorkspaceData")) : class$org$netbeans$core$windows$layers$WorkspaceData), (String)"EXC_WindowManagerParse", (Object[])new Object[]{this.folder.getName()});
                IOException ioe = new IOException(msg);
                ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)exc);
                throw ioe;
            }
            return true;
        }

        private void setProperties() throws IOException {
            WindowManagerImpl wmi = this.obtainWindowManagerImpl();
            WindowManagerConfig wmcLocal = this.wmc;
            Mutex.EVENT.readAccess(new Runnable(this, wmcLocal, wmi){
                private final /* synthetic */ WindowManagerConfig val$wmcLocal;
                private final /* synthetic */ WindowManagerImpl val$wmi;
                private final /* synthetic */ InstanceCookieImpl this$0;
                {
                    this.this$0 = this$0;
                    this.val$wmcLocal = val$wmcLocal;
                    this.val$wmi = val$wmi;
                }

                public void run() {
                    if (InstanceCookieImpl.access$200(this.this$0)) {
                        if (this.val$wmcLocal.mainWindowBounds != null) {
                            WindowManagerImpl wmi;
                            boolean callSetBounds = true;
                            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                            if (this.val$wmcLocal.screenSize != null) {
                                WindowUtils.convertRectangle(this.val$wmcLocal.mainWindowBounds, this.val$wmcLocal.screenSize, screenSize);
                            }
                            if (this.val$wmcLocal.minWidth > 0 && this.val$wmcLocal.minHeight > 0) {
                                if (this.val$wmcLocal.minWidth < screenSize.width && this.val$wmcLocal.minHeight < screenSize.height) {
                                    if (this.val$wmcLocal.mainWindowBounds.width < this.val$wmcLocal.minWidth || this.val$wmcLocal.mainWindowBounds.height < this.val$wmcLocal.minHeight) {
                                        this.val$wmcLocal.mainWindowBounds.width = this.val$wmcLocal.minWidth;
                                        this.val$wmcLocal.mainWindowBounds.height = this.val$wmcLocal.minHeight;
                                    }
                                    if (this.val$wmcLocal.mainWindowBounds.width > screenSize.width || this.val$wmcLocal.mainWindowBounds.height > screenSize.height) {
                                        callSetBounds = false;
                                    }
                                } else {
                                    callSetBounds = false;
                                }
                            } else {
                                this.val$wmcLocal.mainWindowBounds.width = Math.min(this.val$wmcLocal.mainWindowBounds.width, screenSize.width);
                                this.val$wmcLocal.mainWindowBounds.height = Math.min(this.val$wmcLocal.mainWindowBounds.height, screenSize.height);
                            }
                            if (!(wmi = InstanceCookieImpl.access$000(this.this$0)).isMainPositioned() && callSetBounds) {
                                MainWindow main = MainWindow.getDefault();
                                if (WindowUtils.isMdi() && this.val$wmcLocal.maximizedMainWindow) {
                                    ((Component)main).setBounds(this.val$wmcLocal.mainWindowBounds);
                                    if (Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0) {
                                        MainWindow mainWindow = main;
                                        mainWindow.addComponentListener(new ComponentAdapter(this, mainWindow){
                                            private final /* synthetic */ Frame val$mainWindow;
                                            private final /* synthetic */ 1 this$1;
                                            {
                                                this.this$1 = this$1;
                                                this.val$mainWindow = val$mainWindow;
                                            }

                                            public void componentShown(ComponentEvent e) {
                                                this.val$mainWindow.removeComponentListener(this);
                                                try {
                                                    Method method = this.val$mainWindow.getClass().getMethod("setExtendedState", Integer.TYPE);
                                                    method.invoke((Object)this.val$mainWindow, new Integer(6));
                                                }
                                                catch (Exception ex) {
                                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    if (WindowUtils.isMdi()) {
                                        Rectangle rect = Utilities.findCenterBounds((Dimension)this.val$wmcLocal.mainWindowBounds.getSize());
                                        if (this.val$wmcLocal.centerMainWindowX) {
                                            this.val$wmcLocal.mainWindowBounds.x = rect.x;
                                        }
                                        if (this.val$wmcLocal.centerMainWindowY) {
                                            this.val$wmcLocal.mainWindowBounds.y = rect.y;
                                        }
                                    }
                                    ((Component)main).setBounds(this.val$wmcLocal.mainWindowBounds);
                                }
                                wmi.setMainPositioned(true);
                            }
                        }
                        InstanceCookieImpl.access$202(this.this$0, false);
                    }
                    if (this.val$wmcLocal.uiMode != 0) {
                        this.val$wmi.setSavedUIMode(this.val$wmcLocal.uiMode);
                    }
                    UIModeManager uiModeManager = UIModeManager.getDefault();
                    if (this.val$wmcLocal.uiMode != 0 && uiModeManager.getUIMode() != this.val$wmcLocal.uiMode) {
                        uiModeManager.updateAll();
                    }
                }
            });
        }

        private void updateWorkspaces(InstanceCookie[] oldCookies, InstanceCookie[] newCookies) throws IOException {
            Workspace currWorkspace;
            String wsp;
            ArrayList<WorkspaceImpl> workspaces = new ArrayList<WorkspaceImpl>();
            int i = 0;
            while (i < newCookies.length) {
                try {
                    WorkspaceImpl wi = (WorkspaceImpl)newCookies[i].instanceCreate();
                    workspaces.add(wi);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException exc) {
                    ErrorManager.getDefault().notify(4096, (Throwable)exc);
                }
                catch (ClassNotFoundException exc) {
                    ErrorManager.getDefault().notify(4096, (Throwable)exc);
                }
                ++i;
            }
            WindowManagerImpl wmi = this.obtainWindowManagerImpl();
            wmi.setWorkspaces(workspaces.toArray(new WorkspaceImpl[workspaces.size()]));
            WindowManagerConfig localwmc = this.wmc;
            if (localwmc != null && (wsp = localwmc.activeWorkspace) != null && (currWorkspace = wmi.findLoadedWorkspace(wsp)) != null) {
                currWorkspace.activate();
            }
        }

        private static Set createDiffSet(InstanceCookie[] oldCookies, InstanceCookie[] newCookies) {
            HashSet ret = new HashSet();
            InstanceCookieImpl.fillSet(ret, newCookies, true);
            InstanceCookieImpl.fillSet(ret, oldCookies, false);
            return ret;
        }

        private static void fillSet(Set set, Object[] array, boolean add) {
            if (array == null) {
                return;
            }
            int i = 0;
            while (i < array.length) {
                if (add) {
                    set.add(array[i]);
                } else {
                    set.remove(array[i]);
                }
                ++i;
            }
        }

        private void checkWorkspaces() throws IOException {
            DataObject[] arr = this.folder.getChildren();
            ArrayList<WorkspaceImpl> wsps = new ArrayList<WorkspaceImpl>(arr.length);
            int i = 0;
            while (i < arr.length) {
                InstanceCookie ic = (InstanceCookie)arr[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? InstanceCookieImpl.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic != null) {
                    try {
                        WorkspaceImpl wi = (WorkspaceImpl)ic.instanceCreate();
                        wsps.add(wi);
                    }
                    catch (FileNotFoundException e) {
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            Workspace[] workspaces = wsps.toArray(new WorkspaceImpl[wsps.size()]);
            WindowManagerImpl wmi = this.obtainWindowManagerImpl();
            wmi.setWorkspaces(workspaces);
        }

        private Map createCurrentWorkspacesMap() {
            HashMap<String, Workspace> ret = new HashMap<String, Workspace>();
            WindowManagerImpl wmi = this.obtainWindowManagerImpl();
            Workspace[] wsps = wmi.getWorkspacesNoLoad();
            if (wsps != null) {
                int i = 0;
                while (i < wsps.length) {
                    ret.put(wsps[i].getName(), wsps[i]);
                    ++i;
                }
            }
            return ret;
        }

        private WindowManagerImpl obtainWindowManagerImpl() {
            if (this.windowManagerImpl == null) {
                this.windowManagerImpl = (WindowManagerImpl)WindowManager.getDefault();
            }
            return this.windowManagerImpl;
        }

        public void save() throws IOException {
            Object object = SAVING;
            synchronized (object) {
                if (this.propertyHandler == null) {
                    this.propertyHandler = new PropertyHandler((WindowManagerData)this.folder);
                }
                this.propertyHandler.writeData();
                this.folder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
                FileObject[] workspaceFiles = this.folder.getPrimaryFile().getChildren();
                Workspace[] workspaces = this.obtainWindowManagerImpl().getWorkspaces();
                int i = 0;
                while (i < workspaceFiles.length) {
                    DataObject workspaceFolder;
                    if (!workspaceFiles[i].isFolder() && (workspaceFolder = DataObject.find((FileObject)workspaceFiles[i])) != null && workspaceFolder instanceof WorkspaceData) {
                        SaveCookie sc = (SaveCookie)workspaceFolder.getCookie(class$org$openide$cookies$SaveCookie == null ? InstanceCookieImpl.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                        if (sc != null) {
                            sc.save();
                        } else {
                            System.out.println("No save cookie for data obj " + workspaceFolder);
                            Thread.dumpStack();
                        }
                    }
                    ++i;
                }
                DataObject[] arrUnsorted = this.folder.getChildren();
                DataObject[] arrSorted = this.sortWorkspaceData(workspaces, arrUnsorted);
                this.folder.setOrder(arrSorted);
                try {
                    this.childrenCookies = this.createCookies();
                }
                catch (ClassNotFoundException e) {
                    this.childrenCookies = null;
                    FoldingIOException ioe = new FoldingIOException((Throwable)e);
                    ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ioe);
                    throw ioe;
                }
            }
        }

        public void run() throws IOException {
            FileObject fo;
            Workspace[] workspaces = this.obtainWindowManagerImpl().getWorkspaces();
            FileObject wmFo = this.folder.getPrimaryFile();
            FileObject[] workspaceFiles = wmFo.getChildren();
            HashSet<FileObject> allFiles = new HashSet<FileObject>(2 * workspaceFiles.length);
            int i = 0;
            while (i < workspaceFiles.length) {
                allFiles.add(workspaceFiles[i]);
                ++i;
            }
            String wName = null;
            int i2 = 0;
            while (i2 < workspaces.length) {
                wName = WindowUtils.escape(workspaces[i2].getName());
                fo = wmFo.getFileObject(wName, "wswksp");
                if (fo == null) {
                    wmFo.createData(wName, "wswksp");
                } else {
                    allFiles.remove(fo);
                }
                fo = wmFo.getFileObject(wName);
                if (fo == null) {
                    wmFo.createFolder(wName);
                } else {
                    allFiles.remove(fo);
                }
                ++i2;
            }
            Iterator it = allFiles.iterator();
            while (it.hasNext()) {
                fo = (FileObject)it.next();
                if (fo.isFolder()) continue;
                FileLock lock = fo.lock();
                fo.delete(lock);
                lock.releaseLock();
            }
        }

        private DataObject[] sortWorkspaceData(Workspace[] workspaces, DataObject[] arrUnsorted) {
            if (arrUnsorted.length == 0) {
                return arrUnsorted;
            }
            ArrayList<DataObject> sorted = new ArrayList<DataObject>(arrUnsorted.length);
            int i = 0;
            while (i < workspaces.length) {
                int j = 0;
                while (j < arrUnsorted.length) {
                    if (workspaces[i].getName().equals(arrUnsorted[j].getName())) {
                        sorted.add(arrUnsorted[j]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return sorted.toArray(new DataObject[0]);
        }

        public int getLoadedSections() {
            return this.loadedSections;
        }

        public int disposeDataSection(int data_id) throws IOException {
            this.loadedSections &= ~data_id;
            throw new UnsupportedOperationException();
        }

        public int loadDataSection(int data_id) throws IOException {
            Object object = this.DATA_ID_LOCK;
            synchronized (object) {
                if (data_id == (this.loadedSections & data_id)) {
                    int n = this.loadedSections;
                    return n;
                }
                this.loadedSections |= data_id;
                try {
                    try {
                        InstanceCookie[] oldCookies = this.childrenCookies;
                        this.childrenCookies = this.createCookies();
                        this.updateAll(oldCookies, this.childrenCookies);
                    }
                    catch (ClassNotFoundException e) {
                        IOException ioe = new IOException("Problem loading section " + data_id + " of " + (this.windowManagerImpl != null ? ((Object)((Object)this.windowManagerImpl)).toString() : " null"));
                        ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
                        throw ioe;
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    throw throwable;
                }
                int n = this.loadedSections;
                return n;
            }
        }

        public void resetComponents() {
            this.childrenCookies = null;
        }

        public void reset() {
            super.reset();
            this.windowManagerImpl = null;
            this.loadedSections = 0;
            this.childrenCookies = null;
        }

        public void destroy() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isValid() {
            return this.folder.isValid() && this.folder.getPrimaryFile().isValid() && ((WindowManagerData)this.folder).getWindowManagerConfigFO().isValid();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ boolean access$200(InstanceCookieImpl x0) {
            return x0.setMainWindowBounds;
        }

        static /* synthetic */ boolean access$202(InstanceCookieImpl x0, boolean x1) {
            x0.setMainWindowBounds = x1;
            return x0.setMainWindowBounds;
        }
    }

    private static final class WindowManagerConfig {
        public Rectangle mainWindowBounds;
        public boolean centerMainWindowX;
        public boolean centerMainWindowY;
        public boolean maximizedMainWindow;
        public Dimension screenSize;
        public String activeWorkspace;
        public int uiMode;
        public int minWidth;
        public int minHeight;

        WindowManagerConfig() {
        }

        public void clear() {
            this.mainWindowBounds = null;
            this.screenSize = null;
            this.centerMainWindowX = false;
            this.centerMainWindowY = false;
            this.maximizedMainWindow = false;
            this.minWidth = 0;
            this.minHeight = 0;
        }
    }
}

