/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.core.Splash;
import org.netbeans.core.ui.ModuleBean;
import org.netbeans.core.ui.WizardFolder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class SetupWizard
extends WizardFolder
implements PropertyChangeListener,
AWTEventListener {
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String DATE_SHOWN_PROPERTY = "dateShown";
    private static final String MODULE_ATTR = "module";
    private static final String HIDDEN_ATTR = "hidden";
    private static final String BASIC_ATTR = "basic";
    private boolean showAll = false;
    private boolean lock = false;
    private HashMap subIterators;
    private WizardFolder.CompoundIterator cit;
    private WizardDescriptor wd;
    private WizardDescriptor.Iterator separator;
    private static ModuleBean.AllModulesBean allModules = ModuleBean.AllModulesBean.getDefault();
    private HashSet initializedPanels = new HashSet();
    static /* synthetic */ Class class$org$netbeans$core$ui$WizardFolder;
    static /* synthetic */ Class class$org$netbeans$core$ui$SetupWizard;

    public SetupWizard(DataFolder df) {
        super(df);
    }

    public void eventDispatched(AWTEvent ev) {
        Container parent;
        FocusEvent fev;
        Component c;
        if (ev.getID() == 1004 && !(c = (fev = (FocusEvent)ev).getComponent()).isVisible() && (parent = c.getParent()) != null) {
            Component[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                if (comps[i].isVisible()) {
                    comps[i].requestFocus();
                    break;
                }
                ++i;
            }
        }
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        SetupWizard setupWizard = this;
        synchronized (setupWizard) {
            if (this.lock) {
                SetupWizard setupWizard2 = this;
                return setupWizard2;
            }
            LinkedList<Object> basic = new LinkedList<Object>();
            LinkedList<WizardDescriptor.Iterator> advanced = new LinkedList<WizardDescriptor.Iterator>();
            if (this.subIterators == null) {
                this.subIterators = new HashMap();
            }
            int i = 0;
            while (i < cookies.length) {
                block19: {
                    Object[] obj;
                    WizardDescriptor.Iterator subIter;
                    block16: {
                        block18: {
                            block17: {
                                subIter = (WizardDescriptor.Iterator)this.subIterators.get(cookies[i]);
                                obj = (Object[])cookies[i].instanceCreate();
                                if (subIter != null) break block16;
                                if (!(obj[0] instanceof WizardDescriptor.Iterator)) break block17;
                                subIter = (WizardDescriptor.Iterator)obj[0];
                                break block16;
                            }
                            if (!(obj[0] instanceof WizardDescriptor.Panel)) break block18;
                            WizardDescriptor.Panel p = (WizardDescriptor.Panel)obj[0];
                            subIter = new WizardFolder.PanelWrapper(p, cookies[i].instanceName());
                            break block16;
                        }
                        if (!(obj[0] instanceof Component)) break block19;
                        Component c = (Component)obj[0];
                        subIter = new WizardFolder.PanelWrapper(c, cookies[i].instanceName());
                    }
                    this.subIterators.put(cookies[i], subIter);
                    if (Boolean.TRUE.equals(((DataObject)obj[1]).getPrimaryFile().getAttribute(BASIC_ATTR))) {
                        basic.add(subIter);
                    } else {
                        advanced.add(subIter);
                    }
                }
                ++i;
            }
            if (!(this.showAll || advanced.isEmpty() || basic.isEmpty())) {
                basic.add(this.getSeparatorPanel());
            }
            basic.addAll(advanced);
            if (this.wd == null) {
                if (basic.isEmpty()) {
                    this.cit = null;
                } else {
                    this.setIterator(new InitializedIterator(basic));
                }
            } else {
                this.cit.setIterators(basic);
            }
        }
        return this;
    }

    protected InstanceCookie acceptDataObject(DataObject dob) {
        InstanceCookie cookie = super.acceptDataObject(dob);
        if (cookie != null) {
            FileObject fo = dob.getPrimaryFile();
            Date lastVisit = (Date)fo.getAttribute(DATE_SHOWN_PROPERTY);
            String moduleName = (String)fo.getAttribute(MODULE_ATTR);
            Boolean hidden = (Boolean)fo.getAttribute(HIDDEN_ATTR);
            if (Boolean.TRUE.equals(hidden) || lastVisit != null && !this.showAll || this.skipping(moduleName)) {
                return null;
            }
        }
        return cookie;
    }

    private boolean skipping(String moduleName) {
        if (moduleName == null) {
            return false;
        }
        ModuleBean[] modules = allModules.getModules();
        int i = 0;
        while (i < modules.length) {
            if (modules[i].getCodeNameBase().equals(moduleName)) {
                return !modules[i].isEnabled();
            }
            ++i;
        }
        return false;
    }

    protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        return new Object[]{cookie.instanceCreate(), obj};
    }

    protected void markPanelsAsSeen() {
        Date now = new Date();
        FileObject[] fo = this.folder.getPrimaryFile().getChildren();
        int i = 0;
        while (i < fo.length) {
            try {
                fo[i].setAttribute(DATE_SHOWN_PROPERTY, (Object)now);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            ++i;
        }
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
        this.run();
    }

    private void setIterator(WizardFolder.CompoundIterator it) {
        if (this.cit != null) {
            this.cit.removePropertyChangeListener(this);
        }
        this.cit = it;
        if (this.cit != null) {
            this.cit.addPropertyChangeListener(this);
        }
    }

    public WizardDescriptor.Iterator getIterator() {
        return this.cit;
    }

    public void show() {
        this.show(null);
    }

    public void show(Splash.SplashOutput splash) {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
        if (this.cit == null) {
            return;
        }
        SetupWizard setupWizard = this;
        synchronized (setupWizard) {
            this.lock = true;
        }
        if (splash != null) {
            Splash.hideSplash(splash);
        }
        this.wd = new InitializedWizardDescriptor(this.cit);
        this.wd.putProperty(PROP_AUTO_WIZARD_STYLE, (Object)Boolean.TRUE);
        this.wd.putProperty(PROP_CONTENT_DISPLAYED, (Object)Boolean.TRUE);
        this.wd.putProperty(PROP_CONTENT_NUMBERED, (Object)Boolean.TRUE);
        this.wd.setTitleFormat(new MessageFormat("{0}"));
        this.wd.setTitle(NbBundle.getBundle((Class)(class$org$netbeans$core$ui$WizardFolder == null ? (class$org$netbeans$core$ui$WizardFolder = SetupWizard.class$("org.netbeans.core.ui.WizardFolder")) : class$org$netbeans$core$ui$WizardFolder)).getString("CTL_SetupWizardTitle"));
        this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.cit.getContentData());
        this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, (Object)new Integer(this.cit.getContentSelectedIndex()));
        allModules.addPropertyChangeListener(this);
        ModuleBean[] modules = allModules.getModules();
        int i = 0;
        while (i < modules.length) {
            modules[i].addPropertyChangeListener(this);
            ++i;
        }
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wd);
        d.show();
        d.dispose();
        allModules.removePropertyChangeListener(this);
        modules = allModules.getModules();
        int i2 = 0;
        while (i2 < modules.length) {
            modules[i2].removePropertyChangeListener(this);
            ++i2;
        }
        this.cit.removePropertyChangeListener(this);
        if (this.wd.getValue() != NotifyDescriptor.CANCEL_OPTION) {
            if (this.wd.getValue() != NotifyDescriptor.CLOSED_OPTION) {
                this.markPanelsAsSeen();
            }
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    private void updateAdvancedWizard() {
        this.lock = false;
        this.run();
        SetupWizard setupWizard = this;
        synchronized (setupWizard) {
            this.lock = true;
        }
        this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.cit.getContentData());
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (PROP_CONTENT_SELECTED_INDEX.equals(ev.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, (Object)new Integer(this.cit.getContentSelectedIndex()));
        } else if (PROP_CONTENT_DATA.equals(ev.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.cit.getContentData());
        } else if (allModules == ev.getSource() || "enabled".equals(ev.getPropertyName())) {
            this.updateAdvancedWizard();
        }
    }

    private WizardDescriptor.Iterator getSeparatorPanel() {
        if (this.separator == null) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(NbBundle.getBundle((Class)(class$org$netbeans$core$ui$SetupWizard == null ? (class$org$netbeans$core$ui$SetupWizard = SetupWizard.class$("org.netbeans.core.ui.SetupWizard")) : class$org$netbeans$core$ui$SetupWizard)).getString("LBL_SeparatorPanelInstr"));
            panel.add((Component)label, "North");
            panel.setName(NbBundle.getBundle((Class)(class$org$netbeans$core$ui$SetupWizard == null ? (class$org$netbeans$core$ui$SetupWizard = SetupWizard.class$("org.netbeans.core.ui.SetupWizard")) : class$org$netbeans$core$ui$SetupWizard)).getString("LBL_SeparatorPanelName"));
            panel.getAccessibleContext().setAccessibleDescription(label.getText());
            this.separator = new WizardFolder.PanelWrapper(panel, "");
        }
        return this.separator;
    }

    public static void showSetupWizard(boolean showAll) {
        SetupWizard.showSetupWizard(showAll, null);
    }

    public static void showSetupWizard(boolean showAll, Splash.SplashOutput splash) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Wizards/Setup");
        if (fo != null) {
            SetupWizard f = new SetupWizard(DataFolder.findFolder((FileObject)fo));
            f.setShowAll(showAll);
            f.show(splash);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InitializedWizardDescriptor
    extends WizardDescriptor {
        public InitializedWizardDescriptor(WizardDescriptor.Iterator iter) {
            super(iter);
        }

        protected void updateState() {
            super.updateState();
            SetupWizard.this.initializedPanels.add(SetupWizard.this.cit.current());
        }
    }

    private class InitializedIterator
    extends WizardFolder.CompoundIterator {
        private static final String PROP_INITIALIZE = "initializePanel";

        public InitializedIterator(LinkedList iterators) {
            super(iterators);
        }

        public WizardDescriptor.Panel current() {
            WizardDescriptor.Panel current = super.current();
            SetupWizard.this.wd.putProperty(PROP_INITIALIZE, (Object)(SetupWizard.this.initializedPanels.contains(current) ? Boolean.FALSE : Boolean.TRUE));
            return current;
        }
    }
}

