/*
 * Decompiled with CFR 0.152.
 */
package alma.archive.monitorstream.client;

import alma.archive.exceptions.general.DatabaseException;
import alma.archive.wrappers.ArchiveTimeStamp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.jdbc.pool.OracleDataSource;

public class MonitorRetrievalClient {
    static final String host = "host";
    static final String port = "port";
    static final String service = "service";
    static final String timeFrom = "timeFrom";
    static final String timeTo = "timeTo";
    static final String propertyType = "propertyType";
    static final String antennaName = "antennaName";
    static final String assemblySerialNumber = "assemblySerialNumber";
    static final String LRUacronym = "LRUacronym";
    static final String assemblyAcronym = "assemblyAcronym";
    static final String outfile = "outfile";
    static final String user = "user";
    static final String connectionString = "url";
    static final String timeCol = "SampleTime";
    static final String valueCol = "Value";
    static final String propertyTypeTabCol = "PropertyType.PropertyName";
    static final String antennaNameTabCol = "Antenna.AntennaName";
    static final String assemblySerialNumberTabCol = "Assembly.SerialNumber";
    static final String LRUacronymTabCol = "LRUType.LRUName";
    static final String assemblyAcronymTabCol = "AssemblyType.AssemblyName";
    static final String propertyTypeCol = "PropertyName";
    static final String antennaNameCol = "AntennaName";
    static final String LRUacronymCol = "LRUName";
    static final String tableNameCol = "TableName";
    static final String LRUTab = "LRUType";
    static final String AntennaTab = "Antenna";
    static final String PropertyTypeTab = "PropertyType";
    static final String AssemblyTypeTab = "AssemblyType";
    static final String AssemblyTab = "Assembly";
    static String[] inputParamNames = new String[]{"host", "port", "service", "timeFrom", "timeTo", "propertyType", "antennaName", "assemblySerialNumber", "LRUacronym", "assemblyAcronym", "outfile", "user", "url"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws DatabaseException {
        Object object;
        Object object2;
        String string;
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (n = 0; n < inputParamNames.length; ++n) {
            hashMap.put(inputParamNames[n], null);
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.indexOf(61) == -1) {
                System.out.println("SYNTAX ERROR in input parameter: " + string);
                System.out.println("Aborting...");
                MonitorRetrievalClient.printHelp();
                System.exit(-1);
            }
            object2 = string.substring(0, string.indexOf(61));
            object = string.substring(string.indexOf(61) + 1);
            if (!hashMap.containsKey(object2)) {
                System.out.println("Unrecognized parameter: " + (String)object2 + ". Ignoring...");
                continue;
            }
            hashMap.put((String)object2, (String)object);
        }
        if (hashMap.get(timeFrom) == null || hashMap.get(timeTo) == null || hashMap.get(propertyType) == null) {
            System.out.println("propertyType, timeFrom and timeTo are mandatory input parameters. Aborting...");
            MonitorRetrievalClient.printHelp();
            System.exit(-1);
        }
        if (hashMap.get(connectionString) == null && (hashMap.get(host) == null || hashMap.get(port) == null || hashMap.get(service) == null)) {
            System.out.println("host, port, service,  are mandatory input parameters, if url is not specified. Aborting...");
            MonitorRetrievalClient.printHelp();
            System.exit(-1);
        }
        String string2 = hashMap.get(connectionString) == null ? "jdbc:oracle:thin:@//" + hashMap.get(host) + ":" + hashMap.get(port) + "/" + hashMap.get(service) : (String)hashMap.get(connectionString);
        System.out.println("Connecting to " + string2);
        string = null;
        try {
            string = new OracleDataSource();
        }
        catch (SQLException sQLException) {
            System.out.println("Could not connect to Database: ");
            sQLException.printStackTrace();
            System.exit(-1);
        }
        if (hashMap.get(user) != null) {
            string.setUser((String)hashMap.get(user));
        } else {
            string.setUser("monitorData");
        }
        string.setPassword("alma$dba");
        string.setURL(string2);
        object2 = null;
        try {
            object2 = string.getConnection();
        }
        catch (SQLException sQLException) {
            System.out.println("Could not initialize JDBC connection to Oracle");
            sQLException.printStackTrace();
            System.exit(-1);
        }
        object = null;
        ResultSet resultSet = null;
        String string3 = (String)hashMap.get(timeFrom);
        String string4 = (String)hashMap.get(timeTo);
        String string5 = null;
        String string6 = "SELECT PropertyType.TableName FROM PropertyType WHERE PropertyType.PropertyName='" + hashMap.get(propertyType) + "'";
        System.out.println("Executing SQL: " + string6);
        try {
            object = object2.createStatement();
            resultSet = object.executeQuery(string6);
            if (!resultSet.next()) {
                System.out.println("Unknown propertyType: " + hashMap.get(propertyType));
                System.out.println("Aborting...");
                System.exit(-1);
            }
            string5 = resultSet.getString(tableNameCol);
        }
        catch (SQLException sQLException) {
            System.out.println("Caught SQL exception: ");
            sQLException.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        string6 = "SELECT Antenna.AntennaName, LRUType.LRUName, PropertyType.PropertyName, " + string5 + "." + timeCol + ", " + string5 + "." + valueCol + " FROM " + LRUTab + ", " + AntennaTab + ", " + PropertyTypeTab + ", " + AssemblyTypeTab + ", " + AssemblyTab + ", " + string5 + " WHERE " + string5 + "." + timeCol + " BETWEEN '" + new ArchiveTimeStamp(string3).toSQLString() + "' AND '" + new ArchiveTimeStamp(string4).toSQLString() + "'";
        for (String string7 : hashMap.keySet()) {
            if (string7.equals(propertyType) && hashMap.get(string7) != null) {
                string6 = string6 + " AND " + propertyTypeTabCol + " = '" + (String)hashMap.get(string7) + "'";
            }
            if (string7.equals(antennaName) && hashMap.get(string7) != null) {
                string6 = string6 + " AND " + antennaNameTabCol + "= '" + (String)hashMap.get(string7) + "'";
            }
            if (string7.equals(assemblySerialNumber) && hashMap.get(string7) != null) {
                string6 = string6 + " AND " + assemblySerialNumberTabCol + " = '" + (String)hashMap.get(string7) + "'";
            }
            if (string7.equals(LRUacronym) && hashMap.get(string7) != null) {
                string6 = string6 + " AND " + LRUacronymTabCol + " = '" + (String)hashMap.get(string7) + "'";
            }
            if (!string7.equals(assemblyAcronym) || hashMap.get(string7) == null) continue;
            string6 = string6 + " AND " + assemblyAcronymTabCol + " = '" + (String)hashMap.get(string7) + "'";
        }
        System.out.println("Executing SQL: " + string6);
        try {
            object = object2.createStatement();
            resultSet = object.executeQuery(string6);
            System.out.println("");
            Object object3 = null;
            if (hashMap.get(outfile) != null) {
                try {
                    object3 = new PrintStream(new File((String)hashMap.get(outfile)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Cannot write to file " + hashMap.get(outfile));
                    fileNotFoundException.printStackTrace();
                    System.out.println("Aborting...");
                    System.exit(-1);
                }
            } else {
                object3 = System.out;
            }
            ((PrintStream)object3).println("AntennaName, LRUName, PropertyName, SampleTime, Value");
            ((PrintStream)object3).println("");
            while (resultSet.next()) {
                ((PrintStream)object3).println(resultSet.getString(antennaNameCol) + ", " + resultSet.getString(LRUacronymCol) + ", " + resultSet.getString(propertyTypeCol) + ", " + resultSet.getTimestamp(timeCol).toString() + ", " + resultSet.getObject(valueCol).toString());
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Caught SQL exception: ");
            sQLException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    static void printHelp() {
        System.out.println("Usage: monDataCLI {name=value}*");
        System.out.println("  where name is one of " + MonitorRetrievalClient.array2string(inputParamNames));
        System.out.println("  The following parameters are obligatory, ie. must be specified: timeFrom, timeTo, host, port, service, propertyType");
        System.out.println("The parameters host, port, service are overridden by parameter url. If the latter is given, the former three can also be missing.");
    }

    static String array2string(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

