/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.printing;

import cern.gp.explorer.ListTableExplorer;
import cern.gp.explorer.TreeExplorer;
import cern.gp.printing.PrintableComponent;
import cern.gp.printing.PrintableListTableExplorer;
import cern.gp.printing.PrintableTreeExplorer;
import cern.gp.util.Assertion;
import java.awt.Component;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrintUtil {
    private static final String PRINTER_NAME = "Acrobat Distiller";
    private static PrintUtil singleton = new PrintUtil();

    private PrintUtil() {
    }

    public static PrintUtil getInstance() {
        return singleton;
    }

    public void print(Printable printable) {
        this.printPDF("", printable);
    }

    public void print(Component component) {
        Printable printable = null;
        printable = component instanceof TreeExplorer ? new PrintableTreeExplorer((TreeExplorer)((Object)component)) : (component instanceof ListTableExplorer ? new PrintableListTableExplorer((ListTableExplorer)((Object)component)) : new PrintableComponent(component));
        this.printPDF(component.getName(), printable);
    }

    private void printPDF(String string, Printable printable) {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(MediaSizeName.ISO_A4);
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        PrintService printService = this.findPrinterService(sERVICE_FORMATTED, hashPrintRequestAttributeSet);
        Assertion.assertTrue(printService != null, "service != null");
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintService(printService);
            printerJob.setPrintable(printable);
            printerJob.pageDialog(hashPrintRequestAttributeSet);
            printerJob.print(hashPrintRequestAttributeSet);
        }
        catch (PrinterException printerException) {
            Log log = LogFactory.getLog(PrintUtil.class);
            log.warn((Object)("The component " + string + " could not be printed"));
        }
    }

    private PrintService findPrinterService(DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(docFlavor, printRequestAttributeSet);
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (printServiceArray[i].getName().compareToIgnoreCase(PRINTER_NAME) != 0) continue;
            return printServiceArray[i];
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }
}

