/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.nodes.impl;

import cern.gp.beans.BeanTagger;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class PropertyNode
extends AbstractNode {
    private static final String ICON_NAME = "cern/gp/nodes/resources/properties.gif";
    private static final Image ICON_IMAGE = PropertyNode.loadImage("cern/gp/nodes/resources/properties.gif");
    public static final String VALUE = "value";
    private Node.Property property;
    private Node.PropertySet[] propertySets;

    public PropertyNode(Node.Property property) {
        super(PropertyNode.computeChildren(property));
        this.property = property;
        this.propertySets = new Node.PropertySet[]{new ValuePropertySet(property)};
        this.setIconBase(ICON_NAME);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public String getDisplayName() {
        return this.property.getDisplayName();
    }

    public String getName() {
        return this.property.getName();
    }

    public String getShortDescription() {
        return this.property.getShortDescription();
    }

    public Image getIcon(int n) {
        if (ICON_IMAGE == null) {
            return super.getIcon(n);
        }
        return ICON_IMAGE;
    }

    public Image getOpenedIcon(int n) {
        if (ICON_IMAGE == null) {
            return super.getOpenedIcon(n);
        }
        return ICON_IMAGE;
    }

    public Component getCustomizer() {
        PropertyEditor propertyEditor = this.property.getPropertyEditor();
        if (propertyEditor == null) {
            return null;
        }
        return propertyEditor.getCustomEditor();
    }

    public boolean hasCustomizer() {
        PropertyEditor propertyEditor = this.property.getPropertyEditor();
        if (propertyEditor == null) {
            return false;
        }
        return propertyEditor.supportsCustomEditor();
    }

    public Node.PropertySet[] getPropertySets() {
        return this.propertySets;
    }

    public Object getValue(String string) {
        if (VALUE.equals(string)) {
            return this.property;
        }
        return super.getValue(string);
    }

    protected SystemAction[] createActions() {
        return new SystemAction[0];
    }

    private static Children computeChildren(Node.Property property) {
        try {
            Object object = property.getValue();
            if (object == null) {
                return Children.LEAF;
            }
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 != null) {
                return new PropertyArrayChildren(property);
            }
            if (BeanTagger.isExpandable((FeatureDescriptor)property)) {
                return new PropertyChildren(property);
            }
            if (property.getPropertyEditor() != null) {
                return Children.LEAF;
            }
            return Children.LEAF;
        }
        catch (Exception exception) {
            return Children.LEAF;
        }
    }

    private static Image loadImage(String string) {
        URL uRL = PropertyNode.class.getClassLoader().getResource(string);
        if (uRL != null) {
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        return null;
    }

    private static class ValuePropertyProxy
    extends Node.Property {
        private Node.Property proxiedProperty;
        private Object value;
        private String indexString;

        public ValuePropertyProxy(Node.Property property, Object object, int n) {
            super(property.getValueType());
            this.proxiedProperty = property;
            this.value = object;
            this.indexString = "[" + n + "]";
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException();
        }

        public boolean supportsDefaultValue() {
            return this.proxiedProperty.supportsDefaultValue();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.proxiedProperty.restoreDefaultValue();
        }

        public PropertyEditor getPropertyEditor() {
            PropertyEditor propertyEditor = this.proxiedProperty.getPropertyEditor();
            return propertyEditor;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }

        public String getDisplayName() {
            String string = this.proxiedProperty.getDisplayName();
            if (string == null) {
                return "null " + this.indexString;
            }
            return string + this.indexString;
        }

        public String getName() {
            String string = this.proxiedProperty.getName();
            if (string == null) {
                return "null " + this.indexString;
            }
            return string + this.indexString;
        }

        public String getShortDescription() {
            return this.proxiedProperty.getShortDescription();
        }
    }

    private static class ValuePropertySet
    extends Node.PropertySet {
        private Node.Property[] properties;

        public ValuePropertySet(Node.Property property) {
            super("ValueSet", "ValueSet", "ValueSet");
            this.properties = new Node.Property[]{property};
        }

        public Node.Property[] getProperties() {
            return this.properties;
        }
    }

    private static class PropertyArrayChildren
    extends Children.Array {
        private Node.Property property;
        private Object[] values;

        public PropertyArrayChildren(Node.Property property) throws IllegalAccessException, InvocationTargetException {
            super(new ArrayList(((Object[])property.getValue()).length));
            this.property = property;
            this.values = (Object[])property.getValue();
        }

        protected void addNotify() {
            super.addNotify();
            Node[] nodeArray = new Node[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                nodeArray[i] = new PropertyNode(new ValuePropertyProxy(this.property, this.values[i], i));
            }
            this.add(nodeArray);
        }

        protected void removeNotify() {
            this.nodes.clear();
            super.removeNotify();
        }
    }

    private static class PropertyChildren
    extends Children.Array {
        private Node.Property property;

        public PropertyChildren(Node.Property property) {
            super(new ArrayList());
            this.property = property;
        }

        protected void addNotify() {
            super.addNotify();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(this.property.getValueType());
                BeanNode.Descriptor descriptor = BeanNode.computeProperties((Object)this.property.getValue(), (BeanInfo)beanInfo);
                this.addPropertyNodes(descriptor.property);
                this.addPropertyNodes(descriptor.expert);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void removeNotify() {
            this.nodes.clear();
            super.removeNotify();
        }

        private void addPropertyNodes(Node.Property[] propertyArray) {
            if (propertyArray == null || propertyArray.length == 0) {
                return;
            }
            Node[] nodeArray = new Node[propertyArray.length];
            for (int i = 0; i < propertyArray.length; ++i) {
                nodeArray[i] = new PropertyNode(propertyArray[i]);
            }
            this.add(nodeArray);
        }
    }
}

