/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.nodes.impl;

import cern.gp.beans.editors.support.BeanDependentPropertyEditor;
import cern.gp.nodes.cache.Cacheable;
import cern.gp.nodes.cache.CachingStrategy;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.nodes.IndexedPropertySupport;

class CacheableIndexedPropertySupport
extends IndexedPropertySupport
implements Cacheable {
    private Object cachedValue;
    private CachingStrategy cachingStrategy;

    public CacheableIndexedPropertySupport(Object object, Class clazz, Class clazz2, Method method, Method method2, Method method3, Method method4, CachingStrategy cachingStrategy) {
        super(object, clazz, clazz2, method, method2, method3, method4);
        this.cachingStrategy = cachingStrategy;
    }

    public Object getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.cachingStrategy.isCacheValid()) {
            this.cachedValue = super.getValue();
            this.cachingStrategy.validateCache();
        }
        return this.cachedValue;
    }

    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super.setValue(object);
        this.cachedValue = object;
        this.cachingStrategy.validateCache();
    }

    public Object getIndexedValue(int n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.cachingStrategy.isCacheValid()) {
            this.cachedValue = super.getValue();
            this.cachingStrategy.validateCache();
        }
        return Array.get(this.cachedValue, n);
    }

    public void setIndexedValue(int n, Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super.setIndexedValue(n, object);
        Array.set(this.cachedValue, n, object);
    }

    public PropertyEditor getPropertyEditor() {
        PropertyEditor propertyEditor = super.getPropertyEditor();
        if (propertyEditor != null && propertyEditor instanceof BeanDependentPropertyEditor) {
            ((BeanDependentPropertyEditor)((Object)propertyEditor)).initializePropertyEditor(this.instance, this.getName());
        }
        return propertyEditor;
    }

    @Override
    public void resetCache() {
        this.cachingStrategy.invalidateCache();
    }
}

