/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.nodes.impl;

import cern.gp.actions.PropertiesAction;
import cern.gp.beans.BeanTagger;
import cern.gp.beans.BeanUtils;
import cern.gp.beans.PropertyInfo;
import cern.gp.beans.impl.IntrospectionBasedNodeUpdater;
import cern.gp.beans.impl.NodeUpdaterListener;
import cern.gp.capabilities.Capability;
import cern.gp.capabilities.CapabilityProvider;
import cern.gp.nodes.cache.Cacheable;
import cern.gp.nodes.cache.CachingStrategy;
import cern.gp.nodes.cache.NoCachingStrategy;
import cern.gp.nodes.cache.StickyCachingStrategy;
import cern.gp.nodes.cache.TimeLimitedCachingStrategy;
import cern.gp.nodes.impl.CacheableIndexedPropertySupport;
import cern.gp.nodes.impl.CacheablePropertySupport;
import cern.gp.util.GPManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import org.openide.DialogDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.propertysheet.editors.NodeCustomizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class BeanNode
extends AbstractNode
implements Cacheable {
    private static final CachingStrategy DEFAULT_CACHING_STRATEGY;
    private static final String ICON_BASE = "org/openide/resources/beans";
    private static final Node.Property[] EMPTY_NODE_PROPERTY_ARRAY;
    private Image _iconColor16;
    private Object _bean;
    private BeanInfo _beanInfo;
    private GuiUpdaterIntrospector _guiUpdater;
    private Boolean _nodePropertiesCacheable;
    private SystemAction _defaultAction;

    protected BeanNode(Object object, Children children) throws IntrospectionException {
        super(children);
        this._bean = object;
        this.initialization();
    }

    public Action getPreferredAction() {
        if (this._defaultAction == null) {
            return super.getPreferredAction();
        }
        return this._defaultAction;
    }

    public Object getBean() {
        return this._bean;
    }

    public void destroy() throws IOException {
        this._guiUpdater.removeNodeUpdaterListener(null);
        super.destroy();
    }

    public Image getIcon(int n) {
        if ((n == 1 || n == 3) && this._iconColor16 != null) {
            return this._iconColor16;
        }
        Image image = this._beanInfo.getIcon(n);
        if (image != null) {
            return image;
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public boolean hasCustomizer() {
        return this._beanInfo.getBeanDescriptor().getCustomizerClass() != null;
    }

    public Component getCustomizer() {
        Object obj;
        Class<?> clazz = this._beanInfo.getBeanDescriptor().getCustomizerClass();
        if (clazz == null) {
            return null;
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            BeanNode.exception(instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            BeanNode.exception(illegalAccessException);
            return null;
        }
        if (!(obj instanceof Customizer)) {
            return null;
        }
        Customizer customizer = (Customizer)obj;
        BeanNode.attachCustomizer((Node)this, customizer);
        Component component = null;
        component = obj instanceof Component ? (Component)obj : BeanNode.createDialog(obj);
        if (component == null) {
            return null;
        }
        customizer.setObject(this._bean);
        if (!this._guiUpdater.hasRegisteredListenerInternal()) {
            customizer.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BeanNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            });
        }
        return component;
    }

    @Override
    public void resetCache() {
        Sheet.Set set = this.getSheet().get("properties");
        Sheet.Set set2 = this.getSheet().get("expert");
        if (set != null) {
            this.resetCache(set);
        }
        if (set2 != null) {
            this.resetCache(set2);
        }
    }

    protected void createProperties(Object object, BeanInfo beanInfo, PropertyInfo[] propertyInfoArray) {
        Descriptor descriptor = BeanNode.computeProperties(object, this._beanInfo, true, this._nodePropertiesCacheable, propertyInfoArray);
        Sheet sheet = this.getSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put(descriptor.property);
        sheet.put(set);
        if (descriptor.expert.length != 0) {
            Sheet.Set set2 = Sheet.createExpertSet();
            set2.put(descriptor.expert);
            sheet.put(set2);
        }
    }

    protected SystemAction[] createActions() {
        String[] stringArray = this._guiUpdater.getNodeActions();
        if (stringArray == null) {
            return null;
        }
        SystemAction[] systemActionArray = new SystemAction[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            try {
                Class<?> clazz = Class.forName(stringArray[i], true, this._bean.getClass().getClassLoader());
                systemActionArray[i] = SystemAction.get(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                BeanNode.warning(classNotFoundException);
            }
        }
        return systemActionArray;
    }

    private void resetCache(String string) {
        Sheet.Set set = this.getSheet().get("properties");
        Sheet.Set set2 = this.getSheet().get("expert");
        if (set != null) {
            this.resetCache(set, string);
        }
        if (set2 != null) {
            this.resetCache(set2, string);
        }
    }

    private void resetCache(Sheet.Set set) {
        Node.Property[] propertyArray = set.getProperties();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!(propertyArray[i] instanceof Cacheable)) continue;
            ((Cacheable)propertyArray[i]).resetCache();
        }
    }

    private void resetCache(Sheet.Set set, String string) {
        Node.Property property = set.get(string);
        if (property != null && property instanceof Cacheable) {
            ((Cacheable)property).resetCache();
        }
    }

    private void hideUnwantedPropertyDescriptors() {
        PropertyDescriptor[] propertyDescriptorArray = this._beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this._guiUpdater.isPropertyHidden(propertyDescriptorArray[i])) continue;
            propertyDescriptorArray[i].setHidden(true);
        }
    }

    private void initialization() throws IntrospectionException {
        String string;
        String string2;
        this.setIconBase(ICON_BASE);
        Class clazz = BeanUtils.findTargetClass(this._bean);
        this._beanInfo = Utilities.getBeanInfo((Class)clazz);
        this._guiUpdater = new GuiUpdaterIntrospector(this._bean, this._beanInfo, clazz);
        String string3 = this._guiUpdater.getName();
        if (string3 != null && string3.length() > 0) {
            this.setName(string3);
        }
        if ((string2 = this._guiUpdater.getDisplayName()) != null && string2.length() > 0) {
            this.setDisplayName(string2);
        }
        if ((string = this._guiUpdater.getShortDescription()) != null && string.length() > 0) {
            this.setShortDescription(string);
        }
        this._iconColor16 = this._guiUpdater.getNodeIcon();
        this._defaultAction = this.getDefaultActionInstance(this._guiUpdater.getNodeDefaultAction());
        this._nodePropertiesCacheable = this._guiUpdater.getNodePropertiesCacheable();
        this.hideUnwantedPropertyDescriptors();
        this.createProperties(this._bean, this._beanInfo, this._guiUpdater.getPropertyInfo());
        Node.Cookie cookie = this._beanInfo.getBeanDescriptor().attributeNames();
        while (cookie.hasMoreElements()) {
            String string4 = cookie.nextElement();
            this.setValue(string4, this._beanInfo.getBeanDescriptor().getValue(string4));
        }
        cookie = BeanNode.createInstanceCookie(this._bean);
        if (cookie != null) {
            this.getCookieSet().add(cookie);
        }
        BeanNode.initializeCookieSet(this._bean, this.getCookieSet());
    }

    private SystemAction getDefaultActionInstance(String string) {
        if (string == null) {
            return SystemAction.get(PropertiesAction.class);
        }
        try {
            return SystemAction.get(Class.forName(string, true, this._bean.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            BeanNode.warning(classNotFoundException);
            return SystemAction.get(PropertiesAction.class);
        }
    }

    private static Node.Property createIndexedNodeProperty(Object object, IndexedPropertyDescriptor indexedPropertyDescriptor, CachingStrategy cachingStrategy) {
        if (indexedPropertyDescriptor.getReadMethod() != null && !indexedPropertyDescriptor.getReadMethod().getReturnType().isArray()) {
            return null;
        }
        CacheableIndexedPropertySupport cacheableIndexedPropertySupport = new CacheableIndexedPropertySupport(object, indexedPropertyDescriptor.getPropertyType(), indexedPropertyDescriptor.getIndexedPropertyType(), indexedPropertyDescriptor.getReadMethod(), indexedPropertyDescriptor.getWriteMethod(), indexedPropertyDescriptor.getIndexedReadMethod(), indexedPropertyDescriptor.getIndexedWriteMethod(), cachingStrategy);
        cacheableIndexedPropertySupport.setName(indexedPropertyDescriptor.getName());
        cacheableIndexedPropertySupport.setDisplayName(indexedPropertyDescriptor.getDisplayName());
        cacheableIndexedPropertySupport.setShortDescription(indexedPropertyDescriptor.getShortDescription());
        Enumeration<String> enumeration = indexedPropertyDescriptor.attributeNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            cacheableIndexedPropertySupport.setValue(string, indexedPropertyDescriptor.getValue(string));
        }
        return cacheableIndexedPropertySupport;
    }

    private static Node.Property createNodeProperty(Object object, PropertyDescriptor propertyDescriptor, CachingStrategy cachingStrategy) {
        CacheablePropertySupport cacheablePropertySupport = new CacheablePropertySupport(object, propertyDescriptor.getPropertyType(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod(), cachingStrategy);
        cacheablePropertySupport.setName(propertyDescriptor.getName());
        cacheablePropertySupport.setDisplayName(propertyDescriptor.getDisplayName());
        cacheablePropertySupport.setShortDescription(propertyDescriptor.getShortDescription());
        cacheablePropertySupport.setPropertyEditorClass(propertyDescriptor.getPropertyEditorClass());
        Enumeration<String> enumeration = propertyDescriptor.attributeNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            cacheablePropertySupport.setValue(string, propertyDescriptor.getValue(string));
        }
        return cacheablePropertySupport;
    }

    private static CachingStrategy createCachingStrategy(Boolean bl, Boolean bl2) {
        boolean bl3 = false;
        bl3 = bl2 == null ? bl != null && bl != false : bl2;
        if (bl3) {
            return new StickyCachingStrategy();
        }
        return new TimeLimitedCachingStrategy(500);
    }

    private static Descriptor computeProperties(Object object, BeanInfo beanInfo, boolean bl, Boolean bl2, PropertyInfo[] propertyInfoArray) {
        ArrayList<Node.Property> arrayList = null;
        ArrayList<Node.Property> arrayList2 = null;
        ArrayList<Node.Property> arrayList3 = null;
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            if (propertyDescriptorArray[i].getPropertyType() == null) continue;
            String string = propertyDescriptorArray[i].getName();
            PropertyInfo propertyInfo = BeanNode.findPropertyInfoByName(propertyInfoArray, string);
            if (propertyInfo != null) {
                propertyInfo.updatePropertyDescriptor(propertyDescriptorArray[i]);
            }
            if (bl && propertyDescriptorArray[i].isHidden()) continue;
            CachingStrategy cachingStrategy = BeanNode.createCachingStrategy(bl2, BeanTagger.isCacheable(propertyDescriptorArray[i]));
            Node.Property property = propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor ? BeanNode.createIndexedNodeProperty(object, (IndexedPropertyDescriptor)propertyDescriptorArray[i], cachingStrategy) : BeanNode.createNodeProperty(object, propertyDescriptorArray[i], cachingStrategy);
            if (property == null) continue;
            if (propertyDescriptorArray[i].isHidden()) {
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<Node.Property>();
                }
                arrayList3.add(property);
                continue;
            }
            if (propertyDescriptorArray[i].isExpert()) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Node.Property>();
                }
                arrayList2.add(property);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Node.Property>();
            }
            arrayList.add(property);
        }
        return new Descriptor(arrayList, arrayList2, arrayList3);
    }

    private static PropertyInfo findPropertyInfoByName(PropertyInfo[] propertyInfoArray, String string) {
        if (propertyInfoArray == null) {
            return null;
        }
        for (int i = 0; i < propertyInfoArray.length; ++i) {
            if (!string.equals(propertyInfoArray[i].getName())) continue;
            return propertyInfoArray[i];
        }
        return null;
    }

    private static void exception(Throwable throwable) {
        GPManager.notify(1, throwable);
    }

    private static void warning(Throwable throwable) {
        GPManager.notify(16, throwable);
    }

    private static void initializeCookieSet(Object object, CookieSet cookieSet) {
        if (object instanceof CapabilityProvider) {
            CapabilityProvider capabilityProvider = (CapabilityProvider)object;
            Capability[] capabilityArray = capabilityProvider.getCapabilities();
            if (capabilityArray == null || capabilityArray.length == 0) {
                return;
            }
            for (int i = 0; i < capabilityArray.length; ++i) {
                cookieSet.add((Node.Cookie)capabilityArray[i]);
            }
        } else {
            Class<?>[] classArray = object.getClass().getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                if (!Capability.class.isAssignableFrom(classArray[i])) continue;
                cookieSet.add((Node.Cookie)((Capability)object));
            }
        }
    }

    private static final Node.Cookie createInstanceCookie(final Object object) {
        return new InstanceCookie(){

            public String instanceName() {
                return object.getClass().getName();
            }

            public Class instanceClass() {
                return object.getClass();
            }

            public Object instanceCreate() {
                return object;
            }
        };
    }

    private static final Dialog createDialog(Object object) {
        if (object instanceof DialogDescriptor) {
            return GPManager.createDialog((DialogDescriptor)object);
        }
        return null;
    }

    private static void attachCustomizer(Node node, Customizer customizer) {
        if (customizer instanceof NodeCustomizer) {
            ((NodeCustomizer)customizer).attach(node);
        }
    }

    static {
        BeanUtils.registerEditorSearchPaths(new String[]{"cern.gp.beans.editors"});
        DEFAULT_CACHING_STRATEGY = new NoCachingStrategy();
        EMPTY_NODE_PROPERTY_ARRAY = new Node.Property[0];
    }

    private final class GuiUpdaterIntrospector
    extends IntrospectionBasedNodeUpdater {
        public GuiUpdaterIntrospector(Object object, BeanInfo beanInfo, Class clazz) throws IntrospectionException {
            super(object, beanInfo, clazz);
        }

        boolean hasRegisteredListenerInternal() {
            return this.hasRegisteredListener();
        }

        @Override
        public void addNodeUpdaterListener(NodeUpdaterListener nodeUpdaterListener) {
        }

        @Override
        public void removeNodeUpdaterListener(NodeUpdaterListener nodeUpdaterListener) {
            this.removePropertyChangeListener();
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string == null) {
                BeanNode.this.resetCache();
            } else {
                BeanNode.this.resetCache(string);
            }
            BeanNode.this.firePropertyChange(string, object, object2);
        }

        @Override
        protected void fireNameChange(String string) {
            BeanNode.this.setName(string);
        }

        @Override
        protected void fireDisplayNameChange(String string) {
            BeanNode.this.setDisplayName(string);
        }

        @Override
        protected void fireShortDescriptionChange(String string) {
            BeanNode.this.setShortDescription(string);
        }

        @Override
        protected void fireNodeIconChange(Image image) {
            BeanNode.this._iconColor16 = image;
            BeanNode.this.fireIconChange();
        }

        @Override
        protected void fireNodeDefaultActionChange(String string) {
            BeanNode.this._defaultAction = BeanNode.this.getDefaultActionInstance(string);
        }
    }

    private static final class Descriptor {
        public final Node.Property[] property;
        public final Node.Property[] expert;
        public final Node.Property[] hidden;

        Descriptor(List list, List list2, List list3) {
            if (list == null || list.size() == 0) {
                this.property = EMPTY_NODE_PROPERTY_ARRAY;
            } else {
                this.property = new Node.Property[list.size()];
                list.toArray(this.property);
            }
            if (list2 == null || list2.size() == 0) {
                this.expert = EMPTY_NODE_PROPERTY_ARRAY;
            } else {
                this.expert = new Node.Property[list2.size()];
                list2.toArray(this.expert);
            }
            if (list3 == null || list3.size() == 0) {
                this.hidden = EMPTY_NODE_PROPERTY_ARRAY;
            } else {
                this.hidden = new Node.Property[list3.size()];
                list3.toArray(this.hidden);
            }
        }
    }
}

