/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.nodes.children;

import cern.gp.nodes.GPNode;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.ChildrenMapManager;
import cern.gp.nodes.children.NodeList;
import cern.gp.nodes.children.NodeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;

public class ChildrenFactory {
    private ChildrenFactory() {
    }

    public static Children createChildren(ChildrenManager childrenManager) {
        Comparator comparator = childrenManager.getComparator();
        if (childrenManager instanceof ChildrenListManager) {
            if (comparator == null) {
                return new ArrayChildren((ChildrenListManager)childrenManager);
            }
            return new SortedArrayChildren((ChildrenListManager)childrenManager, comparator);
        }
        if (childrenManager instanceof ChildrenMapManager) {
            if (comparator == null) {
                return new MapChildren((ChildrenMapManager)childrenManager);
            }
            return new SortedMapChildren((ChildrenMapManager)childrenManager, comparator);
        }
        throw new IllegalArgumentException("The class " + childrenManager.getClass().getName() + " is not a supported manager");
    }

    private static final Node[] convertGPNodeArrayToNodeArray(GPNode[] gPNodeArray) {
        Node[] nodeArray = new Node[gPNodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = gPNodeArray[i].getPeerNode();
        }
        return nodeArray;
    }

    private static class SortedMapChildren
    extends Children.SortedMap
    implements NodeMap {
        private ChildrenMapManager manager;

        public SortedMapChildren(ChildrenMapManager childrenMapManager, Comparator comparator) {
            super(new HashMap());
            this.manager = childrenMapManager;
            this.setComparator(comparator);
        }

        @Override
        public void refreshOrdering() {
            this.refresh();
        }

        @Override
        public ChildrenManager getChildrenManager() {
            return this.manager;
        }

        @Override
        public GPNode findChildByName(String string) {
            return (GPNode)super.findChild(string);
        }

        @Override
        public GPNode getParentNode() {
            return (GPNode)this.getNode();
        }

        @Override
        public final void addNode(Object object, GPNode gPNode) {
            this.put(object, gPNode.getPeerNode());
        }

        @Override
        public void addNodes(Map map) {
            this.putAll(this.nodes);
        }

        @Override
        public void addNode(GPNode gPNode) {
            this.put(gPNode.getName(), gPNode.getPeerNode());
        }

        @Override
        public void addNodes(GPNode[] gPNodeArray) {
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            for (int i = 0; i < gPNodeArray.length; ++i) {
                hashMap.put(gPNodeArray[i].getName(), gPNodeArray[i].getPeerNode());
            }
            this.putAll(hashMap);
        }

        @Override
        public final GPNode removeNode(Object object) {
            GPNode gPNode = this.getNode(object);
            if (gPNode == null) {
                return null;
            }
            this.remove(object);
            return gPNode;
        }

        @Override
        public final void removeNodes(Object[] objectArray) {
            this.removeAll(Arrays.asList(objectArray));
        }

        @Override
        public final GPNode getNode(Object object) {
            return (GPNode)this.nodes.get(object);
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.refresh();
        }

        @Override
        public Set keySet() {
            return this.nodes.keySet();
        }

        protected void addNotify() {
            super.addNotify();
            this.manager.initChildrenMap(this);
        }

        protected void removeNotify() {
            this.nodes.clear();
            super.removeNotify();
        }
    }

    private static class MapChildren
    extends Children.Map
    implements NodeMap {
        private ChildrenMapManager manager;

        public MapChildren(ChildrenMapManager childrenMapManager) {
            super(new HashMap());
            this.manager = childrenMapManager;
        }

        @Override
        public void refreshOrdering() {
        }

        @Override
        public ChildrenManager getChildrenManager() {
            return this.manager;
        }

        @Override
        public GPNode findChildByName(String string) {
            return (GPNode)super.findChild(string);
        }

        @Override
        public void addNodes(Map map) {
            this.putAll(this.nodes);
        }

        @Override
        public GPNode getParentNode() {
            return (GPNode)this.getNode();
        }

        @Override
        public final void addNode(Object object, GPNode gPNode) {
            this.put(object, gPNode.getPeerNode());
        }

        @Override
        public void addNode(GPNode gPNode) {
            this.put(gPNode.getName(), gPNode.getPeerNode());
        }

        @Override
        public void addNodes(GPNode[] gPNodeArray) {
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            for (int i = 0; i < gPNodeArray.length; ++i) {
                hashMap.put(gPNodeArray[i].getName(), gPNodeArray[i].getPeerNode());
            }
            this.putAll(hashMap);
        }

        @Override
        public final GPNode removeNode(Object object) {
            GPNode gPNode = this.getNode(object);
            if (gPNode == null) {
                return null;
            }
            this.remove(object);
            return gPNode;
        }

        @Override
        public final void removeNodes(Object[] objectArray) {
            this.removeAll(Arrays.asList(objectArray));
        }

        @Override
        public final GPNode getNode(Object object) {
            return (GPNode)this.nodes.get(object);
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.refresh();
        }

        @Override
        public Set keySet() {
            return this.nodes.keySet();
        }

        protected void addNotify() {
            super.addNotify();
            this.manager.initChildrenMap(this);
        }

        protected void removeNotify() {
            this.nodes.clear();
            super.removeNotify();
        }
    }

    private static class SortedArrayChildren
    extends Children.SortedArray
    implements NodeList {
        private ChildrenListManager manager;
        private final Node[] nodeArray = new Node[1];

        public SortedArrayChildren(ChildrenListManager childrenListManager, Comparator comparator) {
            super(new ArrayList());
            this.manager = childrenListManager;
            this.setComparator(comparator);
        }

        @Override
        public void refreshOrdering() {
            this.refresh();
        }

        @Override
        public ChildrenManager getChildrenManager() {
            return this.manager;
        }

        @Override
        public GPNode findChildByName(String string) {
            return (GPNode)super.findChild(string);
        }

        @Override
        public GPNode getParentNode() {
            return (GPNode)this.getNode();
        }

        @Override
        public void addNode(GPNode gPNode) {
            this.nodeArray[0] = gPNode.getPeerNode();
            this.add(this.nodeArray);
        }

        @Override
        public void addNodes(GPNode[] gPNodeArray) {
            this.add(ChildrenFactory.convertGPNodeArrayToNodeArray(gPNodeArray));
        }

        @Override
        public boolean removeNode(GPNode gPNode) {
            this.nodeArray[0] = gPNode.getPeerNode();
            return this.remove(this.nodeArray);
        }

        @Override
        public boolean removeNodes(GPNode[] gPNodeArray) {
            return this.remove(ChildrenFactory.convertGPNodeArrayToNodeArray(gPNodeArray));
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.refresh();
        }

        @Override
        public Iterator iterator() {
            return this.nodes.iterator();
        }

        protected void addNotify() {
            super.addNotify();
            this.manager.initChildrenList(this);
        }

        protected void removeNotify() {
            this.nodes.clear();
            super.removeNotify();
        }
    }

    private static class ArrayChildren
    extends Index.ArrayChildren
    implements NodeList {
        private ChildrenListManager manager;
        private final Node[] nodeArray = new Node[1];

        public ArrayChildren(ChildrenListManager childrenListManager) {
            this.manager = childrenListManager;
        }

        @Override
        public void refreshOrdering() {
        }

        @Override
        public ChildrenManager getChildrenManager() {
            return this.manager;
        }

        @Override
        public GPNode findChildByName(String string) {
            return (GPNode)super.findChild(string);
        }

        @Override
        public GPNode getParentNode() {
            return (GPNode)this.getNode();
        }

        @Override
        public void addNode(GPNode gPNode) {
            this.nodeArray[0] = gPNode.getPeerNode();
            this.add(this.nodeArray);
        }

        @Override
        public void addNodes(GPNode[] gPNodeArray) {
            this.add(ChildrenFactory.convertGPNodeArrayToNodeArray(gPNodeArray));
        }

        @Override
        public boolean removeNode(GPNode gPNode) {
            this.nodeArray[0] = gPNode.getPeerNode();
            return this.remove(this.nodeArray);
        }

        @Override
        public boolean removeNodes(GPNode[] gPNodeArray) {
            return this.remove(ChildrenFactory.convertGPNodeArrayToNodeArray(gPNodeArray));
        }

        @Override
        public void clear() {
            this.nodes.clear();
            this.refresh();
        }

        @Override
        public Iterator iterator() {
            return this.nodes.iterator();
        }

        protected void addNotify() {
            super.addNotify();
            this.manager.initChildrenList(this);
        }

        protected void removeNotify() {
            this.nodes.clear();
            super.removeNotify();
        }
    }
}

