/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.nodes.cache;

import cern.gp.nodes.cache.CachingStrategy;

public class TimeLimitedCachingStrategy
implements CachingStrategy {
    private final int timeoutMillis;
    private long lastAccessTimeMillis;

    public TimeLimitedCachingStrategy(int n) {
        this.timeoutMillis = n;
    }

    @Override
    public boolean isCacheValid() {
        if (this.lastAccessTimeMillis == 0L) {
            this.lastAccessTimeMillis = System.currentTimeMillis();
            return false;
        }
        if (this.timeoutMillis <= 0) {
            return false;
        }
        return System.currentTimeMillis() - this.lastAccessTimeMillis < (long)this.timeoutMillis;
    }

    @Override
    public void validateCache() {
        this.lastAccessTimeMillis = System.currentTimeMillis();
    }

    @Override
    public void invalidateCache() {
        this.lastAccessTimeMillis = 0L;
    }
}

