/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.logging;

import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.openide.ErrorManager;

public class NetBeansLog
implements Log {
    public static final String SYSTEM_PREFIX = "cern.gp.logging";
    public static final String LOG_LEVEL_PROPERTY = "cern.gp.logging.DefaultLevel";
    public static final String SHOW_LOG_NAME_PROPERTY = "cern.gp.logging.ShowLogName";
    public static final String SHOW_SHORT_LOG_NAME_PROPERTY = "cern.gp.logging.ShowShortLogName";
    public static final String SHOW_DATE_TIME_PROPERTY = "cern.gp.logging.ShowDateTime";
    public static final String DATE_FORMAT_PROPERTY = "cern.gp.logging.DateFormat";
    public static final String DATE_FORMAT_DEFAULT = "yyyy/MM/dd HH:mm:ss:SSS zzz";
    public static final String LOG_LEVEL_DEFAULT = "info";
    public static final boolean SHOW_LOG_NAME_DEFAULT = false;
    public static final boolean SHOW_SHORT_LOG_NAME_DEFAULT = true;
    public static final boolean SHOW_DATE_TIME_DEFAULT = false;
    protected static final ErrorManager errMgr = ErrorManager.getDefault();
    protected static final Properties nblogProps = new Properties();
    protected static boolean showLogName = false;
    protected static boolean showShortName = true;
    protected static boolean showDateTime = false;
    protected static DateFormat dateFormatter = null;
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 256;
    public static final int LOG_LEVEL_WARN = 16;
    public static final int LOG_LEVEL_ERROR = 4096;
    public static final int LOG_LEVEL_FATAL = 65536;
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_OFF = 65537;
    protected String logName = null;
    protected int currentLogLevel;
    private String prefix = null;

    public NetBeansLog(String string) {
        this.logName = string;
        this.setLevel(16);
        String string2 = nblogProps.getProperty("cern.gp.logging.log." + this.logName);
        int n = String.valueOf(string).lastIndexOf(".");
        while (null == string2 && n > -1) {
            string = string.substring(0, n);
            string2 = nblogProps.getProperty("cern.gp.logging.log." + string);
            n = String.valueOf(string).lastIndexOf(".");
        }
        if (null == string2) {
            string2 = nblogProps.getProperty(LOG_LEVEL_PROPERTY);
        }
        if ("all".equalsIgnoreCase(string2)) {
            this.setLevel(0);
        } else if ("trace".equalsIgnoreCase(string2)) {
            this.setLevel(1);
        } else if ("debug".equalsIgnoreCase(string2)) {
            this.setLevel(2);
        } else if (LOG_LEVEL_DEFAULT.equalsIgnoreCase(string2)) {
            this.setLevel(256);
        } else if ("warn".equalsIgnoreCase(string2)) {
            this.setLevel(16);
        } else if ("error".equalsIgnoreCase(string2)) {
            this.setLevel(4096);
        } else if ("fatal".equalsIgnoreCase(string2)) {
            this.setLevel(65536);
        } else if ("off".equalsIgnoreCase(string2)) {
            this.setLevel(65537);
        }
    }

    public void setLevel(int n) {
        this.currentLogLevel = n;
    }

    public int getLevel() {
        return this.currentLogLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(1);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(2);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(256);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(16);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(4096);
    }

    public boolean isFatalEnabled() {
        return this.isLevelEnabled(65536);
    }

    public void trace(Object object) {
        this.trace(object, null);
    }

    public void trace(Object object, Throwable throwable) {
        int n = 1;
        if (this.isLevelEnabled(n)) {
            this.display(n, object, throwable);
            this.log(n, object, throwable);
        }
    }

    public void debug(Object object) {
        this.debug(object, null);
    }

    public void debug(Object object, Throwable throwable) {
        int n = 2;
        if (this.isLevelEnabled(n)) {
            this.display(n, object, throwable);
            this.log(n, object, throwable);
        }
    }

    public void info(Object object) {
        this.info(object, null);
    }

    public void info(Object object, Throwable throwable) {
        int n = 256;
        if (this.isLevelEnabled(n)) {
            this.display(n, object, throwable);
            this.log(n, object, throwable);
        }
    }

    public void warn(Object object) {
        this.warn(object, null);
    }

    public void warn(Object object, Throwable throwable) {
        int n = 16;
        if (this.isLevelEnabled(n)) {
            this.display(n, object, throwable);
            this.log(n, object, throwable);
        }
    }

    public void error(Object object) {
        this.error(object, null);
    }

    public void error(Object object, Throwable throwable) {
        int n = 4096;
        if (this.isLevelEnabled(n)) {
            this.display(n, object, throwable);
            this.log(n, object, throwable);
        }
    }

    public void fatal(Object object) {
        this.fatal(object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        int n = 65536;
        if (this.isLevelEnabled(n)) {
            this.display(n, object, throwable);
            this.log(n, object, throwable);
        }
    }

    protected void display(int n, Object object, Throwable throwable) {
        String string = "";
        if (throwable != null) {
            string = " < " + throwable.getMessage() + " > ";
        }
    }

    protected void log(int n, Object object, Throwable throwable) {
        String string = this.createLogMessage(n, object);
        if (throwable == null) {
            errMgr.log(n, string);
        } else {
            errMgr.notify(n, errMgr.annotate(throwable, string));
        }
    }

    protected String createLogMessage(int n, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (showDateTime) {
            stringBuffer.append(dateFormatter.format(new Date()));
            stringBuffer.append(" ");
        }
        switch (n) {
            case 1: {
                stringBuffer.append("[TRACE] ");
                break;
            }
            case 2: {
                stringBuffer.append("[DEBUG] ");
                break;
            }
            case 256: {
                stringBuffer.append("[INFO] ");
                break;
            }
            case 16: {
                stringBuffer.append("[WARN] ");
                break;
            }
            case 4096: {
                stringBuffer.append("[ERROR] ");
                break;
            }
            case 65536: {
                stringBuffer.append("[FATAL] ");
            }
        }
        if (showShortName) {
            if (this.prefix == null) {
                this.prefix = this.logName.substring(this.logName.lastIndexOf(".") + 1) + " - ";
                this.prefix = this.prefix.substring(this.prefix.lastIndexOf("/") + 1) + "-";
            }
            stringBuffer.append(this.prefix);
        } else if (showLogName) {
            stringBuffer.append(String.valueOf(this.logName)).append(" - ");
        }
        stringBuffer.append(String.valueOf(object));
        return stringBuffer.toString();
    }

    protected boolean isLevelEnabled(int n) {
        return n >= this.currentLogLevel;
    }

    static {
        try {
            Object object;
            Object object2;
            Enumeration<?> enumeration = System.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if (null == object2 || !((String)object2).startsWith(SYSTEM_PREFIX)) continue;
                nblogProps.setProperty((String)object2, System.getProperty((String)object2));
            }
            object2 = null;
            try {
                object = Thread.class.getMethod("getContextClassLoader", null);
                object2 = (ClassLoader)((Method)object).invoke((Object)Thread.currentThread(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (object2 == null) {
                object2 = NetBeansLog.class.getClassLoader();
            }
            if ((object = nblogProps.getProperty(SHOW_LOG_NAME_PROPERTY)) != null) {
                showLogName = "true".equalsIgnoreCase((String)object);
            }
            if ((object = nblogProps.getProperty(SHOW_SHORT_LOG_NAME_PROPERTY)) != null) {
                showShortName = "true".equalsIgnoreCase((String)object);
            }
            if ((object = nblogProps.getProperty(SHOW_DATE_TIME_PROPERTY)) != null) {
                showDateTime = "true".equalsIgnoreCase((String)object);
            }
            if (showDateTime) {
                dateFormatter = new SimpleDateFormat(nblogProps.getProperty(DATE_FORMAT_PROPERTY, DATE_FORMAT_DEFAULT));
            }
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
        }
    }
}

