/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer.test.helpers;

import cern.gp.explorer.test.helpers.SimpleDemoBean;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.NodeList;
import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.util.Comparator;

public class RecursiveChildrenListManager
implements ChildrenListManager {
    private int count = 0;
    private final int children;
    private final int childrenPerParent;
    private final Class beanClass;
    private final Constructor beanConstructor;
    private static final int DEFAULT_CHILDREN = 10;
    private static final int DEFAULT_CHILDREN_PER_PARENT = 3;
    private static final Class DEFAULT_BEAN_CLASS = SimpleDemoBean.class;

    public RecursiveChildrenListManager() {
        this(10, 3);
    }

    public RecursiveChildrenListManager(int n) {
        this(DEFAULT_BEAN_CLASS, n, 3);
    }

    public RecursiveChildrenListManager(int n, int n2) {
        this(DEFAULT_BEAN_CLASS, n, n2);
    }

    public RecursiveChildrenListManager(Class clazz, int n, int n2) {
        this.beanClass = clazz;
        this.children = n;
        this.childrenPerParent = n2;
        this.beanConstructor = RecursiveChildrenListManager.getConstructor(clazz);
    }

    @Override
    public Comparator getComparator() {
        return null;
    }

    @Override
    public void initChildrenList(NodeList nodeList) {
        ++this.count;
        try {
            if (this.count < this.children) {
                for (int i = 0; i < this.childrenPerParent; ++i) {
                    nodeList.addNode(NodeFactory.createNode(this.createBean("child " + this.count + i), this));
                }
            } else {
                for (int i = 0; i < this.childrenPerParent; ++i) {
                    nodeList.addNode(NodeFactory.createNode(this.createBean("child " + this.count + i)));
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    private static Constructor getConstructor(Class clazz) {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("warning: bad paramenter " + clazz + "; should have a Constructor that accepts one string as argument");
            try {
                return clazz.getConstructor(null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                System.err.println("warning: bad paramenter " + clazz + "; must at least have a non-argument Constructor!");
                try {
                    return SimpleDemoBean.class.getConstructor(String.class);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    System.err.println("internal error: SimpleDemoBean.class does not have a String-constructor");
                    return null;
                }
            }
        }
    }

    private Object createBean(String string) {
        try {
            return this.beanConstructor.newInstance(string);
        }
        catch (Exception exception) {
            System.err.println("error instantiating beanClass " + this.beanClass + " with String constructor");
            try {
                return this.beanClass.newInstance();
            }
            catch (Exception exception2) {
                System.err.println("error instantiating beanClass " + this.beanClass + " with default constructor");
                return null;
            }
        }
    }
}

