/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.explorer;

import cern.gp.explorer.TableHolder;
import cern.gp.explorer.TablePropertyHolder;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.util.ArrayUtil;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;

class TableHolderImpl
implements TableHolder {
    private TablePropertyHolder tablePropertyHolder;

    TableHolderImpl(TablePropertyHolder tablePropertyHolder) {
        this.tablePropertyHolder = tablePropertyHolder;
    }

    @Override
    public void setTableColumns(Class clazz) throws IntrospectionException {
        this.setTableColumns(TableHolderImpl.calcPropertyDescriptorsFor(clazz, null));
    }

    @Override
    public void setTableColumns(Class clazz, String[] stringArray) throws IntrospectionException {
        this.setTableColumns(TableHolderImpl.calcPropertyDescriptorsFor(clazz, stringArray));
    }

    @Override
    public void setTableColumns(Class[] classArray, String[] stringArray) {
        this.setTableColumns(classArray, stringArray, (boolean[])null);
    }

    @Override
    public void setTableColumns(Class[] classArray, String[] stringArray, boolean[] blArray) {
        Node.Property[] propertyArray = new Node.Property[classArray.length];
        for (int i = 0; i < propertyArray.length; ++i) {
            propertyArray[i] = new TableViewColumnProperty(stringArray[i], null, classArray[i]);
        }
        this.tablePropertyHolder.setProperties(propertyArray, blArray);
    }

    @Override
    public void setTableColumns(Object object) throws IntrospectionException {
        this.setTableColumns(object, null);
    }

    @Override
    public void setTableColumns(Object object, String[] stringArray) throws IntrospectionException {
        this.setTableColumns(object, stringArray, null);
    }

    @Override
    public void setTableColumns(Object object, String[] stringArray, boolean[] blArray) throws IntrospectionException {
        this.setTableColumns(NodeFactory.createNode(object), stringArray, blArray);
    }

    @Override
    public void setTableColumns(GPNode gPNode, String[] stringArray) {
        this.setTableColumns(gPNode, stringArray, null);
    }

    @Override
    public void setTableColumns(GPNode gPNode, String[] stringArray, boolean[] blArray) {
        Node.Property[] propertyArray;
        Node.Property[] propertyArray2;
        Node.PropertySet[] propertySetArray = gPNode.getPeerNode().getPropertySets();
        Node.Property[] propertyArray3 = propertySetArray[0].getProperties();
        if (propertySetArray.length == 1) {
            propertyArray2 = propertyArray3;
        } else {
            propertyArray = propertySetArray[1].getProperties();
            propertyArray2 = new Node.Property[propertyArray3.length + propertyArray.length];
            System.arraycopy(propertyArray3, 0, propertyArray2, 0, propertyArray3.length);
            System.arraycopy(propertyArray, 0, propertyArray2, propertyArray3.length, propertyArray.length);
        }
        if (stringArray == null) {
            propertyArray = propertyArray2;
        } else {
            ArrayList<Node.Property> arrayList = new ArrayList<Node.Property>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < propertyArray2.length; ++j) {
                    if (!stringArray[i].equals(propertyArray2[j].getName())) continue;
                    arrayList.add(propertyArray2[j]);
                }
            }
            propertyArray = arrayList.toArray(new Node.Property[arrayList.size()]);
        }
        this.tablePropertyHolder.setProperties(propertyArray, blArray);
    }

    private void setTableColumns(PropertyDescriptor[] propertyDescriptorArray) {
        new UnsupportedOperationException("deprecated").printStackTrace();
        this.tablePropertyHolder.setProperties(TableHolderImpl.calcNodeProperty(propertyDescriptorArray), null);
    }

    public static Node.Property[] calcNodeProperty(PropertyDescriptor[] propertyDescriptorArray) {
        Node.Property[] propertyArray = new Node.Property[propertyDescriptorArray.length];
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            propertyArray[i] = new TableViewColumnProperty(propertyDescriptorArray[i]);
        }
        return propertyArray;
    }

    public static PropertyDescriptor[] calcPropertyDescriptorsFor(Class clazz, String[] stringArray) throws IntrospectionException {
        Object[] objectArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].isHidden()) continue;
            arrayList.add(objectArray[i]);
        }
        objectArray = arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
        if (stringArray == null) {
            return objectArray;
        }
        if (stringArray.length > objectArray.length) {
            System.err.println("Error: more propNames than beanClass properties!");
            System.err.println("PropNames = ");
            ArrayUtil.printArray(stringArray, 8);
            System.err.println("PropDescr = ");
            ArrayUtil.printArray(objectArray, 8);
            return null;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < objectArray.length; ++j) {
                if (!stringArray[i].equals(((FeatureDescriptor)objectArray[j]).getName())) continue;
                arrayList2.add(objectArray[j]);
            }
        }
        return arrayList2.toArray(new PropertyDescriptor[arrayList2.size()]);
    }

    private static class TableViewColumnProperty
    extends Node.Property {
        public TableViewColumnProperty(String string, String string2, Class clazz) {
            super(clazz);
            this.setName(string);
            if (string2 != null) {
                super.setDisplayName(string2);
            }
        }

        public TableViewColumnProperty(PropertyDescriptor propertyDescriptor) {
            super(propertyDescriptor.getPropertyType());
            this.setName(propertyDescriptor.getName());
            if (propertyDescriptor.getDisplayName() != null) {
                super.setDisplayName(propertyDescriptor.getDisplayName());
            }
        }

        public boolean canRead() {
            return false;
        }

        public boolean canWrite() {
            return false;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        }
    }

    static class SelectiveTableModel
    extends NodeTableModel {
        private final Class[] displayBeans;

        SelectiveTableModel(Class[] classArray) {
            this.displayBeans = classArray;
        }

        protected Node.Property getPropertyFor(Node node, Node.Property property) {
            if (node instanceof GPNode) {
                Class<?> clazz = ((GPNode)node).getBean().getClass();
                for (int i = 0; i < this.displayBeans.length; ++i) {
                    if (!this.displayBeans[i].equals(clazz)) continue;
                    return super.getPropertyFor(node, property);
                }
                return null;
            }
            return super.getPropertyFor(node, property);
        }
    }
}

