/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans.impl;

import cern.gp.beans.impl.NodeUpdater;
import cern.gp.beans.impl.NodeUpdaterListener;
import java.awt.Image;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

abstract class ListenerBasedNodeUpdater
implements NodeUpdater {
    private ListenerList eventListeners = new WeakReferenceListenerList();

    protected ListenerBasedNodeUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeUpdaterListener(NodeUpdaterListener nodeUpdaterListener) {
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            if (!this.eventListeners.contains(nodeUpdaterListener)) {
                this.eventListeners.add(nodeUpdaterListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeUpdaterListener(NodeUpdaterListener nodeUpdaterListener) {
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            this.eventListeners.remove(nodeUpdaterListener);
        }
    }

    protected final boolean hasListeners() {
        return !this.eventListeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireNameChange(String string) {
        if (!this.hasListeners()) {
            return;
        }
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ((NodeUpdaterListener)iterator.next()).nameChanged(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireDisplayNameChange(String string) {
        if (!this.hasListeners()) {
            return;
        }
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ((NodeUpdaterListener)iterator.next()).displayNameChanged(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireShortDescriptionChange(String string) {
        if (!this.hasListeners()) {
            return;
        }
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ((NodeUpdaterListener)iterator.next()).shortDescriptionChanged(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireNodeDefaultActionChange(String string) {
        if (!this.hasListeners()) {
            return;
        }
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ((NodeUpdaterListener)iterator.next()).nodeDefaultActionChanged(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireNodeIconChange(Image image) {
        if (!this.hasListeners()) {
            return;
        }
        ListenerList listenerList = this.eventListeners;
        synchronized (listenerList) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ((NodeUpdaterListener)iterator.next()).nodeIconChanged(image);
            }
        }
    }

    private class WeakReferenceIterator
    implements Iterator {
        private Iterator iterator;
        private Object nextObject;

        public WeakReferenceIterator(Iterator iterator) {
            this.iterator = iterator;
            this.nextObject = this.getNextObject();
        }

        @Override
        public boolean hasNext() {
            return this.nextObject != null;
        }

        public Object next() {
            Object object = this.nextObject;
            this.nextObject = this.getNextObject();
            return object;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        private Object getNextObject() {
            while (this.iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)this.iterator.next();
                Object t = weakReference.get();
                if (t == null) {
                    this.iterator.remove();
                    continue;
                }
                return t;
            }
            return null;
        }
    }

    private class WeakReferenceListenerList
    extends PlainListenerList {
        @Override
        public boolean contains(NodeUpdaterListener nodeUpdaterListener) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != nodeUpdaterListener) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean add(NodeUpdaterListener nodeUpdaterListener) {
            return this.list.add(new WeakReference<NodeUpdaterListener>(nodeUpdaterListener));
        }

        @Override
        public boolean remove(NodeUpdaterListener nodeUpdaterListener) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != nodeUpdaterListener) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        @Override
        public Iterator iterator() {
            return new WeakReferenceIterator(this.list.iterator());
        }
    }

    private class PlainListenerList
    implements ListenerList {
        protected ArrayList list = new ArrayList();

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean contains(NodeUpdaterListener nodeUpdaterListener) {
            return this.list.contains(nodeUpdaterListener);
        }

        @Override
        public boolean add(NodeUpdaterListener nodeUpdaterListener) {
            return this.list.add(nodeUpdaterListener);
        }

        @Override
        public boolean remove(NodeUpdaterListener nodeUpdaterListener) {
            return this.list.remove(nodeUpdaterListener);
        }

        @Override
        public Iterator iterator() {
            return this.list.iterator();
        }
    }

    private static interface ListenerList {
        public boolean isEmpty();

        public int size();

        public boolean contains(NodeUpdaterListener var1);

        public boolean add(NodeUpdaterListener var1);

        public boolean remove(NodeUpdaterListener var1);

        public Iterator iterator();
    }
}

