/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans.impl;

import cern.gp.beans.BeanTagger;
import cern.gp.beans.BeanUtils;
import cern.gp.beans.PropertyInfo;
import cern.gp.beans.impl.NodeUpdater;
import cern.gp.util.GPManager;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.util.Utilities;

public abstract class IntrospectionBasedNodeUpdater
implements NodeUpdater {
    private static final InternalPropertyDescriptor NAME_DESC = new InternalPropertyDescriptor("name", "getName", String.class);
    private static final InternalPropertyDescriptor DISPLAYNAME_DESC = new InternalPropertyDescriptor("displayName", "getDisplayName", String.class);
    private static final InternalPropertyDescriptor SHORTDESCRIPTION_DESC = new InternalPropertyDescriptor("shortDescription", "getShortDescription", String.class);
    private static final InternalPropertyDescriptor NODE_ICON_DESC = new InternalPropertyDescriptor("nodeIcon", "getNodeIcon", Image.class);
    private static final InternalPropertyDescriptor NODE_DEFAULT_ACTION_DESC = new InternalPropertyDescriptor("nodeDefaultAction", "getNodeDefaultAction", String.class);
    private static final InternalPropertyDescriptor NODE_ACTIONS_DESC = new InternalPropertyDescriptor("nodeActions", "getNodeActions", String[].class);
    private static final InternalPropertyDescriptor NODE_PROPERTIES_CACHEABLE_DESC = new InternalPropertyDescriptor("nodePropertiesCacheable", "getNodePropertiesCacheable", Boolean.class);
    private static final InternalPropertyDescriptor PROPERTY_INFO_DESC = new InternalPropertyDescriptor("propertyInfo", "getPropertyInfo", PropertyInfo[].class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private Method _nameGetter;
    private Method _displayNameGetter;
    private Method _shortDescriptionGetter;
    private Method _nodeIconGetter;
    private Method _nodeDefaultActionGetter;
    private Method _nodeActionsGetter;
    private Method _nodePropertiesCacheableGetter;
    private Method _propertyInfoGetter;
    private boolean _shouldHideName;
    private boolean _shouldHideDisplayName;
    private boolean _shouldHideShortDescription;
    private Method _removePropertyChangeListenerMethod;
    private PropertyChangeListener _propertyChangeListener;
    private Object _bean;
    private BeanInfo _beanInfo;
    private boolean _hasRegisteredListener;

    protected IntrospectionBasedNodeUpdater(Object object) throws IntrospectionException {
        Class clazz = BeanUtils.findTargetClass(object);
        this.initialize(object, Utilities.getBeanInfo((Class)clazz), clazz);
    }

    protected IntrospectionBasedNodeUpdater(Object object, BeanInfo beanInfo) throws IntrospectionException {
        this(object, beanInfo, beanInfo.getClass());
    }

    protected IntrospectionBasedNodeUpdater(Object object, BeanInfo beanInfo, Class clazz) throws IntrospectionException {
        this.initialize(object, beanInfo, clazz);
    }

    private final void initialize(Object object, BeanInfo beanInfo, Class clazz) {
        this._bean = object;
        this._beanInfo = beanInfo;
        this._nameGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, NAME_DESC);
        this._shouldHideName = this._nameGetter == null;
        this._displayNameGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, DISPLAYNAME_DESC);
        if (this._displayNameGetter == null) {
            this._displayNameGetter = this._nameGetter;
            this._shouldHideDisplayName = true;
        } else if (this.getStringFromGetterMethod(this._displayNameGetter) == null) {
            this._displayNameGetter = this._nameGetter;
            this._shouldHideDisplayName = true;
        }
        this._shortDescriptionGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, SHORTDESCRIPTION_DESC);
        this._shouldHideShortDescription = this._shortDescriptionGetter == null || this.getStringFromGetterMethod(this._shortDescriptionGetter) == null;
        this._nodeIconGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, NODE_ICON_DESC);
        this._nodeDefaultActionGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, NODE_DEFAULT_ACTION_DESC);
        this._nodeActionsGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, NODE_ACTIONS_DESC);
        this._nodePropertiesCacheableGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, NODE_PROPERTIES_CACHEABLE_DESC);
        this._propertyInfoGetter = IntrospectionBasedNodeUpdater.findGetterMethod(clazz, PROPERTY_INFO_DESC);
        this.findPropertyChangeListenerMethods();
    }

    public boolean isPropertyHidden(PropertyDescriptor propertyDescriptor) {
        String string = propertyDescriptor.getName();
        if ("name".equals(string)) {
            propertyDescriptor.setDisplayName("Name");
            return this._shouldHideName;
        }
        if ("displayName".equals(string)) {
            propertyDescriptor.setDisplayName("Display name");
            return this._shouldHideDisplayName;
        }
        if ("shortDescription".equals(string)) {
            propertyDescriptor.setDisplayName("Short description");
            return this._shouldHideShortDescription;
        }
        if ("class".equals(string)) {
            return true;
        }
        if ("nodeIcon".equals(string)) {
            return true;
        }
        if ("nodeDefaultAction".equals(string)) {
            return true;
        }
        if ("nodeActions".equals(string)) {
            return true;
        }
        if ("nodePropertiesCacheable".equals(string)) {
            return true;
        }
        return "propertyInfo".equals(string);
    }

    @Override
    public String getName() {
        String string;
        if (this._nameGetter != null && (string = this.getStringFromGetterMethod(this._nameGetter)) != null) {
            return string;
        }
        return BeanUtils.generateUniqueBeanName(this._bean);
    }

    @Override
    public String getDisplayName() {
        String string;
        if (this._displayNameGetter != null && (string = this.getStringFromGetterMethod(this._displayNameGetter)) != null) {
            return string;
        }
        return this._beanInfo.getBeanDescriptor().getDisplayName();
    }

    @Override
    public String getShortDescription() {
        String string;
        if (this._shortDescriptionGetter != null && (string = this.getStringFromGetterMethod(this._shortDescriptionGetter)) != null) {
            return string;
        }
        return this._beanInfo.getBeanDescriptor().getShortDescription();
    }

    @Override
    public Image getNodeIcon() {
        Image image;
        if (this._nodeIconGetter != null && (image = (Image)this.getObjectFromGetterMethod(this._nodeIconGetter)) != null) {
            return image;
        }
        return this._beanInfo.getIcon(1);
    }

    @Override
    public String getNodeDefaultAction() {
        String string;
        if (this._nodeDefaultActionGetter != null && (string = this.getStringFromGetterMethod(this._nodeDefaultActionGetter)) != null) {
            return string;
        }
        return BeanTagger.getDefaultAction(this._beanInfo);
    }

    @Override
    public String[] getNodeActions() {
        String[] stringArray;
        if (this._nodeActionsGetter != null && (stringArray = (String[])this.getObjectFromGetterMethod(this._nodeActionsGetter)) != null) {
            return stringArray;
        }
        return BeanTagger.getActions(this._beanInfo);
    }

    @Override
    public Boolean getNodePropertiesCacheable() {
        Boolean bl;
        if (this._nodePropertiesCacheableGetter != null && (bl = (Boolean)this.getObjectFromGetterMethod(this._nodePropertiesCacheableGetter)) != null) {
            return bl;
        }
        return BeanTagger.isCacheable(this._beanInfo.getBeanDescriptor());
    }

    @Override
    public PropertyInfo[] getPropertyInfo() {
        PropertyInfo[] propertyInfoArray;
        if (this._nodePropertiesCacheableGetter != null && (propertyInfoArray = (PropertyInfo[])this.getObjectFromGetterMethod(this._propertyInfoGetter)) != null) {
            return propertyInfoArray;
        }
        return null;
    }

    protected abstract void firePropertyChange(String var1, Object var2, Object var3);

    protected abstract void fireNameChange(String var1);

    protected abstract void fireDisplayNameChange(String var1);

    protected abstract void fireShortDescriptionChange(String var1);

    protected abstract void fireNodeDefaultActionChange(String var1);

    protected abstract void fireNodeIconChange(Image var1);

    protected final void removePropertyChangeListener() {
        if (this._removePropertyChangeListenerMethod != null) {
            try {
                this._removePropertyChangeListenerMethod.invoke(this._bean, this._propertyChangeListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final boolean hasRegisteredListener() {
        return this._hasRegisteredListener;
    }

    private void findPropertyChangeListenerMethods() {
        EventSetDescriptor[] eventSetDescriptorArray = this._beanInfo.getEventSetDescriptors();
        for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
            Method method = eventSetDescriptorArray[i].getAddListenerMethod();
            if (method == null || !method.getName().equals("addPropertyChangeListener") || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                this._propertyChangeListener = new PropertyChangeListenerImpl();
                method.invoke(this._bean, this._propertyChangeListener);
                this._hasRegisteredListener = true;
            }
            catch (Exception exception) {
                GPManager.notify(65536, exception);
            }
            this._removePropertyChangeListenerMethod = eventSetDescriptorArray[i].getRemoveListenerMethod();
            break;
        }
    }

    private final String getStringFromGetterMethod(Method method) {
        try {
            return (String)method.invoke(this._bean, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final Object getObjectFromGetterMethod(Method method) {
        try {
            return method.invoke(this._bean, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Method findGetterMethod(Class clazz, InternalPropertyDescriptor internalPropertyDescriptor) {
        try {
            Method method = clazz.getMethod(internalPropertyDescriptor.getterName, EMPTY_CLASS_ARRAY);
            if (method.getReturnType() != internalPropertyDescriptor.type) {
                return null;
            }
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class InternalPropertyDescriptor {
        String name;
        String getterName;
        Class type;

        InternalPropertyDescriptor(String string, String string2, Class clazz) {
            this.name = string;
            this.getterName = string2;
            this.type = clazz;
        }
    }

    private final class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            IntrospectionBasedNodeUpdater.this.firePropertyChange(string, propertyChangeEvent.getOldValue(), object);
            if (string == null) {
                IntrospectionBasedNodeUpdater.this.fireNameChange(IntrospectionBasedNodeUpdater.this.getName());
                IntrospectionBasedNodeUpdater.this.fireDisplayNameChange(IntrospectionBasedNodeUpdater.this.getDisplayName());
                IntrospectionBasedNodeUpdater.this.fireShortDescriptionChange(IntrospectionBasedNodeUpdater.this.getShortDescription());
                IntrospectionBasedNodeUpdater.this.fireNodeDefaultActionChange(IntrospectionBasedNodeUpdater.this.getNodeDefaultAction());
                IntrospectionBasedNodeUpdater.this.fireNodeIconChange(IntrospectionBasedNodeUpdater.this.getNodeIcon());
            } else if ("name".equals(string)) {
                if (object == null || !(object instanceof String)) {
                    IntrospectionBasedNodeUpdater.this.fireNameChange(IntrospectionBasedNodeUpdater.this.getName());
                } else {
                    IntrospectionBasedNodeUpdater.this.fireNameChange((String)object);
                }
            } else if ("displayName".equals(string)) {
                if (object == null || !(object instanceof String)) {
                    IntrospectionBasedNodeUpdater.this.fireDisplayNameChange(IntrospectionBasedNodeUpdater.this.getDisplayName());
                } else {
                    IntrospectionBasedNodeUpdater.this.fireDisplayNameChange((String)object);
                }
            } else if ("shortDescription".equals(string)) {
                if (object == null || !(object instanceof String)) {
                    IntrospectionBasedNodeUpdater.this.fireShortDescriptionChange(IntrospectionBasedNodeUpdater.this.getShortDescription());
                } else {
                    IntrospectionBasedNodeUpdater.this.fireShortDescriptionChange((String)object);
                }
            } else if ("nodeDefaultAction".equals(string)) {
                if (object == null || !(object instanceof String)) {
                    IntrospectionBasedNodeUpdater.this.fireNodeDefaultActionChange(IntrospectionBasedNodeUpdater.this.getNodeDefaultAction());
                } else {
                    IntrospectionBasedNodeUpdater.this.fireNodeDefaultActionChange((String)object);
                }
            } else if ("nodeIcon".equals(string)) {
                if (object == null || !(object instanceof String[])) {
                    IntrospectionBasedNodeUpdater.this.fireNodeIconChange(IntrospectionBasedNodeUpdater.this.getNodeIcon());
                } else {
                    IntrospectionBasedNodeUpdater.this.fireNodeIconChange((Image)object);
                }
            }
        }
    }
}

