/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans.editors.support;

import cern.gp.beans.editors.support.ColorMaster;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public abstract class ColoredEditorSupport
extends PropertyEditorSupport
implements ColorMaster {
    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        ColoredEditorSupport.paintValue(graphics, rectangle, this.getAsText(), this.getBackgroundColor(), this.getForegroundColor());
    }

    @Override
    public boolean isPaintable() {
        return this.getBackgroundColor() != null || this.getForegroundColor() != null;
    }

    public static void paintValue(Graphics graphics, Rectangle rectangle, String string, Color color, Color color2) {
        Color color3 = graphics.getColor();
        if (color != null) {
            graphics.setColor(color);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = 6;
        if (color2 != null) {
            graphics.setColor(color2);
        } else {
            graphics.setColor(Color.black);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x + n, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        graphics.setColor(color3);
    }

    @Override
    public abstract Color getBackgroundColor();

    @Override
    public abstract Color getForegroundColor();
}

