/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.Node;

public class CheckBoxEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ExPropertyEditor {
    private boolean editableMode;
    private PropertyEnv propertyEnv;
    private final JCheckBox renderer;
    private JCheckBox editor;

    public CheckBoxEditor() {
        this(true);
    }

    public CheckBoxEditor(boolean bl) {
        this.editableMode = bl;
        this.renderer = new JCheckBox();
        this.renderer.setOpaque(false);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl = this.getBoolValue();
        this.renderer.setSelected(bl);
        this.renderer.setSize(rectangle.width, rectangle.height);
        this.renderer.paint(graphics);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public Component getInPlaceCustomEditor() {
        if (this.editor == null) {
            this.editor = new JCheckBox();
            this.editor.setOpaque(false);
            this.editor.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    CheckBoxEditor.this.setBoolValue(CheckBoxEditor.this.editor.isSelected());
                }
            });
        }
        if (!this.editableMode) {
            this.editor.setSelected(this.getBoolValue());
        } else {
            boolean bl = !this.getBoolValue();
            this.editor.setSelected(bl);
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            FeatureDescriptor featureDescriptor = this.propertyEnv.getFeatureDescriptor();
            if (featureDescriptor instanceof Node.Property) {
                try {
                    this.setNodeProperty(bl, (Node.Property)featureDescriptor);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            } else {
                System.out.println("fd not Node.Property, but " + featureDescriptor.getClass());
            }
            this.setBoolValue(bl);
        }
        return this.editor;
    }

    protected void setNodeProperty(boolean bl, Node.Property property) throws IllegalAccessException, InvocationTargetException {
        property.setValue((Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean hasInPlaceCustomEditor() {
        return true;
    }

    public boolean supportsEditingTaggedValues() {
        return false;
    }

    protected boolean getBoolValue() {
        return (Boolean)this.getValue();
    }

    protected void setBoolValue(boolean bl) {
        this.setValue(bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = propertyEnv;
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.renderer.setOpaque(true);
            this.renderer.setBackground(color);
        } else {
            this.renderer.setOpaque(false);
        }
    }
}

