/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.beans;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.openide.util.WeakListener;

public class BeanUtils {
    private BeanUtils() {
    }

    public static final String generateUniqueBeanName(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
    }

    public static final void registerEditorSearchPaths(String[] stringArray) {
        PropertyEditorManager.setEditorSearchPath(BeanUtils.computePaths(PropertyEditorManager.getEditorSearchPath(), stringArray));
    }

    public static final void registerBeanInfoSearchPaths(String[] stringArray) {
        Introspector.setBeanInfoSearchPath(BeanUtils.computePaths(Introspector.getBeanInfoSearchPath(), stringArray));
    }

    private static final String[] computePaths(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        String[] stringArray3 = (String[])stringArray2.clone();
        int n2 = 0;
        for (n = 0; n < stringArray3.length; ++n) {
            if (BeanUtils.checkDoesBeanInfoPathExist(stringArray, stringArray3[n])) {
                stringArray3[n] = null;
                continue;
            }
            ++n2;
        }
        if (n2 == 0) {
            return stringArray;
        }
        n = stringArray.length;
        String[] stringArray4 = new String[n2 + n];
        System.arraycopy(stringArray, 0, stringArray4, 0, n);
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i] == null) continue;
            stringArray4[n] = stringArray3[i];
            ++n;
        }
        return stringArray4;
    }

    private static final boolean checkDoesBeanInfoPathExist(String[] stringArray, String string) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static final Image loadImage(final String string, final Class clazz) {
        try {
            ImageProducer imageProducer = (ImageProducer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = clazz.getResource(string);
                    if (uRL == null) {
                        return null;
                    }
                    try {
                        return uRL.getContent();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (imageProducer == null) {
                return null;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return toolkit.createImage(imageProducer);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Class findTargetClass(Object object) {
        Class<Object> clazz = object.getClass();
        while (!Modifier.isPublic(clazz.getModifiers()) && !BeanUtils.hasExplicitBeanInfo(clazz)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            clazz = Object.class;
        }
        return clazz;
    }

    public static final boolean hasExplicitBeanInfo(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        string = string.substring(n + 1);
        String[] stringArray = Introspector.getBeanInfoSearchPath();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i] + '.' + string + "BeanInfo";
            try {
                Class.forName(string2);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return false;
    }

    public static void addWeakListenerByReflection(PropertyChangeListener propertyChangeListener, Object object) {
        try {
            PropertyChangeListener propertyChangeListener2 = WeakListener.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)object);
            Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, propertyChangeListener2);
        }
        catch (Exception exception) {
            System.err.println("Warning: unable to add a property change listener to object " + object);
        }
    }
}

