/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.actions.support;

import cern.gp.actions.support.BeanAction;
import cern.gp.capabilities.Capability;
import cern.gp.nodes.GPNode;
import cern.gp.util.GPManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanActionSupport
extends BeanAction {
    private Method capabilityMethod;
    private boolean isNoArg;

    public BeanActionSupport(Class clazz) throws IllegalArgumentException {
        this(clazz, 7);
    }

    public BeanActionSupport(Class clazz, int n) throws IllegalArgumentException {
        super(clazz, n);
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length != 1) {
            throw new IllegalArgumentException("parameter " + clazz + " must have exactly one method with no argument");
        }
        this.capabilityMethod = methodArray[0];
        if (this.capabilityMethod.getParameterTypes().length == 0) {
            this.isNoArg = true;
        } else if (this.capabilityMethod.getParameterTypes().length != 1 || !GPNode.class.isAssignableFrom(this.capabilityMethod.getParameterTypes()[0])) {
            throw new IllegalArgumentException("parameter " + clazz + " must have exactly one method with no argument or with a GPNode as argument");
        }
    }

    @Override
    protected void performCapability(GPNode gPNode, Capability capability) throws InvocationTargetException {
        try {
            if (this.isNoArg) {
                this.capabilityMethod.invoke((Object)capability, null);
            } else {
                this.capabilityMethod.invoke((Object)capability, gPNode);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            GPManager.notify(4096, illegalAccessException);
        }
    }
}

