/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.actions.support;

import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.ContextAwareAction;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class ActionUtils {
    private static ImageIcon BLANK_ICON = null;

    private ActionUtils() {
    }

    public static JButton createJButton(Class clazz) {
        return ActionUtils.createJButton(SystemAction.get((Class)clazz));
    }

    public static JButton createJButton(TopComponent topComponent, Class clazz) {
        Action action = ActionUtils.actionForComp(topComponent, clazz);
        return ActionUtils.createJButton(action);
    }

    public static JButton createJButton(SystemAction systemAction) {
        JButton jButton = new JButton();
        SystemAction systemAction2 = systemAction;
        Actions.connect((AbstractButton)jButton, (Action)systemAction2);
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)systemAction.getName());
        return jButton;
    }

    public static JButton createJButton(Action action) {
        JButton jButton = new JButton();
        Actions.connect((AbstractButton)jButton, (Action)action);
        String string = "invalid";
        string = action instanceof SystemAction ? ((SystemAction)action).getName() : action.getValue("Name").toString();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)string);
        return jButton;
    }

    public static JPanel createJButtonPanel(Class[] classArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        return (JPanel)ActionUtils.addJButtons(jPanel, classArray);
    }

    public static JPanel createJButtonPanel(TopComponent topComponent, Class[] classArray) {
        if (topComponent == null) {
            return ActionUtils.createJButtonPanel(classArray);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3));
        for (int i = 0; i < classArray.length; ++i) {
            jPanel.add(ActionUtils.createJButton(topComponent, classArray[i]));
        }
        return jPanel;
    }

    public static JComponent addJButtons(JComponent jComponent, Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            jComponent.add(ActionUtils.createJButton(classArray[i]));
        }
        return jComponent;
    }

    public static ImageIcon getBlankIcon() {
        if (BLANK_ICON == null) {
            BLANK_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/actions/empty.gif"));
        }
        return BLANK_ICON;
    }

    public static Action actionForComp(TopComponent topComponent, Class clazz) {
        SystemAction systemAction = SystemAction.get((Class)clazz);
        return ((ContextAwareAction)systemAction).createContextAwareInstance(topComponent.getLookup());
    }
}

