/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.actions;

import cern.gp.actions.MoveUpAction;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

class MoveUpActionCopiedFromNetbeans
extends NodeAction {
    static final long serialVersionUID = -8201315242813084212L;
    private static final String PROP_ORDER_LISTENER = "sellistener";
    private Reference curIndexCookie;
    private static ErrorManager err = null;
    private static boolean errInited = false;

    MoveUpActionCopiedFromNetbeans() {
    }

    private static final void initErr() {
        if (!errInited) {
            errInited = true;
            ErrorManager errorManager = ErrorManager.getDefault();
            ErrorManager errorManager2 = errorManager.getInstance("org.openide.actions.MoveUpAction");
            if (errorManager2.isLoggable(0)) {
                err = errorManager2;
            }
        }
    }

    protected void initialize() {
        MoveUpActionCopiedFromNetbeans.initErr();
        if (err != null) {
            err.log(0, "initialize");
        }
        super.initialize();
        OrderingListener orderingListener = new OrderingListener();
        this.putProperty(PROP_ORDER_LISTENER, orderingListener);
    }

    private Index getCurIndexCookie() {
        return this.curIndexCookie == null ? null : (Index)this.curIndexCookie.get();
    }

    protected void performAction(Node[] nodeArray) {
        Index index = this.getIndexCookie(nodeArray);
        if (index == null) {
            return;
        }
        int n = index.indexOf(nodeArray[0]);
        if (n > 0) {
            index.moveUp(n);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        Index index;
        MoveUpActionCopiedFromNetbeans.initErr();
        if (err != null) {
            err.log(0, "enable; activatedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray)));
        }
        if ((index = this.getCurIndexCookie()) != null) {
            index.removeChangeListener((ChangeListener)this.getProperty(PROP_ORDER_LISTENER));
        }
        Index index2 = this.getIndexCookie(nodeArray);
        if (err != null) {
            err.log(0, "enable; cookie=" + index2);
        }
        if (index2 == null) {
            return false;
        }
        index2.addChangeListener((ChangeListener)((OrderingListener)this.getProperty(PROP_ORDER_LISTENER)));
        this.curIndexCookie = new WeakReference<Index>(index2);
        int n = index2.indexOf(nodeArray[0]);
        if (err != null) {
            err.log(0, "enable; index=" + n);
            if (n == -1) {
                Node node = nodeArray[0].getParentNode();
                err.log(0, "enable; parent=" + node + "; parent.children=" + Arrays.asList(node.getChildren().getNodes()));
            }
        }
        return n > 0;
    }

    public String getName() {
        return "Move &Up";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveUpAction.class);
    }

    private Index getIndexCookie(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0].getParentNode();
        if (node == null) {
            return null;
        }
        return (Index)node.getCookie(Index.class);
    }

    private final class OrderingListener
    implements ChangeListener {
        private OrderingListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MoveUpActionCopiedFromNetbeans.initErr();
            Node[] nodeArray = MoveUpActionCopiedFromNetbeans.this.getActivatedNodes();
            if (err != null) {
                err.log(0, "stateChanged; activatedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray)));
            }
            Index index = MoveUpActionCopiedFromNetbeans.this.getIndexCookie(nodeArray);
            if (err != null) {
                err.log(0, "stateChanged; cookie=" + index);
            }
            if (index == null) {
                MoveUpActionCopiedFromNetbeans.this.setEnabled(false);
            } else {
                int n = index.indexOf(nodeArray[0]);
                if (err != null) {
                    err.log(0, "stateChanged; index=" + n);
                }
                MoveUpActionCopiedFromNetbeans.this.setEnabled(n > 0);
            }
        }
    }
}

