/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

class MoveDownActionCopiedFromNetbeans
extends NodeAction {
    static final long serialVersionUID = -6895014137711668193L;
    private static final String PROP_ORDER_LISTENER = "sellistener";
    private Reference curIndexCookie;

    MoveDownActionCopiedFromNetbeans() {
    }

    protected void initialize() {
        super.initialize();
        OrderingListener orderingListener = new OrderingListener();
        this.putProperty(PROP_ORDER_LISTENER, orderingListener);
    }

    private Index getCurIndexCookie() {
        return this.curIndexCookie == null ? null : (Index)this.curIndexCookie.get();
    }

    protected void performAction(Node[] nodeArray) {
        Index index = this.getIndexCookie(nodeArray);
        if (index == null) {
            return;
        }
        int n = index.indexOf(nodeArray[0]);
        if (n >= 0 && n < index.getNodesCount() - 1) {
            index.moveDown(n);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        Index index;
        Index index2 = this.getCurIndexCookie();
        if (index2 != null) {
            index2.removeChangeListener((ChangeListener)this.getProperty(PROP_ORDER_LISTENER));
            index2 = null;
        }
        if ((index = this.getIndexCookie(nodeArray)) == null) {
            return false;
        }
        int n = index.indexOf(nodeArray[0]);
        index.addChangeListener((ChangeListener)((OrderingListener)this.getProperty(PROP_ORDER_LISTENER)));
        this.curIndexCookie = new WeakReference<Index>(index);
        return n >= 0 && n < index.getNodesCount() - 1;
    }

    public String getName() {
        return "Move &Down";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveDownActionCopiedFromNetbeans.class);
    }

    private Index getIndexCookie(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0].getParentNode();
        if (node == null) {
            return null;
        }
        return (Index)node.getCookie(Index.class);
    }

    private final class OrderingListener
    implements ChangeListener {
        private OrderingListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Node[] nodeArray = MoveDownActionCopiedFromNetbeans.this.getActivatedNodes();
            Index index = MoveDownActionCopiedFromNetbeans.this.getIndexCookie(nodeArray);
            if (index == null) {
                MoveDownActionCopiedFromNetbeans.this.setEnabled(false);
            } else {
                int n = index.indexOf(nodeArray[0]);
                MoveDownActionCopiedFromNetbeans.this.setEnabled(n >= 0 && n < index.getNodesCount() - 1);
            }
        }
    }
}

