/*
 * Decompiled with CFR 0.152.
 */
package cern.gp.actions;

import cern.gp.util.GPManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class MainLauncherAction
extends CallableSystemAction {
    public static final String MAIN_CLASS_OPTION = "cern.gp.mainclass";
    public static String mainClassName = System.getProperty("cern.gp.mainclass");

    public void performAction() {
        if (mainClassName == null) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Main Class not set, use the command line option -J-Dcern.gp.mainclass to set it");
            GPManager.notify((NotifyDescriptor)message);
            return;
        }
        try {
            Class<?> clazz = Class.forName(MAIN_CLASS_OPTION);
            Method method = clazz.getDeclaredMethod("main", String[].class);
            method.invoke(null, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"class not found cern.gp.mainclass");
            GPManager.notify((NotifyDescriptor)message);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"class cern.gp.mainclass has no main(String[]) method");
            GPManager.notify((NotifyDescriptor)message);
        }
        catch (IllegalAccessException illegalAccessException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"error invoking main on class cern.gp.mainclass");
            GPManager.notify((NotifyDescriptor)message);
        }
        catch (InvocationTargetException invocationTargetException) {
            GPManager.notify(4096, invocationTargetException);
        }
    }

    public String getName() {
        return mainClassName + ".main()";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

