/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.xpath.Expr;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int n, Expr expr) {
        this.op = n;
        this.operand = expr;
    }

    @Override
    public String toString() {
        return "-" + this.operand;
    }

    @Override
    public boolean evalBoolean(VTDNav vTDNav) {
        return this.operand.evalBoolean(vTDNav);
    }

    @Override
    public double evalNumber(VTDNav vTDNav) {
        return -1.0 * this.operand.evalNumber(vTDNav);
    }

    @Override
    public int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("UnaryExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNav vTDNav) {
        double d = this.operand.evalNumber(vTDNav);
        if (d == (double)((int)d)) {
            return "" + (int)d;
        }
        return "" + d;
    }

    @Override
    public void reset(VTDNav vTDNav) {
        this.operand.reset(vTDNav);
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    @Override
    public void setContextSize(int n) {
        this.operand.setContextSize(n);
    }

    @Override
    public void setPosition(int n) {
        this.operand.setPosition(n);
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

