/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.IIntBuffer;
import java.util.ArrayList;

public class FastIntBuffer
implements IIntBuffer {
    private ArrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    private int size;
    private int exp;
    private int r;

    public FastIntBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new ArrayList();
    }

    public FastIntBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << n;
        this.exp = n;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new ArrayList();
    }

    public final void append(int[] nArray) {
        int n;
        int[] nArray2;
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (this.bufferArrayList.size() == 0) {
            nArray2 = new int[this.pageSize];
            this.bufferArrayList.add(nArray2);
            n = 0;
            this.capacity = this.pageSize;
        } else {
            n = Math.min(this.size >> this.exp, this.bufferArrayList.size() - 1);
            nArray2 = (int[])this.bufferArrayList.get(n);
        }
        if (this.size + nArray.length < this.capacity) {
            if (this.size + nArray.length < n + 1 << this.exp) {
                System.arraycopy(nArray, 0, nArray2, this.size & this.r, nArray.length);
            } else {
                int n2;
                int n3 = this.pageSize - (this.size & this.r);
                System.arraycopy(nArray, 0, nArray2, this.size & this.r, n3);
                int n4 = nArray.length - n3;
                int n5 = n4 >> this.exp;
                for (n2 = 1; n2 <= n5; ++n2) {
                    System.arraycopy(nArray, n3, (int[])this.bufferArrayList.get(n + n2), 0, this.pageSize);
                    n3 += this.pageSize;
                }
                System.arraycopy(nArray, n3, (int[])this.bufferArrayList.get(n + n2), 0, n4 & this.r);
            }
            this.size += nArray.length;
            return;
        }
        int n6 = (nArray.length + this.size >> this.exp) + ((nArray.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(nArray, 0, nArray2, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n6; ++i) {
            int[] nArray3 = new int[this.pageSize];
            if (i < n6 - 1) {
                System.arraycopy(nArray, this.pageSize * i + this.capacity - this.size, nArray3, 0, this.pageSize);
            } else {
                System.arraycopy(nArray, this.pageSize * i + this.capacity - this.size, nArray3, 0, nArray.length + this.size - this.capacity - this.pageSize * i);
            }
            this.bufferArrayList.add(nArray3);
        }
        this.size += nArray.length;
        this.capacity += n6 * this.pageSize;
    }

    public final void append(int n) {
        int[] nArray;
        if (this.bufferArrayList.size() == 0) {
            nArray = new int[this.pageSize];
            this.bufferArrayList.add(nArray);
            this.capacity = this.pageSize;
        } else {
            int n2 = Math.min(this.size >> this.exp, this.bufferArrayList.size() - 1);
            nArray = (int[])this.bufferArrayList.get(n2);
        }
        if (this.size + 1 <= this.capacity) {
            nArray[this.size & this.r] = n;
            ++this.size;
        } else {
            int[] nArray2 = new int[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(nArray2);
            nArray2[0] = n;
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public int[] getIntArray(int n, int n2) {
        if (this.size <= 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n + n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int[] nArray = new int[n2];
        int n3 = n >> this.exp;
        int n4 = n + n2 >> this.exp;
        if ((n + n2 & this.r) == 0) {
            --n4;
        }
        if (n3 == n4) {
            System.arraycopy((int[])this.bufferArrayList.get(n3), n & this.r, nArray, 0, n2);
        } else {
            int n5 = 0;
            for (int i = n3; i <= n4; ++i) {
                int[] nArray2 = (int[])this.bufferArrayList.get(i);
                if (i == n3) {
                    System.arraycopy(nArray2, n & this.r, nArray, 0, this.pageSize - (n & this.r));
                    n5 += this.pageSize - (n & this.r);
                    continue;
                }
                if (i == n4) {
                    System.arraycopy(nArray2, 0, nArray, n5, n2 - n5);
                    continue;
                }
                System.arraycopy(nArray2, 0, nArray, n5, this.pageSize);
                n5 += this.pageSize;
            }
        }
        return nArray;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @Override
    public final int intAt(int n) {
        if (n < 0 || n > this.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n >> this.exp;
        int n3 = n & this.r;
        return ((int[])this.bufferArrayList.get(n2))[n3];
    }

    @Override
    public final void modifyEntry(int n, int n2) {
        if (n < 0 || n > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        ((int[])this.bufferArrayList.get((int)(n >> this.exp)))[n & this.r] = n2;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public int[] toIntArray() {
        if (this.size > 0) {
            int n = this.size;
            int[] nArray = new int[this.size];
            int n2 = 0;
            int n3 = 0;
            while (n > 0) {
                System.arraycopy((int[])this.bufferArrayList.get(n3), 0, nArray, n2, n < this.pageSize ? n : this.pageSize);
                n -= this.pageSize;
                n2 += this.pageSize;
                ++n3;
            }
            return nArray;
        }
        return null;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean resize(int n) {
        if (n <= this.capacity && n >= 0) {
            this.size = n;
            return true;
        }
        return false;
    }
}

