/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.JarClassLoader;

public class ProxyClassLoader
extends ClassLoader {
    private static final Enumeration EMPTY = new ArrayEnumeration(new Object[0]);
    private final Map domainsByPackage = new HashMap();
    private final Map packages = new HashMap();
    private ClassLoader[] parents;
    private boolean dead = false;
    private final boolean transitive;

    public ProxyClassLoader(ClassLoader[] parents) {
        this(parents, true);
    }

    public ProxyClassLoader(ClassLoader[] parents, boolean transitive) {
        if (parents.length == 0) {
            throw new IllegalArgumentException("ProxyClassLoader must have a parent");
        }
        this.transitive = transitive;
        HashSet<ClassLoader> check = new HashSet<ClassLoader>(Arrays.asList(parents));
        if (check.size() < parents.length) {
            throw new IllegalArgumentException("duplicate parents");
        }
        if (check.contains(null)) {
            throw new IllegalArgumentException("null parent in " + check);
        }
        this.parents = this.coalesceParents(parents);
    }

    public synchronized void append(ClassLoader[] nueparents) throws IllegalArgumentException {
        if (nueparents == null) {
            throw new IllegalArgumentException("null parents array");
        }
        int i = 0;
        while (i < nueparents.length) {
            if (nueparents[i] == null) {
                throw new IllegalArgumentException("null parent");
            }
            ++i;
        }
        this.parents = this.coalesceAppend(this.parents, nueparents);
    }

    public void destroy() {
        this.dead = true;
    }

    private void zombieCheck(String hint) {
        if (this.dead) {
            IllegalStateException ise = new IllegalStateException("WARNING - attempting to use a zombie classloader " + this + " on " + hint + ". This means classes from a disabled module are still active. May or may not be a problem.");
            JarClassLoader.notify(0, ise);
            this.dead = false;
        }
    }

    protected final synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.zombieCheck(name);
        String filename = name.replace('.', '/').concat(".class");
        int idx = filename.lastIndexOf(47);
        if (idx == -1) {
            throw new ClassNotFoundException("Will not load classes from default package");
        }
        String pkg = filename.substring(0, idx + 1);
        Class c = this.smartLoadClass(name, filename, pkg);
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class simpleFindClass(String name, String fileName, String pkg) {
        return null;
    }

    public final URL getResource(String name) {
        this.zombieCheck(name);
        int slashIdx = name.lastIndexOf(47);
        if (slashIdx == -1) {
            return null;
        }
        String pkg = name.substring(0, slashIdx + 1);
        if (this.isSpecialResource(pkg)) {
            int i = 0;
            while (i < this.parents.length) {
                URL u;
                if (this.shouldDelegateResource(pkg, this.parents[i]) && (u = this.parents[i] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[i]).findResource(name) : this.parents[i].getResource(name)) != null) {
                    return u;
                }
                ++i;
            }
            return this.findResource(name);
        }
        ClassLoader owner = (ClassLoader)this.domainsByPackage.get(pkg);
        if (owner != null) {
            if (owner instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)owner).findResource(name);
            }
            return owner.getResource(name);
        }
        URL retVal = null;
        int i = 0;
        while (i < this.parents.length) {
            owner = this.parents[i];
            if (this.shouldDelegateResource(pkg, owner) && (retVal = owner instanceof ProxyClassLoader ? ((ProxyClassLoader)owner).findResource(name) : owner.getResource(name)) != null) {
                this.domainsByPackage.put(pkg, owner);
                return retVal;
            }
            ++i;
        }
        retVal = this.findResource(name);
        if (retVal != null) {
            this.domainsByPackage.put(pkg, this);
        }
        return retVal;
    }

    protected URL findResource(String name) {
        return null;
    }

    protected final synchronized Enumeration findResources(String name) throws IOException {
        this.zombieCheck(name);
        int slashIdx = name.lastIndexOf(47);
        if (slashIdx == -1) {
            return EMPTY;
        }
        String pkg = name.substring(0, slashIdx + 1);
        Enumeration[] es = new Enumeration[this.parents.length + 1];
        int i = 0;
        while (i < this.parents.length) {
            es[i] = !this.shouldDelegateResource(pkg, this.parents[i]) ? EMPTY : (this.parents[i] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[i]).simpleFindResources(name) : this.parents[i].getResources(name));
            ++i;
        }
        es[this.parents.length] = this.simpleFindResources(name);
        return new AAEnum(es);
    }

    protected Enumeration simpleFindResources(String name) throws IOException {
        return super.findResources(name);
    }

    protected Package getPackage(String name) {
        this.zombieCheck(name);
        return this.getPackageFast(name, name.replace('.', '/') + '/', true);
    }

    protected Package getPackageFast(String name, String sname, boolean recurse) {
        Map map = this.packages;
        synchronized (map) {
            Package pkg = (Package)this.packages.get(name);
            if (pkg != null) {
                Package package_ = pkg;
                return package_;
            }
            if (!recurse) {
                Package package_ = null;
                return package_;
            }
            int i = 0;
            while (i < this.parents.length) {
                ClassLoader par = this.parents[i];
                if (par instanceof ProxyClassLoader && this.shouldDelegateResource(sname, par) && (pkg = ((ProxyClassLoader)par).getPackageFast(name, sname, false)) != null) break;
                ++i;
            }
            if (pkg == null && this.shouldDelegateResource(sname, this.getParent())) {
                pkg = super.getPackage(name);
            }
            if (pkg != null) {
                this.packages.put(name, pkg);
            }
            Package package_ = pkg;
            return package_;
        }
    }

    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Map map = this.packages;
        synchronized (map) {
            Package pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            this.packages.put(name, pkg);
            Package package_ = pkg;
            return package_;
        }
    }

    protected synchronized Package[] getPackages() {
        this.zombieCheck(null);
        HashMap all = new HashMap();
        this.addPackages(all, super.getPackages());
        int i = 0;
        while (i < this.parents.length) {
            ClassLoader par = this.parents[i];
            if (par instanceof ProxyClassLoader) {
                this.addPackages(all, ((ProxyClassLoader)par).getPackages());
            }
            ++i;
        }
        Map map = this.packages;
        synchronized (map) {
            Iterator it = all.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object name = entry.getKey();
                if (this.packages.containsKey(name)) continue;
                this.packages.put(name, entry.getValue());
            }
        }
        return all.values().toArray(new Package[all.size()]);
    }

    public Package getPackageAccessibly(String name) {
        return this.getPackage(name);
    }

    public Package[] getPackagesAccessibly() {
        return this.getPackages();
    }

    private ClassLoader[] coalesceParents(ClassLoader[] loaders) throws IllegalArgumentException {
        int likelySize = loaders.length * 5 + 10;
        HashSet resultingUnique = new HashSet(likelySize);
        ArrayList resulting = new ArrayList(likelySize);
        int i = 0;
        while (i < loaders.length) {
            this.addRec(resultingUnique, resulting, loaders[i]);
            ++i;
        }
        ClassLoader[] ret = resulting.toArray(new ClassLoader[resulting.size()]);
        return ret;
    }

    private ClassLoader[] coalesceAppend(ClassLoader[] existing, ClassLoader[] appended) throws IllegalArgumentException {
        int likelySize = existing.length + 3;
        HashSet<ClassLoader> resultingUnique = new HashSet<ClassLoader>(likelySize);
        List<ClassLoader> existingL = Arrays.asList(existing);
        resultingUnique.addAll(existingL);
        if (resultingUnique.containsAll(Arrays.asList(appended))) {
            return existing;
        }
        ArrayList<ClassLoader> resulting = new ArrayList<ClassLoader>(likelySize);
        resulting.addAll(existingL);
        int i = 0;
        while (i < appended.length) {
            this.addRec(resultingUnique, resulting, appended[i]);
            ++i;
        }
        ClassLoader[] ret = resulting.toArray(new ClassLoader[resulting.size()]);
        return ret;
    }

    private void addRec(Set resultingUnique, List resulting, ClassLoader loader) throws IllegalArgumentException {
        if (loader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (resultingUnique.contains(loader)) {
            return;
        }
        if (loader instanceof ProxyClassLoader && ((ProxyClassLoader)loader).transitive) {
            ClassLoader[] parents = ((ProxyClassLoader)loader).parents;
            int i = 0;
            while (i < parents.length) {
                this.addRec(resultingUnique, resulting, parents[i]);
                ++i;
            }
        }
        resultingUnique.add(loader);
        resulting.add(loader);
    }

    private final Class smartLoadClass(String name, String fileName, String pkg) throws ClassNotFoundException {
        ClassLoader owner;
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        ClassLoader classLoader = owner = this.isSpecialResource(pkg) ? null : (ClassLoader)this.domainsByPackage.get(pkg);
        if (owner == this) {
            return this.simpleFindClass(name, fileName, pkg);
        }
        if (owner != null) {
            if (owner instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)owner).fullFindClass(name, fileName, pkg);
            }
            return owner.loadClass(name);
        }
        c = this.loadInOrder(name, fileName, pkg);
        if (c != null) {
            ClassLoader owner2 = ProxyClassLoader.getClassClassLoader(c);
            this.domainsByPackage.put(pkg, owner2);
        }
        return c;
    }

    private static ClassLoader getClassClassLoader(final Class c) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    private final Class loadInOrder(String name, String fileName, String pkg) throws ClassNotFoundException {
        ClassNotFoundException cached = null;
        int i = 0;
        while (i < this.parents.length) {
            ClassLoader par = this.parents[i];
            if (this.shouldDelegateResource(pkg, par)) {
                if (par instanceof ProxyClassLoader) {
                    ProxyClassLoader pcl = (ProxyClassLoader)par;
                    Class c = pcl.fullFindClass(name, fileName, pkg);
                    if (c != null && (pcl.transitive || ProxyClassLoader.getClassClassLoader(c) == pcl)) {
                        return c;
                    }
                } else {
                    boolean skip = false;
                    if ((name.startsWith("org.netbeans.") || name.startsWith("org.openide.") || name.endsWith(".Bundle") || name.endsWith("BeanInfo") || name.endsWith("Editor")) && par.getResource(fileName) == null) {
                        skip = true;
                    }
                    if (!skip) {
                        try {
                            return par.loadClass(name);
                        }
                        catch (ClassNotFoundException cnfe) {
                            cached = cnfe;
                        }
                    }
                }
            }
            ++i;
        }
        Class c = this.simpleFindClass(name, fileName, pkg);
        if (c != null) {
            return c;
        }
        if (cached != null) {
            throw cached;
        }
        return null;
    }

    private synchronized Class fullFindClass(String name, String fileName, String pkg) {
        Class c = this.findLoadedClass(name);
        return c == null ? this.simpleFindClass(name, fileName, pkg) : c;
    }

    private void addPackages(Map all, Package[] pkgs) {
        int i = 0;
        while (i < pkgs.length) {
            all.put(pkgs[i].getName(), pkgs[i]);
            ++i;
        }
    }

    protected boolean isSpecialResource(String pkg) {
        return pkg.startsWith("META-INF/");
    }

    protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
        return true;
    }

    private static final class AAEnum
    implements Enumeration {
        private Enumeration[] array;
        private int index = 0;

        public AAEnum(Enumeration[] array) {
            this.array = array;
        }

        public boolean hasMoreElements() {
            while (this.index != this.array.length) {
                if (this.array[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object nextElement() {
            try {
                return this.array[this.index].nextElement();
            }
            catch (NoSuchElementException ex) {
                if (this.hasMoreElements()) {
                    return this.nextElement();
                }
                throw ex;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }

    private static final class ArrayEnumeration
    implements Enumeration {
        private Object[] array;
        private int index = 0;

        public ArrayEnumeration(Object[] array) {
            this.array = array;
        }

        public boolean hasMoreElements() {
            return this.index < this.array.length;
        }

        public Object nextElement() {
            try {
                return this.array[this.index++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

