/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.openarchitectureware.workflow.editors.parser.XMLAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement {
    private List<XMLElement> elementChildren = new ArrayList<XMLElement>();
    private List<XMLAttribute> attributeChildren = new ArrayList<XMLAttribute>();
    private String name;
    private XMLElement parent;
    private Position position;

    public XMLElement(String name) {
        this.name = name;
    }

    public List<XMLElement> getChildrenDTDElements() {
        return this.elementChildren;
    }

    public XMLElement addChildElement(XMLElement element) {
        this.elementChildren.add(element);
        element.setParent(this);
        return this;
    }

    public void setParent(XMLElement element) {
        this.parent = element;
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public XMLElement addChildAttribute(XMLAttribute attribute) {
        this.attributeChildren.add(attribute);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAttributes() {
        return this.attributeChildren.size() > 0;
    }

    public String getAttributeValue(String localName) {
        for (XMLAttribute attribute : this.attributeChildren) {
            if (!attribute.getName().equals(localName)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public void clear() {
        this.elementChildren.clear();
        this.attributeChildren.clear();
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }
}

