/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors.outline;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.openarchitectureware.workflow.editors.parser.XMLElement;
import org.osgi.framework.Bundle;

public class OutlineLabelProvider
implements ILabelProvider {
    private static final String COMPONENT_NAME = "component";
    private static final String PROPERTY_NAME = "property";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String FILE_ATTRIBUTE = "file";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String XML_TAG = "XML_TAG";
    private static final String PROPERTY = "PROPERTY";
    private static final String COMPONENT = "COMPONENT";
    private static final String ASSIGNMENT = "ASSIGNMENT";
    private static ImageRegistry imageRegistry;

    public OutlineLabelProvider() {
        this.initializeImages();
    }

    private void initializeImages() {
        imageRegistry = new ImageRegistry();
        OutlineLabelProvider.declareRegistryImage(XML_TAG, "icons/xmltag.gif");
        OutlineLabelProvider.declareRegistryImage(PROPERTY, "icons/property.gif");
        OutlineLabelProvider.declareRegistryImage(COMPONENT, "icons/component.gif");
        OutlineLabelProvider.declareRegistryImage(ASSIGNMENT, "icons/assignment.gif");
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.openarchitectureware.workflow");
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }

    public Image getImage(Object element) {
        if (element instanceof XMLElement) {
            XMLElement node = (XMLElement)element;
            String name = node.getName();
            if (PROPERTY_NAME.equalsIgnoreCase(name)) {
                return imageRegistry.get(PROPERTY);
            }
            if (COMPONENT_NAME.equalsIgnoreCase(name)) {
                return imageRegistry.get(COMPONENT);
            }
        }
        return imageRegistry.get(XML_TAG);
    }

    public String getText(Object element) {
        if (element instanceof XMLElement) {
            XMLElement node = (XMLElement)element;
            String text = "";
            String nodeName = node.getName();
            if (PROPERTY_NAME.equalsIgnoreCase(nodeName)) {
                String nameAttribute = node.getAttributeValue(NAME_ATTRIBUTE);
                if (nameAttribute != null) {
                    String valueAttribute = node.getAttributeValue(VALUE_ATTRIBUTE);
                    text = valueAttribute != null ? String.valueOf(nameAttribute) + "=" + valueAttribute : nameAttribute;
                    return text;
                }
                String filenameAttribute = node.getAttributeValue(FILE_ATTRIBUTE);
                if (filenameAttribute != null) {
                    text = "file=" + filenameAttribute;
                    return text;
                }
            } else if (node.hasAttributes()) {
                if (this.hasClassName(node)) {
                    return this.getClassNameOfNode(node);
                }
                String valueAttribute = node.getAttributeValue(VALUE_ATTRIBUTE);
                if (valueAttribute != null) {
                    text = String.valueOf(nodeName) + ": " + valueAttribute;
                    return text;
                }
                String pathAttribute = node.getAttributeValue(PATH_ATTRIBUTE);
                if (pathAttribute != null) {
                    text = String.valueOf(nodeName) + ": " + pathAttribute;
                    return text;
                }
                if (this.hasFileName(node)) {
                    return this.getFileNameOfNode(node);
                }
            }
        }
        return null;
    }

    private boolean hasClassName(XMLElement node) {
        String namedItem = node.getAttributeValue(CLASS_ATTRIBUTE);
        return namedItem != null && !namedItem.equals("");
    }

    private String getClassNameOfNode(XMLElement node) {
        String classAttribute = node.getAttributeValue(CLASS_ATTRIBUTE);
        int lastDot = classAttribute.lastIndexOf(46);
        String className = classAttribute.substring(lastDot + 1);
        return className;
    }

    private boolean hasFileName(XMLElement node) {
        String namedItem = node.getAttributeValue(FILE_ATTRIBUTE);
        return namedItem != null && !namedItem.equals("");
    }

    private String getFileNameOfNode(XMLElement node) {
        String classAttribute = node.getAttributeValue(FILE_ATTRIBUTE);
        int lastSlash = classAttribute.lastIndexOf(47);
        String className = classAttribute.substring(lastSlash + 1);
        return className;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

