/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors.outline;

import java.util.List;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.openarchitectureware.workflow.editors.outline.OutlineContentHandler;
import org.openarchitectureware.workflow.editors.parser.XMLElement;
import org.openarchitectureware.workflow.editors.parser.XMLParser;
import org.xml.sax.helpers.LocatorImpl;

public class OutlineContentProvider
implements ITreeContentProvider {
    private XMLElement root = null;
    private IEditorInput input;
    private IDocumentProvider documentProvider;
    protected static final String TAG_POSITIONS = "__tag_positions";
    protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("__tag_positions");

    public OutlineContentProvider(IDocumentProvider provider) {
        this.documentProvider = provider;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.input) {
            if (this.root == null) {
                return new Object[0];
            }
            List<XMLElement> childrenDTDElements = this.root.getChildrenDTDElements();
            if (childrenDTDElements != null) {
                return childrenDTDElements.toArray();
            }
        } else {
            XMLElement parent = (XMLElement)parentElement;
            List<XMLElement> childrenDTDElements = parent.getChildrenDTDElements();
            if (childrenDTDElements != null) {
                return childrenDTDElements.toArray();
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof XMLElement) {
            return ((XMLElement)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == this.input) {
            return true;
        }
        return ((XMLElement)element).getChildrenDTDElements().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (this.root == null) {
            return new Object[0];
        }
        List<XMLElement> childrenDTDElements = this.root.getChildrenDTDElements();
        if (childrenDTDElements != null) {
            return childrenDTDElements.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IDocument document;
        if (oldInput != null && (document = this.documentProvider.getDocument(oldInput)) != null) {
            try {
                document.removePositionCategory(TAG_POSITIONS);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.positionUpdater);
        }
        this.input = (IEditorInput)newInput;
        if (newInput != null && (document = this.documentProvider.getDocument(newInput)) != null) {
            document.addPositionCategory(TAG_POSITIONS);
            document.addPositionUpdater(this.positionUpdater);
            XMLElement rootElement = this.parseRootElement(document);
            if (rootElement != null) {
                this.root = rootElement;
            }
        }
    }

    private XMLElement parseRootElement(IDocument document) {
        String text = document.get();
        XMLElement tagPositions = this.parseRootElements(text, document);
        return tagPositions;
    }

    private XMLElement parseRootElements(String text, IDocument document) {
        try {
            XMLParser xmlParser = new XMLParser();
            OutlineContentHandler contentHandler = new OutlineContentHandler();
            contentHandler.setDocument(document);
            contentHandler.setPositionCategory(TAG_POSITIONS);
            contentHandler.setDocumentLocator(new LocatorImpl());
            xmlParser.setContentHandler(contentHandler);
            xmlParser.doParse(text);
            XMLElement root = contentHandler.getRootElement();
            return root;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

