/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.editors.outline;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.openarchitectureware.workflow.editors.outline.OutlineContentProvider;
import org.openarchitectureware.workflow.editors.outline.OutlineLabelProvider;
import org.openarchitectureware.workflow.editors.parser.XMLElement;

public class EditorContentOutlinePage
extends ContentOutlinePage {
    private ITextEditor editor;
    private IEditorInput input;
    private OutlineContentProvider outlineContentProvider;
    private OutlineLabelProvider outlineLabelProvider;

    public EditorContentOutlinePage(ITextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.outlineContentProvider = new OutlineContentProvider(this.editor.getDocumentProvider());
        viewer.setContentProvider((IContentProvider)this.outlineContentProvider);
        this.outlineLabelProvider = new OutlineLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.outlineLabelProvider);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.input != null) {
            viewer.setInput((Object)this.input);
        }
    }

    public void setInput(Object input) {
        this.input = (IEditorInput)input;
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            XMLElement element = (XMLElement)((IStructuredSelection)selection).getFirstElement();
            int start = element.getPosition().getOffset();
            int length = element.getPosition().getLength();
            try {
                this.editor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.editor.resetHighlightRange();
            }
        }
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput((Object)this.input);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }
}

