/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;
import org.openarchitectureware.debug.communication.packets.RegisterPacket;
import org.openarchitectureware.debug.processing.DebugModelManager;
import org.openarchitectureware.debug.processing.IPluginAdapter;
import org.openarchitectureware.debug.processing.IPluginHandler;
import org.openarchitectureware.debug.processing.handlers.BreakpointPluginHandler;
import org.openarchitectureware.debug.processing.handlers.CommandPluginHandler;
import org.openarchitectureware.debug.processing.handlers.CommandRuntimeHandler;
import org.openarchitectureware.debug.processing.handlers.EventPluginHandler;
import org.openarchitectureware.debug.processing.handlers.EventRuntimeHandler;
import org.openarchitectureware.debug.processing.handlers.VariablesPluginHandler;
import org.openarchitectureware.workflow.Activator;

public class PluginExtensionManager {
    private static PluginExtensionManager singleton;
    private Set<IPluginAdapter> pluginAdapters = new HashSet<IPluginAdapter>();
    private boolean missingAdapterReported;
    private Connection connection;
    private DebugModelManager dmm;

    public static PluginExtensionManager getDefault() {
        if (singleton == null) {
            singleton = new PluginExtensionManager();
        }
        return singleton;
    }

    private PluginExtensionManager() {
        this.collectPluginAdaptersFromExtensions();
    }

    public void init(DebugModelManager dmm, Connection connection) throws DebugException {
        this.dmm = dmm;
        this.connection = connection;
        try {
            this.collectInitialCommunicationHandlers();
            this.collectHandlersFromExtensions();
            this.collectRuntimeAdaptersFromExtensions();
        }
        catch (IOException e) {
            dmm.handleIOProblem(e);
        }
    }

    public IPluginAdapter getAdapterByResourceExtension(String ext) {
        for (IPluginAdapter adapter : this.pluginAdapters) {
            if (!adapter.canHandleResourceExtension(ext)) continue;
            return adapter;
        }
        if (!this.missingAdapterReported) {
            String msg = "Warning: Debug system initialization problem.\nDidn't find a plugin adapter for the file extension: '" + ext + "'";
            Activator.logError(msg, null);
            Activator.showError(msg);
            this.missingAdapterReported = true;
        }
        return null;
    }

    public IPluginAdapter getAdapterByType(String type) {
        for (IPluginAdapter adapter : this.pluginAdapters) {
            if (!adapter.canHandleType(type)) continue;
            return adapter;
        }
        if (!this.missingAdapterReported) {
            String msg = "Warning: Debug system initialization problem.\nDidn't find a plugin adapter for type: '" + type + "'";
            Activator.logError(msg, null);
            Activator.showError(msg);
            this.missingAdapterReported = true;
        }
        return null;
    }

    private void collectInitialCommunicationHandlers() throws IOException {
        RegisterPacket packet = new RegisterPacket();
        packet.type = 1;
        CommandPluginHandler cHandler = new CommandPluginHandler();
        cHandler.setConnection(this.connection);
        this.dmm.setCmdHandler(cHandler);
        packet.classNames.add(CommandRuntimeHandler.class.getName());
        EventPluginHandler eHandler = new EventPluginHandler();
        eHandler.setConnection(this.connection);
        eHandler.startListener();
        eHandler.setDmm(this.dmm);
        packet.classNames.add(EventRuntimeHandler.class.getName());
        this.connection.sendPacket((AbstractPacket)packet);
    }

    private void collectHandlersFromExtensions() throws IOException {
        IConfigurationElement[] elems;
        RegisterPacket packet = new RegisterPacket();
        packet.type = 1;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = reg.getConfigurationElementsFor("org.openarchitectureware.workflow.debugHandlers");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals("handler")) {
                String className = elem.getAttribute("runtimeClass");
                if (className != null) {
                    packet.classNames.add(className);
                }
                IPluginHandler handler = null;
                className = elem.getAttribute("pluginClass");
                if (className != null) {
                    try {
                        handler = (IPluginHandler)elem.createExecutableExtension("pluginClass");
                    }
                    catch (CoreException e) {
                        Activator.logError("Internal configuration error.\nCouldn't instantiate " + elem.getAttribute("pluginClass"), (Exception)((Object)e));
                    }
                }
                if (handler != null) {
                    handler.setConnection(this.connection);
                    if ("variablesHandler".equals(elem.getAttribute("type"))) {
                        this.dmm.setVariablesHandler((VariablesPluginHandler)handler);
                    } else if ("breakpointHandler".equals(elem.getAttribute("type"))) {
                        this.dmm.setBreakpointHandler((BreakpointPluginHandler)handler);
                    } else {
                        handler.setDebugModelManager(this.dmm);
                    }
                }
            }
            ++n2;
        }
        if (!this.dmm.hasRequiredHandlers()) {
            String msg = "Debug system initialization problem.\nSome required debugger handlers are not assigned.";
            Activator.showError(msg);
            Activator.logError(msg, null);
        }
        this.connection.sendPacket((AbstractPacket)packet);
    }

    private void collectRuntimeAdaptersFromExtensions() throws IOException {
        IConfigurationElement[] elems;
        RegisterPacket packet = new RegisterPacket();
        packet.type = 2;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = reg.getConfigurationElementsFor("org.openarchitectureware.workflow.debugAdapters");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals("adapter") && (className = elem.getAttribute("runtimeClass")) != null) {
                packet.classNames.add(className);
            }
            ++n2;
        }
        this.connection.sendPacket((AbstractPacket)packet);
    }

    private void collectPluginAdaptersFromExtensions() {
        IConfigurationElement[] elems;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = reg.getConfigurationElementsFor("org.openarchitectureware.workflow.debugAdapters");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (elem.getName().equals("adapter")) {
                IPluginAdapter adapter = null;
                String className = elem.getAttribute("pluginClass");
                if (className != null) {
                    try {
                        adapter = (IPluginAdapter)elem.createExecutableExtension("pluginClass");
                    }
                    catch (CoreException e) {
                        Activator.logError("Internal configuration error.\nCouldn't instantiate " + elem.getAttribute("pluginClass"), (Exception)((Object)e));
                    }
                }
                if (adapter != null) {
                    this.pluginAdapters.add(adapter);
                }
            }
            ++n2;
        }
    }
}

