/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.breakpoint.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.editors.text.TextEditor;
import org.openarchitectureware.debug.breakpoint.actions.BreakpointActionGroup;
import org.openarchitectureware.debug.processing.IPluginAdapter;
import org.openarchitectureware.debug.processing.PluginExtensionManager;

public class ToggleBreakpointAction
extends Action {
    private TextEditor editor;
    private final BreakpointActionGroup group;

    public ToggleBreakpointAction(TextEditor editor, BreakpointActionGroup group) {
        this.editor = editor;
        this.group = group;
        this.setText("Toggle Breakpoint");
        this.setToolTipText("set or delete breakpoint");
    }

    public void updateText() {
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        IPluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(resource.getFileExtension());
        if (adapter == null) {
            return;
        }
        int line = this.group.getLastSelectedLine() + 1;
        int start = this.group.getLastSelectedOffset();
        int end = this.calculateEnd(line, start);
        if (this.group.isRulerSelected()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(adapter.isToggleBpEnabled(resource, start, end, line));
        }
    }

    public void run() {
        try {
            this.toggleBreakpoint();
        }
        catch (CoreException coreException) {}
    }

    protected void toggleBreakpoint() throws CoreException {
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        int line = this.group.getLastSelectedLine() + 1;
        int start = this.group.getLastSelectedOffset();
        IPluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(resource.getFileExtension());
        if (adapter == null) {
            return;
        }
        int end = this.calculateEnd(line, start);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.openarchitectureware.debug.model");
        Object bp = adapter.checkBreakpoints(breakpoints, resource, start, end, line);
        if (bp != null) {
            bp.delete();
            return;
        }
        bp = adapter.createBreakpoint(resource, start, end, line);
        if (bp == null) {
            return;
        }
        breakpointManager.addBreakpoint(bp);
    }

    private int calculateEnd(int line, int start) {
        int end;
        try {
            end = this.group.isRulerSelected() ? this.group.getOffsetAtLine(line) : start;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            end = start;
        }
        return end;
    }
}

