/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.user;

import cern.gp.beans.BeanSupport;
import cern.gp.explorer.TreeExplorer;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.ChildrenMapManager;
import cern.gp.nodes.children.NodeCollection;
import cern.gp.nodes.children.NodeList;
import cern.gp.nodes.children.NodeMap;
import cern.laser.client.LaserException;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.user.UserBean;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class UserExplorer
extends TreeExplorer {
    private static final Logger logger = LogFactory.getLogger(UserExplorer.class.getName());
    private Collection userList = null;
    private String loggedUserName = null;
    private UserNodeManager userNodeManager = null;

    public UserExplorer(Collection collection, String string) {
        this.userList = collection;
        this.loggedUserName = string;
        this.initializeExplorer();
    }

    private void initializeExplorer() {
        this.userList = this.removeGuestUser(this.userList);
        this.userNodeManager = new UserNodeManager(this.userList, this.loggedUserName);
        GPNode gPNode = null;
        try {
            gPNode = NodeFactory.createNode((Object)new Object(), (ChildrenManager)this.userNodeManager);
            this.setRootNode(gPNode);
            this.getTreeAccess().getTreeView().setRootVisible(false);
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
        this.expandUserNode(gPNode.getPeerNode(), this.loggedUserName);
    }

    private Collection removeGuestUser(Collection collection) {
        logger.debug((Object)("Users before remove Guest:" + collection));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            try {
                if (((User)iterator.next()).getName().compareToIgnoreCase("GUEST") != 0) continue;
                iterator.remove();
                logger.debug((Object)"GUEST user removed");
            }
            catch (LaserConsoleException laserConsoleException) {
                logger.debug((Object)laserConsoleException.getMessage());
            }
        }
        return collection;
    }

    private void expandUserNode(Node node, String string) {
        Children children = node.getChildren();
        Node node2 = children.findChild(string);
        if (node2 != null) {
            this.getTreeAccess().getTreeView().expandNode(node2);
        }
    }

    public void addConfiguration(BeanSupport beanSupport) throws IntrospectionException {
        this.userNodeManager.addConfiguration(beanSupport);
    }

    public void removeConfiguration(GPNode gPNode) {
        ConfigurationNodeManger configurationNodeManger = (ConfigurationNodeManger)gPNode.getParent().getNodeCollection().getChildrenManager();
        configurationNodeManger.removeConfiguration(gPNode);
    }

    public List getDefinedConfigurationNames(User user) throws LaserConsoleException {
        return this.userNodeManager.getConfigurationNames(user.getName());
    }

    private class ConfigurationNodeManger
    implements ChildrenListManager {
        private final Logger logger = LogFactory.getLogger(ConfigurationNodeManger.class.getName());
        private Collection confList = null;
        private NodeList nodeList = null;

        public ConfigurationNodeManger(Collection collection) {
            this.confList = collection;
        }

        public void initChildrenList(NodeList nodeList) {
            this.nodeList = nodeList;
            this.logger.debug((Object)("  " + this.getClass().getName() + " initChildrenList()"));
            try {
                for (Configuration configuration : this.confList) {
                    ConfigurationBean configurationBean = new ConfigurationBean(configuration);
                    this.logger.debug((Object)configurationBean.getName());
                    GPNode gPNode = NodeFactory.createNode((Object)((Object)configurationBean));
                    if (configuration.getName().equals("NOT SAVED DEFAULT CONFIGURATION") || configuration.getName().equals("NOT SAVED RECENTLY LOADED CONFIGURATION")) continue;
                    nodeList.addNode(gPNode);
                }
            }
            catch (IntrospectionException introspectionException) {
                this.logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
            }
            catch (LaserException laserException) {
                this.logger.error((Object)laserException.getMessage(), (Throwable)laserException);
            }
            this.logger.debug((Object)("  " + this.getClass().getName() + " after initChildrenList()"));
        }

        public Comparator getComparator() {
            return null;
        }

        public void addConfiguration(BeanSupport beanSupport) throws IntrospectionException {
            for (GPNode gPNode : this.nodeList) {
                if (!gPNode.getName().equals(beanSupport.getName())) continue;
                Node node = gPNode.getPeerNode();
                this.nodeList.removeNode(gPNode);
                try {
                    node.destroy();
                }
                catch (IOException iOException) {
                    this.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                }
                break;
            }
            this.nodeList.addNode(NodeFactory.createNode((Object)beanSupport));
        }

        public void removeConfiguration(GPNode gPNode) {
            Node node = gPNode.getPeerNode();
            this.nodeList.removeNode(gPNode);
            try {
                node.destroy();
            }
            catch (IOException iOException) {
                this.logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private class UserNodeManager
    implements ChildrenMapManager {
        private final Logger logger = LogFactory.getLogger(UserNodeManager.class.getName());
        private NodeMap confMap;
        private Collection userList = null;
        private String loggedUserName = null;
        private GPNode loggedUserNode = null;

        public UserNodeManager(Collection collection, String string) {
            this.userList = collection;
            this.loggedUserName = string;
        }

        public void initChildrenMap(NodeMap nodeMap) {
            this.confMap = nodeMap;
            try {
                for (User user : this.userList) {
                    UserBean userBean = new UserBean(user);
                    User user2 = AppRegister.getInstance().getRegisteredUser();
                    if (user.getName().equals(user2.getName())) {
                        userBean.setIsLogged(true);
                    }
                    GPNode gPNode = NodeFactory.createNode((Object)((Object)userBean), (ChildrenManager)new ConfigurationNodeManger(userBean.getConfigurations()));
                    nodeMap.addNode((Object)gPNode.getName(), gPNode);
                }
            }
            catch (IntrospectionException introspectionException) {
                this.logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
            }
            catch (LaserException laserException) {
                this.logger.error((Object)laserException, laserException.fillInStackTrace());
                AcWindowManager.notifyError("Internal error.\n Check log file");
            }
        }

        public Comparator getComparator() {
            return null;
        }

        public void addConfiguration(BeanSupport beanSupport) throws IntrospectionException {
            GPNode gPNode = this.confMap.getNode((Object)this.loggedUserName);
            NodeCollection nodeCollection = gPNode.getNodeCollection();
            ConfigurationNodeManger configurationNodeManger = (ConfigurationNodeManger)nodeCollection.getChildrenManager();
            if (((ConfigurationBean)beanSupport).getIsDefault()) {
                ConfigurationBean configurationBean = this.findDefaultConfiguration();
                if (configurationBean != null) {
                    configurationBean.setIsDefault(false);
                }
                configurationNodeManger.addConfiguration(beanSupport);
            } else {
                configurationNodeManger.addConfiguration(beanSupport);
            }
        }

        private ConfigurationBean findDefaultConfiguration() {
            GPNode gPNode = this.confMap.getNode((Object)this.loggedUserName);
            NodeCollection nodeCollection = gPNode.getNodeCollection();
            ConfigurationBean configurationBean = null;
            Iterator iterator = ((NodeList)nodeCollection).iterator();
            while (iterator.hasNext()) {
                ConfigurationBean configurationBean2 = (ConfigurationBean)((Object)((GPNode)iterator.next()).getBean());
                if (!configurationBean2.getIsDefault()) continue;
                configurationBean = configurationBean2;
                break;
            }
            return configurationBean;
        }

        public List getConfigurationNames(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            GPNode gPNode = this.confMap.getNode((Object)string);
            NodeCollection nodeCollection = gPNode.getNodeCollection();
            Iterator iterator = ((NodeList)nodeCollection).iterator();
            while (iterator.hasNext()) {
                ConfigurationBean configurationBean = (ConfigurationBean)((Object)((GPNode)iterator.next()).getBean());
                arrayList.add(configurationBean.getName());
            }
            return arrayList;
        }
    }
}

