/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.search;

import cern.gp.nodes.GPNode;
import cern.laser.client.data.Category;
import cern.laser.guiplatform.category.CategoryBean;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.category.ChooseCategoryPanel;
import cern.laser.guiplatform.windows.search.SearchWindow;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CategorySelectorWindow
extends TopComponent {
    private Logger logger = LogFactory.getLogger(CategorySelectorWindow.class.getName());
    private Category[] choosenCategories;
    private int windowMode;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel categoryPanel;
    private JButton searchButton;
    private static final long serialVersionUID = 1L;

    public CategorySelectorWindow() {
        this(null, 3);
    }

    public CategorySelectorWindow(Category[] categoryArray, int n) {
        this.choosenCategories = categoryArray;
        this.windowMode = n;
        this.initComponents();
        this.setCloseOperation(1);
        switch (n) {
            case 1: {
                this.setName(NbBundle.getMessage(SearchWindow.class, (String)"LBL_search_component_name_archive") + " - Categories Selection");
                break;
            }
            case 2: {
                this.setName(NbBundle.getMessage(SearchWindow.class, (String)"LBL_search_component_name_alarminfo") + " - Categories Selection");
                break;
            }
            case 3: {
                this.setName(NbBundle.getMessage(SearchWindow.class, (String)"LBL_search_component_name_search") + " - Categories Selection");
                break;
            }
            default: {
                this.setName("No label found, check Bundle file!");
            }
        }
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.searchButton = new JButton();
        this.cancelButton = new JButton();
        this.categoryPanel = new ChooseCategoryPanel(this.choosenCategories);
        this.setLayout(new BorderLayout());
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CategorySelectorWindow.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.searchButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CategorySelectorWindow.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.add(this.buttonsPanel, "South");
        this.add(this.categoryPanel, "Center");
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.storeCategorySelection();
        this.close();
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.storeCategorySelection();
        SearchWindow searchWindow = new SearchWindow(this.windowMode, this.getChoosenCategoriesArray());
        searchWindow.open();
        this.close();
    }

    private void storeCategorySelection() {
        Category[] categoryArray = ((ChooseCategoryPanel)this.categoryPanel).getChoosenCategoriesArray();
        AppRegister.getInstance().setSearchCategories(categoryArray);
    }

    public Category[] getChoosenCategoriesArray() {
        return ((ChooseCategoryPanel)this.categoryPanel).getChoosenCategoriesArray();
    }

    public void updateCategoryTreeExplorer() throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel)this.categoryPanel).updateCategoryTreeExplorer();
    }

    public void addCategory(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel)this.categoryPanel).addCategory(gPNode);
    }

    public void addCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel)this.categoryPanel).addCategoryWithoutChildren(gPNode);
    }

    public void addSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel)this.categoryPanel).addSubCategories(gPNode);
    }

    public void removeCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel)this.categoryPanel).removeCategoryWithoutChildren(gPNode);
    }

    public void removeSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel)this.categoryPanel).removeSubCategories(gPNode);
    }

    public void removeCategory(GPNode gPNode) {
        ((ChooseCategoryPanel)this.categoryPanel).removeCategory(gPNode);
    }

    public void removeAllCategories() {
        ((ChooseCategoryPanel)this.categoryPanel).removeAllCategories();
    }

    public void loadAllCategoriesInTreeExplorer() {
        ((ChooseCategoryPanel)this.categoryPanel).loadAllCategoriesInTreeExplorer();
    }

    public Category[] getChoosenCategories() {
        Collection collection = ((ChooseCategoryPanel)this.categoryPanel).getChoosenCategories();
        Category[] categoryArray = new Category[collection.size()];
        int n = 0;
        for (CategoryBean categoryBean : collection) {
            categoryArray[n] = categoryBean.getCategory();
            ++n;
        }
        return categoryArray;
    }
}

