/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.filter;

import cern.gp.nodes.GPNode;
import cern.laser.client.services.selection.Filter;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.guiplatform.filters.FilterItemBean;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.filter.CreatedFiltersExplorer;
import cern.laser.guiplatform.windows.filter.SingleFilterItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.IntrospectionException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.options.SystemOption;

public class CreateFiltersPanel
extends JPanel {
    static final Logger logger = LogFactory.getLogger(CreateFiltersPanel.class.getName());
    private SingleFilterItem createFilterItem = null;
    private CreatedFiltersExplorer createdFiltersExpl = null;
    private JButton deleteAllButton;
    private JPanel tableListSouthPanel;
    private JPanel buttonPanel;
    private JPanel staticInfoPanel;
    private JPanel headerPanel;
    private JPanel filtrListPanel;
    private JButton addButton1;
    private JButton updateButton;
    private JPanel centralPanel;
    private JPanel southPanel;
    private JButton deleteButton;
    private JPanel tableListPanel;
    private Configuration configuration = null;

    public CreateFiltersPanel(Configuration configuration) throws LaserConsoleException {
        this.configuration = configuration;
        this.initComponents();
    }

    private void initComponents() throws LaserConsoleException {
        this.headerPanel = new JPanel();
        this.centralPanel = new JPanel();
        this.staticInfoPanel = new JPanel();
        this.filtrListPanel = new JPanel();
        this.tableListPanel = new JPanel();
        this.tableListSouthPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.addButton1 = new JButton();
        this.southPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 400));
        this.add((Component)this.headerPanel, "North");
        this.centralPanel.setLayout(new GridLayout(0, 1));
        this.centralPanel.setPreferredSize(new Dimension(450, 194));
        this.staticInfoPanel.setLayout(new BorderLayout());
        this.staticInfoPanel.setBorder(new TitledBorder("Filters"));
        this.filtrListPanel.setLayout(new BorderLayout());
        this.filtrListPanel.setBorder(new EtchedBorder());
        List<Filter> list = Arrays.asList(this.configuration.getSelection().getFilterSelection().list());
        this.createdFiltersExpl = new CreatedFiltersExplorer(list);
        this.tableListPanel.add((Component)((Object)this.createdFiltersExpl));
        this.filtrListPanel.add((Component)this.tableListPanel, "Center");
        this.tableListSouthPanel.setLayout(new BorderLayout());
        this.tableListSouthPanel.add((Component)this.buttonPanel, "East");
        this.filtrListPanel.add((Component)this.tableListSouthPanel, "South");
        this.staticInfoPanel.add((Component)this.filtrListPanel, "Center");
        this.createFilterItem = new SingleFilterItem();
        this.createFilterItem.setFitlerExplorer(this.createdFiltersExpl);
        this.staticInfoPanel.add((Component)this.createFilterItem, "North");
        this.centralPanel.add(this.staticInfoPanel);
        this.add((Component)this.centralPanel, "Center");
        this.southPanel.setLayout(new BorderLayout());
        this.add((Component)this.southPanel, "South");
    }

    public List getDefinedFilters() {
        return this.createdFiltersExpl.getDefinedFilters();
    }

    public void reset() {
        this.createdFiltersExpl.removeAllFilters();
    }

    public void removeFilter(GPNode gPNode) {
        this.createdFiltersExpl.removeFilter(gPNode);
        FilterItemBean filterItemBean = (FilterItemBean)((Object)gPNode.getBean());
        this.createFilterItem.setMode(filterItemBean.getName(), filterItemBean.getOperator(), filterItemBean.getValue());
    }

    public void removeAllFilters() {
        this.createdFiltersExpl.removeAllFilters();
        this.createFilterItem.resetPanel();
    }

    public void setInUpdateMode(String string, String string2, String string3, String string4) {
        this.createFilterItem.setInUpdateMode(string, string2, string3, string4);
    }

    public void updateFilterSelection(Configuration configuration) throws LaserConsoleException {
        this.configuration = configuration;
        this.createdFiltersExpl.removeAllFilters();
        List<Filter> list = Arrays.asList(configuration.getSelection().getFilterSelection().list());
        for (Filter filter : list) {
            try {
                this.createdFiltersExpl.addFilter(filter);
            }
            catch (IntrospectionException introspectionException) {
                logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
            }
        }
    }

    static {
        PropertySheetSettings propertySheetSettings = (PropertySheetSettings)SystemOption.findObject(PropertySheetSettings.class, (boolean)true);
        propertySheetSettings.setDisabledPropertyColor(Color.black);
        propertySheetSettings.setValueColor(Color.blue);
    }
}

