/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.configuration;

import cern.gp.nodes.GPNode;
import cern.laser.client.LaserException;
import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.actions.configuration.ConfigurationDeleteAction;
import cern.laser.guiplatform.actions.configuration.ConfigurationLoadAction;
import cern.laser.guiplatform.actions.configuration.ConfigurationSetAsDefaultAction;
import cern.laser.guiplatform.configuration.ConfigurationBean;
import cern.laser.guiplatform.user.UserHandlerFactory;
import cern.laser.guiplatform.util.ImageUtility;
import cern.laser.guiplatform.util.actions.ActionUtils;
import cern.laser.guiplatform.windows.configuration.ConsoleConfigurationWindow;
import cern.laser.guiplatform.windows.user.UserExplorer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class LoadConfigurationPanel
extends JPanel {
    private UserExplorer userListExpl = null;
    private ConsoleConfigurationWindow parentWindow = null;
    private User loggedUser = null;

    public LoadConfigurationPanel(ConsoleConfigurationWindow consoleConfigurationWindow, User user) throws LaserException {
        this.parentWindow = consoleConfigurationWindow;
        this.loggedUser = user;
        this.initComponents();
    }

    private void initComponents() throws LaserException {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel("Configurations", ImageUtility.getPanelIcon(this, "/cern/laser/guiplatform/images/users24_24.png"), 2);
        this.add((Component)jLabel, "North");
        this.initUsersExplorer(this.loggedUser.getName());
        JButton jButton = new JButton(ActionUtils.createActionForComp((TopComponent)this.userListExpl, (Action)SystemAction.get(ConfigurationLoadAction.class)));
        JButton jButton2 = new JButton(ActionUtils.createActionForComp((TopComponent)this.userListExpl, (Action)SystemAction.get(ConfigurationDeleteAction.class)));
        JButton jButton3 = new JButton(ActionUtils.createActionForComp((TopComponent)this.userListExpl, (Action)SystemAction.get(ConfigurationSetAsDefaultAction.class)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        this.userListExpl.add(jPanel, "South");
        this.userListExpl.setPreferredSize(ConsoleConfigurationWindow.defaultLoadConfigurationPanelDimension);
        this.add((Component)((Object)this.userListExpl), "Center");
    }

    private void initUsersExplorer(String string) throws LaserException {
        Collection collection = UserHandlerFactory.getHandler().getUsers();
        this.userListExpl = new UserExplorer(collection, string);
    }

    public void addNewConfiguration(ConfigurationBean configurationBean) throws IntrospectionException {
        this.userListExpl.addConfiguration(configurationBean);
    }

    public void removeConfiguration(GPNode gPNode) {
        this.userListExpl.removeConfiguration(gPNode);
    }

    public List getDefinedConfigurationNames(User user) throws LaserConsoleException {
        return this.userListExpl.getDefinedConfigurationNames(user);
    }
}

