/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.category;

import cern.gp.nodes.GPNode;
import cern.gp.nodes.children.NodeCollection;
import cern.gp.nodes.children.NodeList;
import cern.laser.client.LaserException;
import cern.laser.client.data.Category;
import cern.laser.client.services.browsing.CategoryBrowsingHandler;
import cern.laser.console.Configuration;
import cern.laser.console.LaserConsoleException;
import cern.laser.guiplatform.actions.category.AddCategoryAction;
import cern.laser.guiplatform.actions.category.AddSubCategoriesAction;
import cern.laser.guiplatform.actions.category.RemoveCategoryAction;
import cern.laser.guiplatform.actions.category.RemoveSubCategoriesAction;
import cern.laser.guiplatform.category.CategoryBean;
import cern.laser.guiplatform.category.CategoryBrowsingHandlerFactory;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.actions.ActionUtils;
import cern.laser.guiplatform.windows.category.CategoryTreeExplorer;
import cern.laser.guiplatform.windows.category.ChoosenCategoryExplorer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.IntrospectionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class ChooseCategoryPanel
extends JPanel {
    private static Logger logger = LogFactory.getLogger(ChooseCategoryPanel.class.getName());
    private JPanel buttonsPanel = null;
    private static final String configureTreeName = "Available categories";
    private static final String choosenConfigurationName = "Choosen categories";
    private CategoryTreeExplorer categoryTreeExpl = null;
    private ChoosenCategoryExplorer choosenCategoryExpl = null;
    private Configuration configuration = null;
    private Category[] choosenCategories = null;

    public ChooseCategoryPanel(Configuration configuration) {
        this.configuration = configuration;
        this.initComponents();
    }

    public ChooseCategoryPanel(Category[] categoryArray) {
        this.choosenCategories = categoryArray;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridLayout(0, 3));
        try {
            Category[] categoryArray = this.configuration != null ? this.configuration.getSelection().getCategorySelection().list() : this.choosenCategories;
            this.choosenCategoryExpl = this.createChoosenCategoryList(Arrays.asList(categoryArray));
            this.choosenCategoryExpl.add(new JLabel(choosenConfigurationName), "North");
            this.categoryTreeExpl = this.createCategoryTree();
            this.categoryTreeExpl.add(new JLabel(configureTreeName), "North");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setPreferredSize(new Dimension(200, 400));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.buttonsPanel.setLayout(gridBagLayout);
            JButton jButton = new JButton(ActionUtils.createActionForComp((TopComponent)this.categoryTreeExpl, (Action)SystemAction.get(AddCategoryAction.class)));
            jButton.setPreferredSize(new Dimension(200, 30));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.buttonsPanel.add(jButton);
            JButton jButton2 = new JButton(ActionUtils.createActionForComp((TopComponent)this.categoryTreeExpl, (Action)SystemAction.get(AddSubCategoriesAction.class)));
            jButton2.setPreferredSize(new Dimension(200, 30));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(2, 0, 0, 0);
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            this.buttonsPanel.add(jButton2);
            JButton jButton3 = new JButton(ActionUtils.createActionForComp((TopComponent)this.categoryTreeExpl, (Action)SystemAction.get(RemoveCategoryAction.class)));
            jButton3.setPreferredSize(new Dimension(200, 30));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagLayout.setConstraints(jButton3, gridBagConstraints);
            this.buttonsPanel.add(jButton3);
            JButton jButton4 = new JButton(ActionUtils.createActionForComp((TopComponent)this.categoryTreeExpl, (Action)SystemAction.get(RemoveSubCategoriesAction.class)));
            jButton4.setPreferredSize(new Dimension(200, 30));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(2, 0, 0, 0);
            gridBagLayout.setConstraints(jButton4, gridBagConstraints);
            this.buttonsPanel.add(jButton4);
            this.add((Component)((Object)this.categoryTreeExpl));
            jPanel.add((Component)this.buttonsPanel, "North");
            this.add(jPanel);
            this.add((Component)((Object)this.choosenCategoryExpl));
        }
        catch (LaserConsoleException laserConsoleException) {
            logger.debug((Object)laserConsoleException, laserConsoleException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Problem with connection business layer.\n Try again later.\n See log file.");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        catch (LaserException laserException) {
            LogFactory.logException(logger, (Exception)((Object)laserException));
            logger.debug((Object)laserException, laserException.fillInStackTrace());
            logger.debug((Object)laserException, laserException.getRootCause().fillInStackTrace());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Problem with connection business layer.\n Try again later.");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private CategoryTreeExplorer createCategoryTree() throws LaserException {
        logger.debug((Object)"createCategoryRoot()");
        CategoryBrowsingHandler categoryBrowsingHandler = CategoryBrowsingHandlerFactory.getHandler();
        Category category = categoryBrowsingHandler.getCategoryTreeRoot();
        logger.debug((Object)("categoryRoot=" + category));
        CategoryTreeExplorer categoryTreeExplorer = new CategoryTreeExplorer(category);
        logger.debug((Object)("categoryTree=" + (Object)((Object)categoryTreeExplorer)));
        return categoryTreeExplorer;
    }

    private ChoosenCategoryExplorer createChoosenCategoryList(List list) {
        ChoosenCategoryExplorer choosenCategoryExplorer = new ChoosenCategoryExplorer(list);
        return choosenCategoryExplorer;
    }

    public Collection getChoosenCategories() {
        return this.choosenCategoryExpl.getChoosenCategories();
    }

    public Category[] getChoosenCategoriesArray() {
        Collection collection = this.getChoosenCategories();
        Category[] categoryArray = new Category[collection.size()];
        int n = 0;
        for (Object e : collection) {
            categoryArray[n] = e instanceof Category ? (Category)e : ((CategoryBean)e).getCategory();
            ++n;
        }
        return categoryArray;
    }

    public void updateCategoryTreeExplorer() {
        this.updateSelection();
        this.updateState();
    }

    public void loadAllCategoriesInTreeExplorer() {
        this.categoryTreeExpl.expandAndColapseTree();
        this.updateCategoryTreeExplorer();
    }

    public void reset() {
        this.choosenCategoryExpl.removeAllCategories();
    }

    public void addCategory(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.choosenCategoryExpl.addCategory(gPNode);
    }

    public void addCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.choosenCategoryExpl.addCategoryWithoutChildren(gPNode);
    }

    public void addSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.choosenCategoryExpl.addSubCategories(gPNode);
    }

    public void removeCategoryWithoutChildren(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.choosenCategoryExpl.removeCategoryWithoutChildren(gPNode);
    }

    public void removeSubCategories(GPNode gPNode) throws IntrospectionException, CloneNotSupportedException {
        this.choosenCategoryExpl.removeSubCategories(gPNode);
    }

    public void removeCategory(GPNode gPNode) {
        this.choosenCategoryExpl.removeCategory(gPNode);
    }

    public void removeAllCategories() {
        this.choosenCategoryExpl.removeAllCategories();
    }

    public void updateCategorySelection(Configuration configuration) throws LaserConsoleException {
        Category[] categoryArray = configuration.getSelection().getCategorySelection().list();
        this.choosenCategoryExpl.updateChoosenCategories(Arrays.asList(categoryArray));
        this.updateCategoryTreeExplorer();
    }

    public void updateState() {
        try {
            GPNode gPNode = this.categoryTreeExpl.getRootNode();
            this.updateState(gPNode);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    private int updateState(GPNode gPNode) throws CloneNotSupportedException {
        CategoryBean categoryBean = (CategoryBean)gPNode.getBean();
        int n = categoryBean.isSelected() ? 3 : 1;
        if (!gPNode.getPeerNode().isLeaf()) {
            NodeCollection nodeCollection = gPNode.getNodeCollection();
            CategoryTreeExplorer.CategoryTreeNodeManager categoryTreeNodeManager = (CategoryTreeExplorer.CategoryTreeNodeManager)nodeCollection.getChildrenManager();
            NodeList nodeList = categoryTreeNodeManager.getNodeList();
            boolean bl = true;
            if (nodeList != null) {
                for (GPNode gPNode2 : nodeList) {
                    int n2 = this.updateState(gPNode2);
                    if (bl) {
                        bl = false;
                        n = n2;
                        continue;
                    }
                    block0 : switch (n2) {
                        case 1: {
                            switch (n) {
                                case 1: {
                                    n = 1;
                                    break block0;
                                }
                                case 2: {
                                    n = 2;
                                    break block0;
                                }
                                case 3: {
                                    n = 2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (n) {
                                case 1: {
                                    n = 2;
                                    break block0;
                                }
                                case 2: {
                                    n = 2;
                                    break block0;
                                }
                                case 3: {
                                    n = 2;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (n) {
                                case 1: {
                                    n = 2;
                                    break block0;
                                }
                                case 2: {
                                    n = 2;
                                    break block0;
                                }
                                case 3: {
                                    n = 3;
                                }
                            }
                        }
                    }
                }
            }
        }
        categoryBean.setChildrenSelectionState(n);
        if (!categoryBean.isSelected() && n == 3) {
            return 2;
        }
        if (categoryBean.isSelected() && n == 1) {
            return 2;
        }
        return n;
    }

    public void updateSelection() {
        try {
            GPNode gPNode = this.categoryTreeExpl.getRootNode();
            this.updateSelection(gPNode);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    private void updateSelection(GPNode gPNode) throws CloneNotSupportedException {
        NodeCollection nodeCollection;
        CategoryTreeExplorer.CategoryTreeNodeManager categoryTreeNodeManager;
        NodeList nodeList;
        CategoryBean categoryBean = (CategoryBean)gPNode.getBean();
        if (this.choosenCategoryExpl.contains(gPNode)) {
            categoryBean.setSelected(true);
        } else {
            categoryBean.setSelected(false);
        }
        if (!gPNode.getPeerNode().isLeaf() && (nodeList = (categoryTreeNodeManager = (CategoryTreeExplorer.CategoryTreeNodeManager)(nodeCollection = gPNode.getNodeCollection()).getChildrenManager()).getNodeList()) != null) {
            for (GPNode gPNode2 : nodeList) {
                this.updateSelection(gPNode2);
            }
        }
    }
}

