/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.behaviour;

import cern.laser.guiplatform.util.LogFactory;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class SimpleChoosePanel
extends JPanel
implements ActionListener {
    private static Logger logger = LogFactory.getLogger(SimpleChoosePanel.class.getName());
    private JRadioButton leftRadio = null;
    private JRadioButton rightRadio = null;
    private ActionListener confChangeListener = null;

    public SimpleChoosePanel() {
    }

    public SimpleChoosePanel(String string, String string2, String string3) {
        this.initComponent(string, string2, string3, null);
    }

    public SimpleChoosePanel(String string, String string2, String string3, String string4) {
        this.initComponent(string, string2, string3, string4);
    }

    private void initComponent(String string, String string2, String string3, String string4) {
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
        this.setLayout(new GridLayout(0, 2));
        this.setBorder(titledBorder);
        this.leftRadio = new JRadioButton(string2);
        this.leftRadio.addActionListener(this);
        this.rightRadio = new JRadioButton(string3);
        this.rightRadio.addActionListener(this);
        if (string4 != null) {
            if (string4.equals("left")) {
                this.leftRadio.setSelected(true);
            } else if (string4.equals("right")) {
                this.rightRadio.setSelected(true);
            }
        }
        this.add(this.leftRadio);
        this.add(this.rightRadio);
    }

    private void initComponent(String string, String string2, String string3) {
        this.initComponent(string, string2, string3, null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        logger.debug((Object)" checbox changed !!!!!!! ");
        logger.debug((Object)actionEvent.getActionCommand());
        if (actionEvent.getSource().equals(this.leftRadio)) {
            this.leftRadio.setSelected(true);
            this.rightRadio.setSelected(false);
        } else if (actionEvent.getSource().equals(this.rightRadio)) {
            this.rightRadio.setSelected(true);
            this.leftRadio.setSelected(false);
        }
        if (this.confChangeListener != null) {
            this.confChangeListener.actionPerformed(actionEvent);
        }
    }

    public String getChoosenButton() {
        if (this.leftRadio.isSelected()) {
            return "left";
        }
        return "right";
    }

    public void setSelected(String string) {
        if (string.equals("left")) {
            this.leftRadio.setSelected(true);
            this.rightRadio.setSelected(false);
        } else if (string.equals("right")) {
            this.rightRadio.setSelected(true);
            this.leftRadio.setSelected(false);
        }
    }

    public void setLeftText(String string) {
        this.leftRadio.setText(string);
    }

    public void setRightText(String string) {
        this.rightRadio.setText(string);
    }

    public void addConfigurationChangeListener(ActionListener actionListener) {
        this.confChangeListener = actionListener;
    }
}

