/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows.alarms;

import cern.gp.explorer.ListTableExplorer;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.ChildrenMapManager;
import cern.gp.nodes.children.NodeMap;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.InfoAlarmBean;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.IntrospectionException;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class AlarmInfoExplorer
extends ListTableExplorer {
    private JLabel alarmNoLabel;
    private JLabel alarmNoValLabel;
    private JPanel infoPanel;
    private JLabel titleLabel;
    private static final Logger logger = LogFactory.getLogger(AlarmInfoExplorer.class.getName());
    private NodeManager nManager = null;
    private static final String componentName = NbBundle.getMessage(AlarmInfoExplorer.class, (String)"LBL_AlarmInfoExplorer_component_name");
    private Dimension defaultDimension;
    private static final long serialVersionUID = 1L;

    public AlarmInfoExplorer(List list, String string, String[] stringArray) {
        this.defaultDimension = new Dimension((int)((double)WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 1.5), WindowManager.getDefault().getCurrentWorkspace().getBounds().height / 3);
        this.initComponents();
        this.setCloseOperation(1);
        this.setName(componentName);
        this.putClientProperty("PersistenceType", "Never");
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.nManager = new NodeManager(list);
        try {
            Object object = new Object();
            GPNode gPNode = NodeFactory.createNode((Object)object, (ChildrenManager)this.nManager);
            this.setRootNode(gPNode);
            this.setTableColumns(new AlarmBean(), stringArray);
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
        }
        this.titleLabel.setText(string);
        this.alarmNoValLabel.setText("" + list.size());
    }

    public void update(List list, String string) {
        this.titleLabel.setText(string);
        this.alarmNoValLabel.setText("" + list.size());
        this.nManager.updateManager(list);
    }

    public String getName() {
        return componentName;
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.alarmNoLabel = new JLabel();
        this.alarmNoValLabel = new JLabel();
        this.infoPanel.setLayout(new GridBagLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("Alarms belong to TEST category");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(7, 0, 5, 0);
        this.infoPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.alarmNoLabel.setText("Alarm No:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 8, 6, 0);
        this.infoPanel.add((Component)this.alarmNoLabel, gridBagConstraints);
        this.alarmNoValLabel.setText("1000");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.infoPanel.add((Component)this.alarmNoValLabel, gridBagConstraints);
        this.add(this.infoPanel, "North");
    }

    public Dimension getPreferredSize() {
        return this.defaultDimension;
    }

    private class NodeManager
    implements ChildrenMapManager {
        private Logger logger = LogFactory.getLogger(NodeManager.class.getName());
        private List list = null;
        private NodeMap nodeMap = null;

        public NodeManager(List list) {
            this.list = list;
        }

        public Comparator getComparator() {
            return null;
        }

        public void initChildrenMap(NodeMap nodeMap) {
            this.nodeMap = nodeMap;
            try {
                for (InfoAlarmBean infoAlarmBean : this.list) {
                    nodeMap.addNode((Object)infoAlarmBean.getAlarmId(), NodeFactory.createNode((Object)infoAlarmBean));
                }
            }
            catch (IntrospectionException introspectionException) {
                this.logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
            }
        }

        public void updateManager(List list) {
            this.list = list;
            this.nodeMap.removeNodes(this.nodeMap.keySet().toArray());
            for (InfoAlarmBean infoAlarmBean : this.list) {
                try {
                    this.nodeMap.addNode((Object)infoAlarmBean.getAlarmId(), NodeFactory.createNode((Object)infoAlarmBean));
                }
                catch (IntrospectionException introspectionException) {
                    this.logger.error((Object)introspectionException.getMessage(), (Throwable)introspectionException);
                }
            }
        }
    }
}

