/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows;

import cern.gp.explorer.ListExplorer;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.ChildrenManager;
import cern.gp.nodes.children.NodeList;
import cern.gp.windows.WindowUtils;
import cern.laser.guiplatform.actions.DisableColumnAction;
import cern.laser.guiplatform.actions.EnableColumnAction;
import cern.laser.guiplatform.beans.DisplayColumnBean;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.actions.ActionUtils;
import cern.laser.guiplatform.windowmanager.AcWindowManager;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class DisplayableColumnExplorer
extends ListExplorer {
    private static final Logger logger = LogFactory.getLogger(DisplayableColumnExplorer.class.getName());
    private String[] userProperties = null;
    private JPanel actionButtonPanel;
    private JButton disableButton;
    private JButton downButton;
    private JPanel eastPanel;
    private JButton enableButton;
    private JButton upButton;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JPanel okCancelButtonPanel;
    private JPanel southButtonPanel;
    private boolean withOkCancelButtonPanel = true;
    private DisplayableColumnNodeManager nodeManager = null;
    private Object rootNode = null;

    public DisplayableColumnExplorer(String[] stringArray, boolean bl) {
        this.userProperties = stringArray;
        this.withOkCancelButtonPanel = bl;
        this.initComponents();
        this.postInitComponents();
    }

    public DisplayableColumnExplorer(String[] stringArray) {
        this(stringArray, true);
    }

    private void initComponents() {
        this.eastPanel = new JPanel();
        this.actionButtonPanel = new JPanel();
        this.upButton = new JButton(ActionUtils.createActionForComp((TopComponent)this, (Action)SystemAction.get(MoveUpAction.class)));
        this.downButton = new JButton(ActionUtils.createActionForComp((TopComponent)this, (Action)SystemAction.get(MoveDownAction.class)));
        this.enableButton = new JButton(ActionUtils.createActionForComp((TopComponent)this, (Action)SystemAction.get(EnableColumnAction.class)));
        this.disableButton = new JButton(ActionUtils.createActionForComp((TopComponent)this, (Action)SystemAction.get(DisableColumnAction.class)));
        this.eastPanel.setLayout(new BorderLayout());
        this.actionButtonPanel.setLayout(new GridBagLayout());
        this.upButton.setHorizontalAlignment(2);
        this.upButton.setMaximumSize(new Dimension(88, 25));
        this.upButton.setPreferredSize(new Dimension(110, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 6, 2, 4);
        this.actionButtonPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setHorizontalAlignment(2);
        this.downButton.setPreferredSize(new Dimension(110, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 6, 7, 4);
        this.actionButtonPanel.add((Component)this.downButton, gridBagConstraints);
        this.enableButton.setHorizontalAlignment(2);
        this.enableButton.setPreferredSize(new Dimension(110, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(7, 6, 2, 4);
        this.actionButtonPanel.add((Component)this.enableButton, gridBagConstraints);
        this.disableButton.setHorizontalAlignment(2);
        this.disableButton.setPreferredSize(new Dimension(110, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 6, 5, 4);
        this.actionButtonPanel.add((Component)this.disableButton, gridBagConstraints);
        this.eastPanel.add((Component)this.actionButtonPanel, "North");
        this.add(this.eastPanel, "East");
    }

    private void postInitComponents() {
        this.initNodeManager();
        if (this.withOkCancelButtonPanel) {
            this.southButtonPanel = new JPanel();
            this.okCancelButtonPanel = new JPanel();
            this.okButton = new JButton();
            this.applyButton = new JButton();
            this.cancelButton = new JButton();
            this.southButtonPanel.setLayout(new BorderLayout());
            this.okButton.setText(NbBundle.getMessage(DisplayableColumnExplorer.class, (String)"LBL_OK_label"));
            this.okButton.setPreferredSize(new Dimension(75, 25));
            this.okCancelButtonPanel.add(this.okButton);
            this.applyButton.setText(NbBundle.getMessage(DisplayableColumnExplorer.class, (String)"LBL_Apply_label"));
            this.applyButton.setPreferredSize(new Dimension(75, 25));
            this.okCancelButtonPanel.add(this.applyButton);
            this.cancelButton.setText(NbBundle.getMessage(DisplayableColumnExplorer.class, (String)"LBL_Cancel_label"));
            this.okCancelButtonPanel.add(this.cancelButton);
            this.southButtonPanel.add((Component)this.okCancelButtonPanel, "East");
            this.add(this.southButtonPanel, "South");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayableColumnExplorer.this.cancelButtonActionPerformed(actionEvent);
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayableColumnExplorer.this.okButtonActionPerformed(actionEvent);
                }
            });
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayableColumnExplorer.this.applyButtonActionPerformed(actionEvent);
                }
            });
        }
    }

    private void initNodeManager() {
        this.nodeManager = new DisplayableColumnNodeManager(Constants.getPropertyNames(), Constants.getDisplayColumnNames(), this.userProperties);
        this.rootNode = new DisplayColumnBean();
        try {
            this.setRootNode(NodeFactory.createNode((Object)this.rootNode, (ChildrenManager)this.nodeManager));
        }
        catch (IntrospectionException introspectionException) {
            logger.error((Object)introspectionException, introspectionException.fillInStackTrace());
        }
    }

    public String getName() {
        return "Choose columns";
    }

    public List getEnabledColumns() {
        return this.nodeManager.getEnabledColumns();
    }

    public void okButtonActionPerformed(ActionEvent actionEvent) {
        List list = this.getEnabledColumns();
        logger.debug((Object)("enabled columns count " + list.size()));
        logger.debug((Object)list.toString());
        String string = NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Active_list_component_name");
        String[] stringArray = list.toArray(new String[0]);
        AcWindowManager.setTableColumns(string, stringArray);
        this.close();
    }

    public void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public void applyButtonActionPerformed(ActionEvent actionEvent) {
        List list = this.getEnabledColumns();
        String string = NbBundle.getMessage(ActiveListExplorerPanel.class, (String)"LBL_Active_list_component_name");
        String[] stringArray = list.toArray(new String[0]);
        AcWindowManager.setTableColumns(string, stringArray);
    }

    public void reset() {
        this.initNodeManager();
    }

    public static void main(String[] stringArray) {
        DisplayableColumnExplorer displayableColumnExplorer = new DisplayableColumnExplorer(new String[]{"faultFamily", "faultMember"});
        WindowUtils.openInMode((TopComponent)displayableColumnExplorer, (String)displayableColumnExplorer.getName());
    }

    public void updateColumns(String[] stringArray) {
        this.userProperties = stringArray;
        this.initNodeManager();
    }

    private class DisplayableColumnNodeManager
    implements ChildrenListManager {
        private final Logger logger = Logger.getLogger((String)DisplayableColumnNodeManager.class.getName());
        private NodeList nodeList = null;
        private String[] allProperties = null;
        private String[] allPropertyDisplayNames = null;
        private String[] userProperties = null;

        public DisplayableColumnNodeManager(String[] stringArray, String[] stringArray2, String[] stringArray3) {
            this.allProperties = stringArray;
            this.allPropertyDisplayNames = stringArray2;
            this.userProperties = stringArray3;
        }

        public Comparator getComparator() {
            return null;
        }

        public void initChildrenList(NodeList nodeList) {
            this.nodeList = nodeList;
            List<String> list = Arrays.asList(this.userProperties);
            for (int i = 0; i < this.allProperties.length; ++i) {
                String string = this.allProperties[i];
                String string2 = this.allPropertyDisplayNames[i];
                String string3 = "cern/laser/guiplatform/images/status_lock.gif";
                boolean bl = false;
                if (list.contains(string)) {
                    string3 = "cern/laser/guiplatform/images/status_unlocked.gif";
                    bl = true;
                }
                try {
                    nodeList.addNode(NodeFactory.createNode((Object)new DisplayColumnBean(string, string2, string3, bl)));
                    continue;
                }
                catch (IntrospectionException introspectionException) {
                    this.logger.error((Object)introspectionException.toString());
                }
            }
        }

        public List getEnabledColumns() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                DisplayColumnBean displayColumnBean = (DisplayColumnBean)((GPNode)iterator.next()).getBean();
                if (!displayColumnBean.isEnabled()) continue;
                arrayList.add(displayColumnBean.getName());
            }
            return arrayList;
        }
    }
}

