/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows;

import cern.laser.client.LaserException;
import cern.laser.client.services.selection.AlarmSelectionHandler;
import cern.laser.client.services.selection.AlarmSelectionListener;
import cern.laser.client.services.selection.Selection;
import cern.laser.console.Behaviour;
import cern.laser.console.Configuration;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.alarms.AlarmSelectionOnExceptionListener;
import cern.laser.guiplatform.alarms.AlarmsNumberChangeListener;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.DateTimeUtils;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.ProxyBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class AlarmStatisticInfoPanel
extends JPanel
implements AlarmsNumberChangeListener,
AlarmSelectionOnExceptionListener {
    private JLabel activeAlarmLabel;
    private JLabel activeCounterLabel;
    private JPanel alarmStatPanel;
    private JLabel autoTerminateLabel;
    private JLabel autoTerminteValueLabel;
    private JLabel confNameValueLabel;
    private JLabel configurationNameLabel;
    private JPanel consoleInfoPanel;
    private JLabel distingiushAlarmValueLabel;
    private JLabel distinguishNewAlarmLabel;
    private JPanel iconPanel;
    private JLabel inhibitedAlarmLabel;
    private JLabel inhibitedCounterLabel;
    private JPanel labelsPanel;
    private JLabel maskedAlarmLabel;
    private JLabel maskedCounterLabel;
    private JLabel networkIconLabel;
    private JLabel reducedMaskeValueLabel;
    private JLabel reducedMaskedLabel;
    private long[] alarmNumbers = null;
    private static final String CONNECTION_OK = "Connection OK";
    private static final String CONNECTION_NOT_OK = "Connection unavailable";
    private static final String CONNECTION_NOT_OK_HB = "No heartbeat";
    private JLabel[] labels = null;
    private static Logger logger = LogFactory.getLogger(AlarmStatisticInfoPanel.class.getName());

    public AlarmStatisticInfoPanel(String string, Behaviour behaviour, boolean bl) {
        this.initComponents();
        this.postInitComponents(string, behaviour, bl);
        this.alarmNumbers = new long[6];
        for (int i = 0; i < 6; ++i) {
            this.alarmNumbers[i] = 0L;
        }
        this.activeCounterLabel.setText("" + this.alarmNumbers[0]);
        this.maskedCounterLabel.setText("" + this.alarmNumbers[1]);
        this.inhibitedCounterLabel.setText("" + this.alarmNumbers[2]);
        this.labels = new JLabel[6];
        this.labels[0] = this.activeCounterLabel;
        this.labels[2] = this.inhibitedCounterLabel;
        this.labels[1] = this.maskedCounterLabel;
        this.labels[3] = null;
        this.labels[4] = null;
        this.labels[5] = null;
    }

    private void initComponents() {
        this.alarmStatPanel = new JPanel();
        this.activeAlarmLabel = new JLabel();
        this.activeCounterLabel = new JLabel();
        this.maskedAlarmLabel = new JLabel();
        this.maskedCounterLabel = new JLabel();
        this.inhibitedAlarmLabel = new JLabel();
        this.inhibitedCounterLabel = new JLabel();
        this.consoleInfoPanel = new JPanel();
        this.labelsPanel = new JPanel();
        this.configurationNameLabel = new JLabel();
        this.confNameValueLabel = new JLabel();
        this.distinguishNewAlarmLabel = new JLabel();
        this.distingiushAlarmValueLabel = new JLabel();
        this.autoTerminateLabel = new JLabel();
        this.autoTerminteValueLabel = new JLabel();
        this.reducedMaskedLabel = new JLabel();
        this.reducedMaskeValueLabel = new JLabel();
        this.iconPanel = new JPanel();
        this.networkIconLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.alarmStatPanel.setLayout(new GridBagLayout());
        this.alarmStatPanel.setBorder(new EtchedBorder());
        this.activeAlarmLabel.setText("Active alarms:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 5, 2, 0);
        this.alarmStatPanel.add((Component)this.activeAlarmLabel, gridBagConstraints);
        this.activeCounterLabel.setHorizontalAlignment(0);
        this.activeCounterLabel.setText("      ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 10, 2, 5);
        this.alarmStatPanel.add((Component)this.activeCounterLabel, gridBagConstraints);
        this.maskedAlarmLabel.setText("Masked Alarms:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        this.alarmStatPanel.add((Component)this.maskedAlarmLabel, gridBagConstraints);
        this.maskedCounterLabel.setHorizontalAlignment(0);
        this.maskedCounterLabel.setText("      ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 5);
        this.alarmStatPanel.add((Component)this.maskedCounterLabel, gridBagConstraints);
        this.inhibitedAlarmLabel.setText("Inhibited Alarms:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 5, 0);
        this.alarmStatPanel.add((Component)this.inhibitedAlarmLabel, gridBagConstraints);
        this.inhibitedCounterLabel.setHorizontalAlignment(0);
        this.inhibitedCounterLabel.setText("      ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 10, 5, 5);
        this.alarmStatPanel.add((Component)this.inhibitedCounterLabel, gridBagConstraints);
        this.add((Component)this.alarmStatPanel, "West");
        this.consoleInfoPanel.setLayout(new BorderLayout());
        this.consoleInfoPanel.setBorder(new EtchedBorder());
        this.labelsPanel.setLayout(new GridBagLayout());
        this.configurationNameLabel.setText("Currently used configuration: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 3, 0);
        this.labelsPanel.add((Component)this.configurationNameLabel, gridBagConstraints);
        this.confNameValueLabel.setForeground(new Color(51, 51, 255));
        this.confNameValueLabel.setText("Configuration name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 3, 0);
        this.labelsPanel.add((Component)this.confNameValueLabel, gridBagConstraints);
        this.distinguishNewAlarmLabel.setText("Distinguish new alarms: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 3, 4);
        this.labelsPanel.add((Component)this.distinguishNewAlarmLabel, gridBagConstraints);
        this.distingiushAlarmValueLabel.setText("YES");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 3, 0);
        this.labelsPanel.add((Component)this.distingiushAlarmValueLabel, gridBagConstraints);
        this.autoTerminateLabel.setText("Auto Terminate: ");
        this.autoTerminateLabel.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 14, 3, 4);
        this.labelsPanel.add((Component)this.autoTerminateLabel, gridBagConstraints);
        this.autoTerminteValueLabel.setText("NO");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 4, 3, 0);
        this.labelsPanel.add((Component)this.autoTerminteValueLabel, gridBagConstraints);
        this.reducedMaskedLabel.setText("Reduced masked flag: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 14, 3, 4);
        this.labelsPanel.add((Component)this.reducedMaskedLabel, gridBagConstraints);
        this.reducedMaskeValueLabel.setText("YES");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 3, 4);
        this.labelsPanel.add((Component)this.reducedMaskeValueLabel, gridBagConstraints);
        this.consoleInfoPanel.add((Component)this.labelsPanel, "Center");
        this.iconPanel.setLayout(new GridBagLayout());
        this.networkIconLabel.setForeground(new Color(51, 51, 255));
        this.networkIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/cern/laser/guiplatform/images/console-connected.png")));
        this.networkIconLabel.setText(CONNECTION_OK);
        this.networkIconLabel.setHorizontalTextPosition(0);
        this.networkIconLabel.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.iconPanel.add((Component)this.networkIconLabel, gridBagConstraints);
        this.consoleInfoPanel.add((Component)this.iconPanel, "East");
        this.add((Component)this.consoleInfoPanel, "Center");
    }

    private void postInitComponents(String string, Behaviour behaviour, boolean bl) {
        this.confNameValueLabel.setText(string);
        if (string != null && (string.equals("NOT SAVED RECENTLY LOADED CONFIGURATION") || string.equals("NOT SAVED DEFAULT CONFIGURATION"))) {
            this.confNameValueLabel.setForeground(new Color(255, 0, 0));
        } else {
            this.confNameValueLabel.setForeground(new Color(51, 51, 255));
        }
        this.distingiushAlarmValueLabel.setText(behaviour.isAlarmDistinguished() ? "YES" : "NO");
        this.autoTerminteValueLabel.setText(behaviour.isAlarmAutoTerminated() ? "YES" : "NO");
        this.reducedMaskeValueLabel.setText(bl ? "YES" : "NO");
    }

    public void updatePanel(String string, Behaviour behaviour, boolean bl) {
        this.postInitComponents(string, behaviour, bl);
    }

    @Override
    public void moveAlarmNumber(int n, int n2) {
        if (n > 6 || n2 > 6) {
            throw new IllegalArgumentException("argument >  AlarmNumberChangeListener.ALL_LIST_NUMBER");
        }
        if (this.alarmNumbers[n] > 0L) {
            int n3 = n;
            this.alarmNumbers[n3] = this.alarmNumbers[n3] - 1L;
        }
        this.labels[n].setText("" + this.alarmNumbers[n]);
        int n4 = n2;
        this.alarmNumbers[n4] = this.alarmNumbers[n4] + 1L;
        this.labels[n2].setText("" + this.alarmNumbers[n2]);
    }

    @Override
    public void update(int n, long l) {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            logger.debug((Object)("Counter updated, type=" + n + " number=" + l));
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                logger.debug((Object)("stack: " + stackTraceElementArray[i]));
            }
            switch (n) {
                case 0: {
                    this.alarmNumbers[0] = l;
                    this.activeCounterLabel.setText("" + this.alarmNumbers[0]);
                    break;
                }
                case 2: {
                    this.alarmNumbers[2] = l;
                    this.inhibitedCounterLabel.setText("" + this.alarmNumbers[2]);
                    break;
                }
                case 1: {
                    this.alarmNumbers[1] = l;
                    this.maskedCounterLabel.setText("" + this.alarmNumbers[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Valid argument is only from AlarmNumberChangeListener interface");
                }
            }
            return;
        }
    }

    @Override
    public void increaseCounter(int n) {
        switch (n) {
            case 0: {
                this.alarmNumbers[0] = this.alarmNumbers[0] + 1L;
                this.activeCounterLabel.setText("" + this.alarmNumbers[0]);
                break;
            }
            case 2: {
                this.alarmNumbers[2] = this.alarmNumbers[2] + 1L;
                this.inhibitedCounterLabel.setText("" + this.alarmNumbers[2]);
                break;
            }
            case 1: {
                this.alarmNumbers[1] = this.alarmNumbers[1] + 1L;
                this.maskedCounterLabel.setText("" + this.alarmNumbers[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid argument is only from AlarmNumberChangeListener interface");
            }
        }
    }

    @Override
    public void decreaseCounter(int n) {
        switch (n) {
            case 0: {
                if (this.alarmNumbers[0] > 0L) {
                    this.alarmNumbers[0] = this.alarmNumbers[0] - 1L;
                }
                this.activeCounterLabel.setText("" + this.alarmNumbers[0]);
                break;
            }
            case 2: {
                if (this.alarmNumbers[2] > 0L) {
                    this.alarmNumbers[2] = this.alarmNumbers[2] - 1L;
                }
                this.inhibitedCounterLabel.setText("" + this.alarmNumbers[2]);
                break;
            }
            case 1: {
                if (this.alarmNumbers[1] > 0L) {
                    this.alarmNumbers[1] = this.alarmNumbers[1] - 1L;
                }
                this.maskedCounterLabel.setText("" + this.alarmNumbers[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid argument is only from AlarmNumberChangeListener interface");
            }
        }
    }

    @Override
    public void onException(String string) {
        logger.debug((Object)("onException(" + string + ")"));
        if (string.equals("CONNECTION_DROPPED")) {
            this.networkIconLabel.setForeground(new Color(255, 0, 0));
            this.networkIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/cern/laser/guiplatform/images/console-disconnected.png")));
            this.networkIconLabel.setText("Connection unavailable " + DateTimeUtils.getCurrentTimestamp());
        } else if (string.equals("HEARTBEAT_LOST")) {
            this.networkIconLabel.setForeground(new Color(255, 0, 0));
            this.networkIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/cern/laser/guiplatform/images/console-disconnected.png")));
            this.networkIconLabel.setText("No heartbeat " + DateTimeUtils.getCurrentTimestamp());
        } else {
            try {
                this.networkIconLabel.setForeground(new Color(51, 51, 255));
                this.networkIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/cern/laser/guiplatform/images/console-connected.png")));
                this.networkIconLabel.setText(CONNECTION_OK);
                AlarmSelectionHandler alarmSelectionHandler = null;
                alarmSelectionHandler = AlarmSelectionHandlerFactory.getHandler();
                alarmSelectionHandler.resetSelection();
                ProxyBuffer.getDefault().disable();
                AlarmContainer.getDefault().clearNodeManagers();
                Selection selection = AppRegister.getInstance().getSelection();
                Configuration configuration = AppRegister.getInstance().getLoadedConfiguration();
                Map map = alarmSelectionHandler.select(selection, (AlarmSelectionListener)ProxyBuffer.getDefault());
                AlarmContainer.getDefault().reloadContainer(map, configuration);
                ProxyBuffer.getDefault().enable();
            }
            catch (LaserException laserException) {
                logger.error((Object)laserException, laserException.fillInStackTrace());
                logger.error((Object)laserException.getRootCause(), laserException.getRootCause().fillInStackTrace());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)"Connection error. Unable to select new fault states.\nPlease, logout and try to login again later", 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
        }
    }
}

