/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windows;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.explorer.ACExplorer;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ActiveListExplorerPanel
extends ACExplorer {
    private static Logger logger = LogFactory.getLogger(ActiveListExplorerPanel.class.getName());
    private boolean canBeClosed = true;
    private String componentName = null;
    private Dimension defaultDimension;

    public ActiveListExplorerPanel(AlarmNodeManager alarmNodeManager, String string, boolean bl, boolean bl2, String[] stringArray) {
        super(alarmNodeManager, stringArray);
        this.defaultDimension = new Dimension((int)((double)WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 1.5), WindowManager.getDefault().getCurrentWorkspace().getBounds().height / 3);
        this.initComponents();
        this.setCloseOperation(1);
        this.componentName = string;
        this.setName(string);
        this.canBeClosed = bl;
        if (!bl2) {
            this.putClientProperty("PersistenceType", "Never");
        }
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new ListSelectionListener());
    }

    public ActiveListExplorerPanel(AlarmNodeManager alarmNodeManager, String string, String[] stringArray) {
        this(alarmNodeManager, string, true, true, stringArray);
    }

    public ActiveListExplorerPanel(AlarmNodeManager alarmNodeManager, String string, boolean bl, String[] stringArray) {
        this(alarmNodeManager, string, bl, true, stringArray);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        return this.canBeClosed;
    }

    public void setCanBeClose(boolean bl) {
        this.canBeClosed = bl;
    }

    public String getName() {
        return this.componentName;
    }

    private boolean[] getColumnsToSort(String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        return blArray;
    }

    private void initComponents() {
    }

    public Dimension getPreferredSize() {
        return this.defaultDimension;
    }

    private class ListSelectionListener
    implements PropertyChangeListener {
        private Logger logger = LogFactory.getLogger(ListSelectionListener.class.getName());

        private ListSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray = ActiveListExplorerPanel.this.getExplorerManager().getSelectedNodes();
            AlarmBeanNode alarmBeanNode = null;
            AlarmBean alarmBean = null;
            AlarmBean[] alarmBeanArray = new AlarmBean[nodeArray.length];
            boolean bl = false;
            for (int i = 0; i < nodeArray.length; ++i) {
                try {
                    alarmBeanNode = (AlarmBeanNode)nodeArray[i];
                    try {
                        alarmBean = (AlarmBean)alarmBeanNode.getBean();
                    }
                    catch (ClassCastException classCastException) {
                        this.logger.debug((Object)("ClassCastException not AlarmBean, it is:" + nodeArray[i]));
                    }
                }
                catch (ClassCastException classCastException) {
                    this.logger.debug((Object)("ClassCastException not AlarmBeanNode, it is:" + nodeArray[i]));
                }
                if (alarmBean == null) continue;
                if (alarmBean.isNew()) {
                    bl = true;
                }
                alarmBean.setIsNew(false);
                try {
                    alarmBeanArray[i] = (AlarmBean)alarmBean.clone();
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    this.logger.debug((Object)("CloneNotSupportedException " + cloneNotSupportedException.getMessage()));
                }
            }
            if (bl) {
                AlarmContainer.getDefault().setNewIndicator(alarmBeanArray);
            }
        }
    }
}

