/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.windowmanager;

import cern.gp.windows.WindowUtils;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.explorer.ACExplorer;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;
import cern.laser.guiplatform.windows.alarms.AlarmDetailsPanel;
import cern.laser.guiplatform.windows.alarms.AlarmTimestampsPanel;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerPanel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class AcWindowManager {
    private static Logger logger = LogFactory.getLogger(AcWindowManager.class.getName());
    private static String defaultWorkSpaceName = "alarmconsole";
    private static Workspace defautlWorkspace = AcWindowManager.findWorkspace();
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];

    private AcWindowManager() {
    }

    public static void openInMode(String string, TopComponent topComponent) {
        logger.debug((Object)("component bounds: " + topComponent.getName() + " " + topComponent.getBounds().toString()));
        Workspace workspace = AcWindowManager.findWorkspace();
        Mode mode = workspace.findMode(string);
        if (mode == null) {
            logger.debug((Object)("Mode " + string + " not found, crated new one"));
            mode = workspace.createMode(string, string, null);
        }
        logger.debug((Object)("mode bounds: " + mode.getName() + " " + mode.getBounds().toString()));
        mode.dockInto(topComponent);
        topComponent.open(workspace);
        topComponent.requestFocus();
    }

    public static void openComponent(String string) {
        TopComponent topComponent = AcWindowManager.findTopComponent(AcWindowManager.findWorkspace(), string);
        logger.debug((Object)("openComponent: TopComponent " + string + " was found : " + (topComponent != null ? "YES" : "NO")));
        if (topComponent != null) {
            topComponent.open();
        }
    }

    public static void closeComponent(String string) {
        TopComponent topComponent = AcWindowManager.findTopComponent(AcWindowManager.findWorkspace(), string);
        logger.debug((Object)("closeComponent: TopComponent " + string + " was found : " + (topComponent != null ? "YES" : "NO")));
        if (topComponent != null) {
            topComponent.close();
        }
    }

    public static void closeComponents(String[] stringArray) {
        Workspace workspace = AcWindowManager.findWorkspace();
        for (int i = 0; i < stringArray.length; ++i) {
            TopComponent topComponent = AcWindowManager.findTopComponent(workspace, stringArray[i]);
            if (topComponent != null) {
                topComponent.setCloseOperation(0);
                topComponent.close();
                continue;
            }
            logger.debug((Object)("Top Component " + stringArray[i] + " not found "));
        }
    }

    public static void closeAllTopComponents() {
        Workspace workspace = AcWindowManager.findWorkspace();
        Set set = workspace.getModes();
        for (Mode mode : set) {
            logger.debug((Object)("mode name --> " + mode.getName()));
            TopComponent[] topComponentArray = mode.getTopComponents();
            for (int i = 0; i < topComponentArray.length; ++i) {
                if (topComponentArray[i] instanceof ActiveListExplorerPanel) {
                    ((ActiveListExplorerPanel)topComponentArray[i]).setCanBeClose(true);
                    topComponentArray[i].close(workspace);
                    continue;
                }
                topComponentArray[i].close(workspace);
            }
        }
    }

    public static boolean isOpened(String string) {
        TopComponent topComponent = AcWindowManager.findTopComponent(AcWindowManager.findWorkspace(), string);
        if (topComponent != null) {
            return topComponent.isOpened();
        }
        return false;
    }

    public static TopComponent findTopComponent(String string) {
        return AcWindowManager.findTopComponent(AcWindowManager.findWorkspace(), string);
    }

    public static void openTopComponent(TopComponent topComponent, String string, int n, int n2, URL uRL) {
        Mode mode;
        Workspace workspace = AcWindowManager.findWorkspace();
        int n3 = -1;
        int n4 = -1;
        if (n == 1 && n2 == 11) {
            n3 = workspace.getBounds().x + (workspace.getBounds().width / 2 - topComponent.getPreferredSize().width / 2);
            n4 = workspace.getBounds().y + (workspace.getBounds().height / 2 - topComponent.getPreferredSize().height / 2);
        }
        if ((mode = workspace.findMode(string)) == null) {
            logger.debug((Object)(string + "mode not found "));
            mode = workspace.createMode(string, string, uRL);
        }
        if (n2 == 11) {
            mode.setBounds(new Rectangle(n3, n4, topComponent.getPreferredSize().width, topComponent.getPreferredSize().height));
        } else if (n2 == 10) {
            mode.setBounds(new Rectangle(workspace.getBounds().x, workspace.getBounds().y, workspace.getBounds().width, workspace.getBounds().height));
        }
        AcWindowManager.openInMode(mode.getName(), topComponent);
    }

    public static void openTopComponent(TopComponent topComponent, String string, int n, int n2) {
        AcWindowManager.openTopComponent(topComponent, string, n, n2, null);
    }

    public static void openTopComponent(TopComponent topComponent, String string) {
        WindowUtils.openInMode((TopComponent)topComponent, (String)string);
    }

    public static void activateDefaultWorkspace() {
        AcWindowManager.findWorkspace().activate();
    }

    public static Workspace findWorkspace() {
        Workspace workspace = WindowManager.getDefault().findWorkspace(defaultWorkSpaceName);
        return workspace;
    }

    public static void setTableColumns(String string, String[] stringArray) {
        TopComponent topComponent = AcWindowManager.findTopComponent(WindowManager.getDefault().getCurrentWorkspace(), string);
        if (topComponent == null) {
            logger.debug((Object)(string + " is null"));
        } else {
            logger.debug((Object)(string + " is not null"));
        }
        if (topComponent != null) {
            logger.debug((Object)("newColumns.length " + stringArray.length));
            logger.debug((Object)("activeList is " + topComponent.getClass().getName()));
            ((ACExplorer)topComponent).setTableColumns(stringArray);
        } else {
            logger.debug((Object)(string + " top component is null"));
        }
    }

    public static void showDetails(AlarmBean alarmBean) {
        String string = NbBundle.getMessage(AlarmDetailsPanel.class, (String)"LBL_ALARM_DETAILS_PANEL_component_name");
        TopComponent topComponent = AcWindowManager.findTopComponent(defautlWorkspace, string);
        if (topComponent != null) {
            ((AlarmDetailsPanel)topComponent).updatePanel(alarmBean);
            logger.debug((Object)(string + " found"));
        } else {
            topComponent = new AlarmDetailsPanel(alarmBean);
            logger.debug((Object)(string + " found"));
        }
        topComponent.open();
    }

    public static void showTimestamps(AlarmBean alarmBean) {
        Mode mode2;
        String string = alarmBean.getFaultFamily() + " " + alarmBean.getFaultMember() + " " + alarmBean.getFaultCode();
        String string2 = NbBundle.getMessage(AlarmTimestampsPanel.class, (String)"LBL_ALARM_TIMESTAMP_PANEL_component_name");
        logger.debug((Object)("defautlWorkspace=" + defautlWorkspace + " componentName=" + string2));
        for (Mode mode2 : defautlWorkspace.getModes()) {
            logger.debug((Object)("mode=" + mode2));
            TopComponent[] topComponentArray = mode2.getTopComponents();
            for (int i = 0; i < topComponentArray.length; ++i) {
                TopComponent topComponent = topComponentArray[i];
                logger.debug((Object)("element=" + topComponent));
            }
        }
        mode2 = AcWindowManager.findTopComponent(defautlWorkspace, string2);
        if (mode2 != null) {
            ((AlarmTimestampsPanel)mode2).updatePanel(alarmBean.getTimestamps(), string);
            logger.debug((Object)"timestamps window found");
        } else {
            logger.debug((Object)"new timestamps window must be opened");
            new AlarmTimestampsPanel(alarmBean.getTimestamps(), string).open();
        }
    }

    public static void printAllModeNames() {
        Workspace workspace = AcWindowManager.findWorkspace();
        Set set = workspace.getModes();
        for (Mode mode : set) {
            logger.debug((Object)("mode name --> " + mode.getName()));
        }
    }

    public static void createMode(String string) {
        Workspace workspace = AcWindowManager.findWorkspace();
        workspace.createMode(string, string, null);
    }

    public static void notifyError(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static void notifyWarning(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static void setStatusText(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    public static void setZeroSelectedNodes(String string) {
        ExplorerPanel explorerPanel = (ExplorerPanel)AcWindowManager.findTopComponent(string);
        if (explorerPanel != null) {
            try {
                explorerPanel.getExplorerManager().setSelectedNodes(EMPTY_NODE_ARRAY);
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.error((Object)propertyVetoException, propertyVetoException.fillInStackTrace());
            }
        }
    }

    public static void printAllComponents() {
        Workspace workspace = AcWindowManager.findWorkspace();
        Set set = workspace.getModes();
        for (Mode mode : set) {
            TopComponent[] topComponentArray = mode.getTopComponents();
            logger.debug((Object)("mode name --> " + mode.getName() + " x = " + mode.getBounds().x + " y = " + mode.getBounds().y + " width = " + mode.getBounds().width + " height = " + mode.getBounds().height));
            for (int i = 0; i < topComponentArray.length; ++i) {
                logger.debug((Object)("    top comp name ----> " + topComponentArray[i].getName() + (topComponentArray[i].getCloseOperation() == 0 ? " CLOSE_EACH" : " CLOSE_LAST")));
            }
        }
    }

    public static TopComponent findTopComponent(Workspace workspace, String string) {
        for (Mode mode : workspace.getModes()) {
            TopComponent[] topComponentArray = mode.getTopComponents();
            for (int i = 0; i < topComponentArray.length; ++i) {
                TopComponent topComponent = topComponentArray[i];
                if (topComponent.getName() == null || !topComponent.getName().equals(string)) continue;
                return topComponent;
            }
        }
        return null;
    }
}

