/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.util;

import cern.laser.client.data.Alarm;
import cern.laser.client.services.selection.AlarmSearchListener;
import cern.laser.client.services.selection.LaserSearchException;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.util.buffer.PullEvent;
import cern.laser.util.buffer.PullException;
import cern.laser.util.buffer.SynchroBuffer;
import cern.laser.util.buffer.SynchroBufferListener;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SearchProxyBuffer
implements AlarmSearchListener,
SynchroBufferListener {
    private static final Logger logger = LogFactory.getLogger(SearchProxyBuffer.class.getName());
    private SynchroBuffer buffer = new SynchroBuffer(200L, 2000L, 100, 1);
    private Vector listeners;
    private static SearchProxyBuffer INSTANCE = null;
    private boolean isSearchCancelled = false;

    public SearchProxyBuffer() {
        this.buffer.setSynchroBufferListener((SynchroBufferListener)this);
    }

    public void enable() {
        this.buffer.enable();
    }

    public void disable() {
        this.buffer.disable();
    }

    public void close() {
        this.buffer.close();
        this.listeners = null;
        INSTANCE = null;
    }

    public boolean isSearchCancelled() {
        return this.isSearchCancelled;
    }

    public static synchronized SearchProxyBuffer getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new SearchProxyBuffer();
        }
        return INSTANCE;
    }

    public void onSearchAlarm(Alarm alarm) {
        logger.debug((Object)("pushed: " + alarm.getTriplet().toString()));
        this.buffer.push((Object)alarm);
    }

    public void onSearchException(LaserSearchException laserSearchException) {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((AlarmSearchListener)iterator.next()).onSearchException(laserSearchException);
            }
        }
    }

    public void searchFinished() {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((AlarmSearchListener)iterator.next()).searchFinished();
            }
        }
    }

    public void searchCancelled() {
        this.isSearchCancelled = true;
    }

    public void pull(PullEvent pullEvent) throws PullException {
        if (this.listeners != null) {
            for (AlarmSearchListener alarmSearchListener : this.listeners) {
                Iterator iterator = pullEvent.getPulled().iterator();
                while (iterator.hasNext()) {
                    alarmSearchListener.onSearchAlarm((Alarm)iterator.next());
                }
            }
        }
    }

    public synchronized void registerAlarmSearchListener(AlarmSearchListener alarmSearchListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(alarmSearchListener);
    }

    public synchronized void unregisterAlarmSearchListener1(AlarmSearchListener alarmSearchListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(alarmSearchListener);
    }
}

