/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.explorer;

import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.explorer.ACTreeTableView;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import org.apache.log4j.Logger;
import org.openide.explorer.ExplorerPanel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public abstract class ACExplorer
extends ExplorerPanel {
    private ACTreeTableView view = null;
    private static Logger logger = LogFactory.getLogger(ACExplorer.class.getName());

    public ACExplorer(AlarmNodeManager alarmNodeManager, String[] stringArray) {
        super(alarmNodeManager.getExplorerManager());
        logger.debug((Object)"<begin> constructor");
        Node node = alarmNodeManager.getRootNode();
        this.view = new ACTreeTableView(node);
        this.view.setRootVisible(false);
        this.setTableColumns(stringArray);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)this.view));
        logger.debug((Object)"<end> constructor");
    }

    public void setTableColumns(String[] stringArray) {
        logger.debug((Object)"<begin> setTableColumns");
        String[] stringArray2 = new String[]{"date", "time", "faultFamily", "faultMember", "faultCode", "identifier", "priority", "sourceName"};
        stringArray = stringArray2;
        Node.Property[] propertyArray = new Node.Property[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class clazz;
            if (stringArray[i].equalsIgnoreCase("faultCode") || stringArray[i].equalsIgnoreCase("priority")) {
                clazz = Integer.class;
                logger.debug((Object)("property=" + stringArray[i] + " set to Integer class"));
            } else {
                clazz = String.class;
            }
            propertyArray[i] = new PropertySupport.ReadOnly(stringArray[i], clazz, NbBundle.getMessage(Constants.class, (String)(stringArray[i] + "_displayName")), NbBundle.getMessage(Constants.class, (String)(stringArray[i] + "_displayName"))){

                public Object getValue() {
                    return "";
                }
            };
        }
        this.view.setProperties(propertyArray);
        this.view.setRenderers();
        logger.debug((Object)"<end> setTableColumns");
    }

    public ACTreeTableView getView() {
        return this.view;
    }
}

