/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.explorer;

import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmBeanNode;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.util.buffer.PullEvent;
import cern.laser.util.buffer.PullException;
import cern.laser.util.buffer.SynchroBuffer;
import cern.laser.util.buffer.SynchroBufferListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ACChildrenMap
extends Children.SortedMap
implements Comparator,
SynchroBufferListener {
    private static Logger logger = LogFactory.getLogger(ACChildrenMap.class.getName());
    private SynchroBuffer buffer = null;

    public ACChildrenMap() {
        this.setComparator(this);
        this.buffer = new SynchroBuffer(200L, 2000L, 100, 2);
        this.buffer.setSynchroBufferListener((SynchroBufferListener)this);
        this.buffer.enable();
    }

    public int compare(Object object, Object object2) {
        try {
            AlarmBeanNode alarmBeanNode = (AlarmBeanNode)object;
            AlarmBeanNode alarmBeanNode2 = (AlarmBeanNode)object2;
            return alarmBeanNode.compareTo(alarmBeanNode2);
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)("ClassCastException, o1=" + object + " o2=" + object2));
            return 0;
        }
    }

    public boolean add(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            this.addNode(nodeArray[i]);
        }
        return true;
    }

    public boolean addNode(Node node) {
        AlarmBeanNode alarmBeanNode = (AlarmBeanNode)node;
        AlarmBean alarmBean = (AlarmBean)alarmBeanNode.getBean();
        this.addNode(alarmBean.getAlarmId(), (Node)alarmBeanNode);
        return true;
    }

    public void addNode(Object object, Node node) {
        NTI nTI = new NTI(1, (String)object, node);
        this.buffer.push((Object)nTI);
    }

    public synchronized void addNodes(Map map) {
        super.putAll(map);
    }

    public synchronized Node getNode(Object object) {
        return (Node)this.nodes.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Map map = this.nodes;
        synchronized (map) {
            return this.nodes.keySet();
        }
    }

    public Node removeNode(Object object) {
        Node node = this.getNode(object);
        NTI nTI = new NTI(2, (String)object, object);
        this.buffer.push((Object)nTI);
        return node;
    }

    public synchronized void removeNodes(Collection collection) {
        super.removeAll(collection);
    }

    public void clear() {
        this.nodes.clear();
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Map map = this.nodes;
        synchronized (map) {
            return this.nodes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map map = this.nodes;
        synchronized (map) {
            return this.nodes.toString();
        }
    }

    protected Map initMap() {
        return new HashMap(1009);
    }

    public void pull(PullEvent pullEvent) throws PullException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(7);
        Vector<String> vector = new Vector<String>();
        for (NTI nTI : pullEvent.getPulled()) {
            if (nTI.getType() == 1) {
                hashMap.put(nTI.getAlarmId(), nTI.getObject());
                continue;
            }
            vector.add(nTI.getAlarmId());
        }
        this.addNodes(hashMap);
        this.removeNodes(vector);
    }

    protected class NTI
    implements Comparator {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        private int type;
        private String alarm_id;
        private Object object;
        private long timestamp;

        public NTI() {
        }

        public NTI(int n, String string, Object object) {
            this.type = n;
            this.alarm_id = string;
            this.object = object;
            this.timestamp = System.currentTimeMillis();
        }

        public int getType() {
            return this.type;
        }

        public String getAlarmId() {
            return this.alarm_id;
        }

        public Object getObject() {
            return this.object;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            NTI nTI = (NTI)object;
            NTI nTI2 = (NTI)object2;
            if (nTI.getTimestamp() < nTI2.getTimestamp()) {
                return -1;
            }
            if (nTI.getTimestamp() > nTI2.getTimestamp()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "TYPE      = " + this.type + "\n" + "ALARM_ID  = " + this.alarm_id + "\n" + "OBJECT    = " + this.object + "\n" + "TIMESTAMP = " + this.timestamp + "\n" + "====================================";
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || !(object instanceof NTI)) {
                return false;
            }
            NTI nTI = (NTI)object;
            return this.getAlarmId().equals(nTI.getAlarmId());
        }

        public int hashCode() {
            return this.getAlarmId().hashCode();
        }
    }
}

