/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.category;

import cern.gp.beans.BeanSupport;
import cern.gp.beans.PropertyInfo;
import cern.laser.client.data.Category;
import cern.laser.guiplatform.actions.category.AddCategoryAction;
import cern.laser.guiplatform.actions.category.AddSubCategoriesAction;
import cern.laser.guiplatform.actions.category.DeleteAllChoosenCategoryAction;
import cern.laser.guiplatform.actions.category.DeleteChoosenCategoryAction;
import cern.laser.guiplatform.actions.category.RemoveCategoryAction;
import cern.laser.guiplatform.actions.category.RemoveSubCategoriesAction;
import cern.laser.guiplatform.actions.category.ShowAlarmByCategoryAction;
import cern.laser.guiplatform.util.LogFactory;
import java.awt.Image;
import org.apache.log4j.Logger;
import org.openide.util.Utilities;

public class CategoryBean
extends BeanSupport
implements Cloneable {
    static Logger logger = LogFactory.getLogger(CategoryBean.class.getName());
    private Category category = null;
    private static final String[] nodeActions = new String[]{AddCategoryAction.class.getName(), AddSubCategoriesAction.class.getName(), null, RemoveCategoryAction.class.getName(), RemoveSubCategoriesAction.class.getName(), null, ShowAlarmByCategoryAction.class.getName()};
    private static final String[] clonedNodeActions = new String[]{DeleteChoosenCategoryAction.class.getName(), DeleteAllChoosenCategoryAction.class.getName(), null, ShowAlarmByCategoryAction.class.getName()};
    private static final String defaultNodeActionSelected = RemoveCategoryAction.class.getName();
    private static final String defaultNodeActionNotSelected = AddCategoryAction.class.getName();
    private static final String defaultClonedNodeAction = RemoveCategoryAction.class.getName();
    private boolean isCloned = false;
    public static final int STATE_CHILDREN_NOT_SELECTED = 1;
    public static final int STATE_CHILDREN_PARTIALY_SELECTED = 2;
    public static final int STATE_CHILDREN_ALL_SELECTED = 3;
    private int childrenSelectionState = 1;
    private boolean isSelected = false;

    public CategoryBean(Category category) {
        this.category = category;
    }

    public void setSelected(boolean bl) {
        this.isSelected = bl;
        this.fireNodeIconPropertyChange(this.getNodeIcon());
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setChildrenSelectionState(int n) {
        this.childrenSelectionState = n;
        this.fireNodeIconPropertyChange(this.getNodeIcon());
    }

    public int getChildrenSelectionState() {
        return this.childrenSelectionState;
    }

    public Category getCategory() {
        return this.category;
    }

    public Image getNodeIcon() {
        if (this.isCloned) {
            return Utilities.loadImage((String)"cern/laser/guiplatform/images/category_selected_nochildren.gif");
        }
        Image image = null;
        switch (this.getChildrenSelectionState()) {
            case 1: {
                if (this.isSelected()) {
                    image = Utilities.loadImage((String)"cern/laser/guiplatform/images/category_selected_nochildren.gif");
                    break;
                }
                image = Utilities.loadImage((String)"cern/laser/guiplatform/images/category_notselected_nochildren.gif");
                break;
            }
            case 2: {
                if (this.isSelected()) {
                    image = Utilities.loadImage((String)"cern/laser/guiplatform/images/category_selected_partchildren.gif");
                    break;
                }
                image = Utilities.loadImage((String)"cern/laser/guiplatform/images/category_notselected_partchildren.gif");
                break;
            }
            case 3: {
                image = this.isSelected() ? Utilities.loadImage((String)"cern/laser/guiplatform/images/category_selected_allchildren.gif") : Utilities.loadImage((String)"cern/laser/guiplatform/images/category_notselected_allchildren.gif");
            }
        }
        if (image == null) {
            return super.getNodeIcon();
        }
        return image;
    }

    public String getName() {
        return this.category.getName();
    }

    public String getPath() {
        return this.category.getPath();
    }

    public String getDisplayName() {
        return this.category.getName();
    }

    public Integer getCategoryId() {
        return this.category.getCategoryId();
    }

    public String getShortDescription() {
        return this.category.getDescription();
    }

    public String[] getNodeActions() {
        if (!this.isCloned) {
            return nodeActions;
        }
        return clonedNodeActions;
    }

    public String getNodeDefaultAction() {
        if (!this.isCloned) {
            if (!this.isSelected()) {
                return defaultNodeActionNotSelected;
            }
            return defaultNodeActionSelected;
        }
        return defaultClonedNodeAction;
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryBean categoryBean = new CategoryBean(this.category);
        categoryBean.setCloned();
        return categoryBean;
    }

    public void setCloned() {
        this.isCloned = true;
    }

    public PropertyInfo[] getPropertyInfo() {
        return new PropertyInfo[0];
    }
}

