/*
 * Decompiled with CFR 0.152.
 */
package cern.laser.guiplatform.category;

import cern.laser.client.LaserException;
import cern.laser.client.data.Category;
import cern.laser.guiplatform.category.CategoryBrowsingHandlerFactory;
import cern.laser.guiplatform.util.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CategoriesPreLoader {
    private static CategoriesPreLoader INSTANCE = null;
    private Logger logger = LogFactory.getLogger(CategoriesPreLoader.class.getName());
    private HashMap categories = new HashMap();

    public CategoriesPreLoader() {
        this.loadCategories();
    }

    public static synchronized CategoriesPreLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CategoriesPreLoader();
        }
        return INSTANCE;
    }

    public boolean isLoaded(Category category) {
        return this.categories.containsKey(category.getCategoryId());
    }

    public void loadCategories() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Category category = CategoryBrowsingHandlerFactory.getHandler().getCategoryTreeRoot();
                    CategoriesPreLoader.this.loadCategory(category);
                    CategoriesPreLoader.this.logger.debug((Object)"Categories Pre Loading finished");
                }
                catch (LaserException laserException) {
                    CategoriesPreLoader.this.logger.debug((Object)laserException.getMessage(), (Throwable)laserException);
                }
            }
        };
        new Thread(runnable).start();
    }

    public Collection getChildren(Category category) {
        CategoryItem categoryItem = (CategoryItem)this.categories.get(category.getCategoryId());
        return categoryItem.getChildren();
    }

    private void loadCategory(Category category) {
        try {
            Collection collection = CategoryBrowsingHandlerFactory.getHandler().getChildren(category);
            CategoryItem categoryItem = new CategoryItem(category, collection);
            this.categories.put(category.getCategoryId(), categoryItem);
            for (Category category2 : collection) {
                this.loadCategory(category2);
            }
        }
        catch (LaserException laserException) {
            this.logger.debug((Object)laserException.getMessage(), (Throwable)laserException);
        }
    }

    class CategoryItem {
        private Category category;
        private Collection children;

        public CategoryItem(Category category, Collection collection) {
            this.category = category;
            this.children = collection;
        }

        public Collection getChildren() {
            return this.children;
        }
    }
}

